/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.cache;

import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.Serializable;
import java.util.Locale;

public final class CacheKey
implements Serializable {
    private static final long serialVersionUID = 8067972995583126404L;
    static final String FRT_ENTRY_PREFIX = "foci-";
    private String mAuthority;
    private String mResource;
    private String mClientId;
    private String mUserId;
    private String mFamilyClientId;
    private boolean mIsMultipleResourceRefreshToken;

    private CacheKey() {
    }

    public String toString() {
        if (StringExtensions.isNullOrBlank(this.mFamilyClientId)) {
            return String.format(Locale.US, "%s$%s$%s$%s$%s", this.mAuthority, this.mResource, this.mClientId, this.mIsMultipleResourceRefreshToken ? "y" : "n", this.mUserId);
        }
        return String.format(Locale.US, "%s$%s$%s$%s$%s$%s", this.mAuthority, this.mResource, this.mClientId, this.mIsMultipleResourceRefreshToken ? "y" : "n", this.mUserId, this.mFamilyClientId);
    }

    public static String createCacheKey(String authority, String resource, String clientId, boolean isMultiResourceRefreshToken, String userId, String familyClientId) {
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        if (clientId == null && familyClientId == null) {
            throw new IllegalArgumentException("both clientId and familyClientId are null");
        }
        CacheKey key = new CacheKey();
        if (!isMultiResourceRefreshToken) {
            if (resource == null) {
                throw new IllegalArgumentException("resource");
            }
            key.mResource = resource;
        }
        key.mAuthority = authority.toLowerCase(Locale.US);
        if (key.mAuthority.endsWith("/")) {
            key.mAuthority = (String)key.mAuthority.subSequence(0, key.mAuthority.length() - 1);
        }
        if (clientId != null) {
            key.mClientId = clientId.toLowerCase(Locale.US);
        }
        if (familyClientId != null) {
            String prefixedFamilyClient = FRT_ENTRY_PREFIX + familyClientId;
            key.mFamilyClientId = prefixedFamilyClient.toLowerCase(Locale.US);
        }
        key.mIsMultipleResourceRefreshToken = isMultiResourceRefreshToken;
        if (!StringExtensions.isNullOrBlank(userId)) {
            key.mUserId = userId.toLowerCase(Locale.US);
        }
        return key.toString();
    }

    public static String createCacheKeyForRTEntry(String authority, String resource, String clientId, String userId) {
        return CacheKey.createCacheKey(authority, resource, clientId, false, userId, null);
    }

    public static String createCacheKeyForMRRT(String authority, String clientId, String userId) {
        return CacheKey.createCacheKey(authority, null, clientId, true, userId, null);
    }

    public static String createCacheKeyForFRT(String authority, String familyClientId, String userId) {
        return CacheKey.createCacheKey(authority, null, null, true, userId, familyClientId);
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getResource() {
        return this.mResource;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public String getUserId() {
        return this.mUserId;
    }

    public boolean getIsMultipleResourceRefreshToken() {
        return this.mIsMultipleResourceRefreshToken;
    }
}

