/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.net.Uri;
import android.util.Pair;
import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAuthorizationRequest;
import java.io.UnsupportedEncodingException;
import java.util.Map;

public class MicrosoftStsAuthorizationRequest
extends MicrosoftAuthorizationRequest<MicrosoftStsAuthorizationRequest> {
    private static final long serialVersionUID = 6545759826515911472L;
    private static final String AUTHORIZATION_ENDPOINT = "/oAuth2/v2.0/authorize";
    @SerializedName(value="prompt")
    private String mPrompt;
    @SerializedName(value="login_req")
    private String mUid;
    @SerializedName(value="domain_req")
    private String mUtid;
    private transient String mDisplayableId;

    protected MicrosoftStsAuthorizationRequest(Builder builder) {
        super(builder);
        this.mPrompt = builder.mPrompt;
        this.mUid = builder.mUid;
        this.mUtid = builder.mUtid;
        this.mDisplayableId = builder.mDisplayableId;
    }

    public String getUid() {
        return this.mUid;
    }

    public String getUtid() {
        return this.mUtid;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    public String getPrompt() {
        return this.mPrompt;
    }

    @Override
    public Uri getAuthorizationRequestAsHttpRequest() throws UnsupportedEncodingException {
        Uri.Builder uriBuilder = Uri.parse((String)this.getAuthorizationEndpoint()).buildUpon();
        for (Map.Entry<String, String> entry : ObjectMapper.serializeObjectHashMap(this).entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        if (null != this.getExtraQueryParams() && !this.getExtraQueryParams().isEmpty()) {
            for (Pair pair : this.getExtraQueryParams()) {
                uriBuilder.appendQueryParameter((String)pair.first, (String)pair.second);
            }
        }
        for (Map.Entry<String, String> entry : this.mFlightParameters.entrySet()) {
            uriBuilder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        if (this.mSlice != null) {
            uriBuilder.appendQueryParameter("slice", this.mSlice.getSlice());
            uriBuilder.appendQueryParameter("dc", this.mSlice.getDC());
        }
        return uriBuilder.build();
    }

    @Override
    public String getAuthorizationEndpoint() {
        Uri authorityUri = Uri.parse((String)this.getAuthority().toString());
        Uri endpointUri = authorityUri.buildUpon().appendPath(AUTHORIZATION_ENDPOINT).build();
        return endpointUri.toString();
    }

    public static class Builder
    extends MicrosoftAuthorizationRequest.Builder<Builder> {
        private String mUid;
        private String mUtid;
        private String mDisplayableId;

        public Builder setUid(String uid) {
            this.mUid = uid;
            return this.self();
        }

        public Builder setUtid(String utid) {
            this.mUtid = utid;
            return this.self();
        }

        public Builder setDisplayableId(String displayableId) {
            this.mDisplayableId = displayableId;
            return this.self();
        }

        @Override
        public Builder self() {
            return this;
        }

        @Override
        public MicrosoftStsAuthorizationRequest build() {
            this.setLibraryName("MSAL.Android");
            this.setLibraryVersion("0.2.1");
            return new MicrosoftStsAuthorizationRequest(this);
        }
    }

    public static final class Prompt {
        public static final String SELECT_ACCOUNT = "select_account";
        public static final String FORCE_LOGIN = "login";
        public static final String CONSENT = "consent";
    }
}

