/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.microsoft.identity.common.adal.internal.cache.IStorageHelper;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.cache.ISharedPreferencesFileManager;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Map;

public class SharedPreferencesFileManager
implements ISharedPreferencesFileManager {
    private static final String TAG = SharedPreferencesFileManager.class.getSimpleName();
    private final String mSharedPreferencesFileName;
    private final SharedPreferences mSharedPreferences;
    private final IStorageHelper mStorageHelper;

    public SharedPreferencesFileManager(Context context, String name) {
        Logger.verbose(TAG, "Init: " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, 0);
        this.mStorageHelper = null;
    }

    public SharedPreferencesFileManager(Context context, String name, int operatingMode) {
        Logger.verbose(TAG, "Init with operating mode: " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, operatingMode);
        this.mStorageHelper = null;
    }

    public SharedPreferencesFileManager(Context context, String name, IStorageHelper storageHelper) {
        Logger.verbose(TAG, "Init with storage helper:  " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, 0);
        this.mStorageHelper = storageHelper;
    }

    public SharedPreferencesFileManager(Context context, String name, int operatingMode, IStorageHelper storageHelper) {
        Logger.verbose(TAG, "Init with operating mode and storage helper " + TAG);
        this.mSharedPreferencesFileName = name;
        this.mSharedPreferences = context.getSharedPreferences(name, operatingMode);
        this.mStorageHelper = storageHelper;
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public final void putString(String key, String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        if (null == this.mStorageHelper) {
            editor.putString(key, value);
        } else {
            editor.putString(key, this.encrypt(value));
        }
        editor.commit();
    }

    @Override
    public final String getString(String key) {
        String restoredValue = this.mSharedPreferences.getString(key, null);
        if (null != this.mStorageHelper && !StringExtensions.isNullOrBlank(restoredValue)) {
            restoredValue = this.decrypt(restoredValue);
        }
        return restoredValue;
    }

    @Override
    public final String getSharedPreferencesFileName() {
        return this.mSharedPreferencesFileName;
    }

    @Override
    public final Map<String, String> getAll() {
        Map entries = this.mSharedPreferences.getAll();
        if (null != this.mStorageHelper) {
            for (Map.Entry entry : entries.entrySet()) {
                entry.setValue(this.decrypt((String)entry.getValue()));
            }
        }
        return entries;
    }

    @Override
    public final boolean contains(String key) {
        boolean contains = this.mSharedPreferences.contains(key);
        return contains;
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public final void clear() {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    @Override
    @SuppressLint(value={"ApplySharedPref"})
    public void remove(String key) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.remove(key);
        editor.commit();
    }

    private String encrypt(String clearText) {
        String encryptedValue = this.encryptDecryptInternal(clearText, true);
        return encryptedValue;
    }

    private String decrypt(String encryptedBlob) {
        String decryptedValue = this.encryptDecryptInternal(encryptedBlob, false);
        return decryptedValue;
    }

    private String encryptDecryptInternal(String inputText, boolean encrypt) {
        String result;
        String methodName = "encryptDecryptInternal";
        try {
            result = encrypt ? this.mStorageHelper.encrypt(inputText) : this.mStorageHelper.decrypt(inputText);
        }
        catch (IOException | GeneralSecurityException e) {
            Logger.error(TAG + ":" + "encryptDecryptInternal", "Failed to " + (encrypt ? "encrypt" : "decrypt") + " value", null);
            result = null;
        }
        return result;
    }
}

