/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.CacheRecord;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdTokenRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MsalOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends TokenResponse, GenericAccount extends BaseAccount, GenericRefreshToken extends RefreshToken>
extends OAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse>
implements IShareSingleSignOnState<GenericAccount, GenericRefreshToken> {
    private static final String TAG = MsalOAuth2TokenCache.class.getSimpleName();
    private IAccountCredentialCache mAccountCredentialCache;
    private final IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> mAccountCredentialAdapter;

    public MsalOAuth2TokenCache(Context context, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> accountCredentialAdapter) {
        super(context);
        Logger.verbose(TAG, "Init: " + TAG);
        this.mAccountCredentialCache = accountCredentialCache;
        this.mAccountCredentialAdapter = accountCredentialAdapter;
    }

    @Override
    public ICacheRecord save(@NonNull GenericOAuth2Strategy oAuth2Strategy, @NonNull GenericAuthorizationRequest request, @NonNull GenericTokenResponse response) throws ClientException {
        String methodName = ":save";
        AccountRecord accountToSave = this.mAccountCredentialAdapter.createAccount(oAuth2Strategy, request, response);
        AccessTokenRecord accessTokenToSave = this.mAccountCredentialAdapter.createAccessToken(oAuth2Strategy, request, response);
        RefreshTokenRecord refreshTokenToSave = this.mAccountCredentialAdapter.createRefreshToken(oAuth2Strategy, request, response);
        IdTokenRecord idTokenToSave = this.mAccountCredentialAdapter.createIdToken(oAuth2Strategy, request, response);
        this.validateCacheArtifacts(accountToSave, accessTokenToSave, refreshTokenToSave, idTokenToSave);
        boolean isMultiResourceCapable = "MSSTS".equals(accountToSave.getAuthorityType());
        Logger.info(TAG + ":save", "isMultiResourceCapable? [" + isMultiResourceCapable + "]");
        if (isMultiResourceCapable) {
            int refreshTokensRemoved = this.removeCredentialsOfTypeForAccount(accountToSave.getEnvironment(), refreshTokenToSave.getClientId(), CredentialType.RefreshToken, accountToSave);
            Logger.info(TAG + ":save", "Refresh tokens removed: [" + refreshTokensRemoved + "]");
            if (refreshTokensRemoved > 1) {
                Logger.warn(TAG + ":save", "Multiple refresh tokens found for Account.");
            }
        }
        this.saveAccounts(accountToSave);
        this.saveCredentials(accessTokenToSave, refreshTokenToSave, idTokenToSave);
        CacheRecord result = new CacheRecord();
        result.setAccount(accountToSave);
        result.setAccessToken(accessTokenToSave);
        result.setRefreshToken(refreshTokenToSave);
        result.setIdToken(idTokenToSave);
        return result;
    }

    @Override
    public ICacheRecord load(@NonNull String clientId, @Nullable String target, @NonNull AccountRecord account) {
        boolean isMultiResourceCapable = "MSSTS".equals(account.getAuthorityType());
        List<Credential> accessTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.AccessToken, clientId, account.getRealm(), target);
        List<Credential> refreshTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.RefreshToken, clientId, isMultiResourceCapable ? null : account.getRealm(), isMultiResourceCapable ? null : target);
        List<Credential> idTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(account.getHomeAccountId(), account.getEnvironment(), CredentialType.IdToken, clientId, account.getRealm(), null);
        CacheRecord result = new CacheRecord();
        result.setAccount(account);
        result.setAccessToken(accessTokens.isEmpty() ? null : (AccessTokenRecord)accessTokens.get(0));
        result.setRefreshToken(refreshTokens.isEmpty() ? null : (RefreshTokenRecord)refreshTokens.get(0));
        result.setIdToken(idTokens.isEmpty() ? null : (IdTokenRecord)idTokens.get(0));
        return result;
    }

    @Override
    public boolean removeCredential(Credential credential) {
        String methodName = ":removeCredential";
        Logger.info(TAG + ":removeCredential", "Removing credential...");
        Logger.infoPII(TAG + ":removeCredential", "ClientId: [" + credential.getClientId() + "]");
        Logger.infoPII(TAG + ":removeCredential", "CredentialType: [" + credential.getCredentialType() + "]");
        Logger.infoPII(TAG + ":removeCredential", "CachedAt: [" + credential.getCachedAt() + "]");
        Logger.infoPII(TAG + ":removeCredential", "Environment: [" + credential.getEnvironment() + "]");
        Logger.infoPII(TAG + ":removeCredential", "HomeAccountId: [" + credential.getHomeAccountId() + "]");
        Logger.infoPII(TAG + ":removeCredential", "IsExpired?: [" + credential.isExpired() + "]");
        return this.mAccountCredentialCache.removeCredential(credential);
    }

    @Override
    public AccountRecord getAccount(@Nullable String environment, @NonNull String clientId, @NonNull String homeAccountId) {
        String methodName = ":getAccount";
        Logger.infoPII(TAG + ":getAccount", "Environment: [" + environment + "]");
        Logger.infoPII(TAG + ":getAccount", "ClientId: [" + clientId + "]");
        Logger.infoPII(TAG + ":getAccount", "HomeAccountId: [" + homeAccountId + "]");
        List<AccountRecord> allAccounts = this.getAccounts(environment, clientId);
        Logger.info(TAG + ":getAccount", "Found " + allAccounts.size() + " accounts");
        for (AccountRecord account : allAccounts) {
            if (!homeAccountId.equals(account.getHomeAccountId())) continue;
            return account;
        }
        Logger.warn(TAG + ":getAccount", "No matching account found.");
        return null;
    }

    @Override
    public List<AccountRecord> getAccounts(@Nullable String environment, @NonNull String clientId) {
        String methodName = ":getAccounts";
        Logger.infoPII(TAG + ":getAccounts", "Environment: [" + environment + "]");
        Logger.infoPII(TAG + ":getAccounts", "ClientId: [" + clientId + "]");
        ArrayList<AccountRecord> accountsForThisApp = new ArrayList<AccountRecord>();
        List<AccountRecord> accountsForEnvironment = this.mAccountCredentialCache.getAccountsFilteredBy(null, environment, null);
        Logger.info(TAG + ":getAccounts", "Found " + accountsForEnvironment.size() + " accounts for this environment");
        List<Credential> appCredentials = this.mAccountCredentialCache.getCredentialsFilteredBy(null, environment, CredentialType.RefreshToken, clientId, null, null);
        for (AccountRecord account : accountsForEnvironment) {
            if (!this.accountHasCredential(account, appCredentials)) continue;
            accountsForThisApp.add(account);
        }
        Logger.info(TAG + ":getAccounts", "Found " + accountsForThisApp.size() + " accounts for this clientId");
        return Collections.unmodifiableList(accountsForThisApp);
    }

    private boolean accountHasCredential(@NonNull AccountRecord account, @NonNull List<Credential> appCredentials) {
        String methodName = ":accountHasCredential";
        String accountHomeId = account.getHomeAccountId();
        String accountEnvironment = account.getEnvironment();
        Logger.infoPII(TAG + ":accountHasCredential", "HomeAccountId: [" + accountHomeId + "]");
        Logger.infoPII(TAG + ":accountHasCredential", "Environment: [" + accountEnvironment + "]");
        for (Credential credential : appCredentials) {
            if (!accountHomeId.equals(credential.getHomeAccountId()) || !accountEnvironment.equals(credential.getEnvironment())) continue;
            Logger.info(TAG + ":accountHasCredential", "Credentials located for account.");
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAccount(String environment, String clientId, String homeAccountId) {
        String[][] logInfo;
        AccountRecord targetAccount;
        String methodName = ":removeAccount";
        Logger.infoPII(TAG + ":removeAccount", "Environment: [" + environment + "]");
        Logger.infoPII(TAG + ":removeAccount", "ClientId: [" + clientId + "]");
        Logger.infoPII(TAG + ":removeAccount", "HomeAccountId: [" + homeAccountId + "]");
        if (null == environment || null == clientId || null == homeAccountId || null == (targetAccount = this.getAccount(environment, clientId, homeAccountId))) {
            return false;
        }
        int atsRemoved = this.removeCredentialsOfTypeForAccount(environment, clientId, CredentialType.AccessToken, targetAccount);
        int rtsRemoved = this.removeCredentialsOfTypeForAccount(environment, clientId, CredentialType.RefreshToken, targetAccount);
        int idsRemoved = this.removeCredentialsOfTypeForAccount(environment, clientId, CredentialType.IdToken, targetAccount);
        boolean accountRemoved = this.mAccountCredentialCache.removeAccount(targetAccount);
        for (String[] tuple : logInfo = new String[][]{{"Access tokens", String.valueOf(atsRemoved)}, {"Refresh tokens", String.valueOf(rtsRemoved)}, {"Id tokens", String.valueOf(idsRemoved)}, {"Accounts", accountRemoved ? "1" : "0"}}) {
            Logger.info(TAG + ":removeAccount", tuple[0] + " removed: [" + tuple[1] + "]");
        }
        return accountRemoved;
    }

    private int removeCredentialsOfTypeForAccount(@NonNull String environment, @NonNull String clientId, @NonNull CredentialType credentialType, @NonNull AccountRecord targetAccount) {
        int credentialsRemoved = 0;
        List<Credential> credentialsToRemove = this.mAccountCredentialCache.getCredentialsFilteredBy(targetAccount.getHomeAccountId(), environment, credentialType, clientId, null, null);
        for (Credential credentialToRemove : credentialsToRemove) {
            if (!this.mAccountCredentialCache.removeCredential(credentialToRemove)) continue;
            ++credentialsRemoved;
        }
        return credentialsRemoved;
    }

    private void saveAccounts(AccountRecord ... accounts) {
        for (AccountRecord account : accounts) {
            this.mAccountCredentialCache.saveAccount(account);
        }
    }

    private void saveCredentials(Credential ... credentials) {
        for (Credential credential : credentials) {
            if (credential instanceof AccessTokenRecord) {
                this.deleteAccessTokensWithIntersectingScopes((AccessTokenRecord)credential);
            }
            this.mAccountCredentialCache.saveCredential(credential);
        }
    }

    private void validateCacheArtifacts(@NonNull AccountRecord accountToSave, AccessTokenRecord accessTokenToSave, @NonNull RefreshTokenRecord refreshTokenToSave, @NonNull IdTokenRecord idTokenToSave) throws ClientException {
        String methodName = ":validateCacheArtifacts";
        Logger.info(TAG + ":validateCacheArtifacts", "Validating cache artifacts...");
        boolean isAccountCompliant = this.isAccountSchemaCompliant(accountToSave);
        boolean isAccessTokenCompliant = null == accessTokenToSave || this.isAccessTokenSchemaCompliant(accessTokenToSave);
        boolean isRefreshTokenCompliant = this.isRefreshTokenSchemaCompliant(refreshTokenToSave);
        boolean isIdTokenCompliant = this.isIdTokenSchemaCompliant(idTokenToSave);
        if (!isAccountCompliant) {
            throw new ClientException("Account is missing schema-required fields.");
        }
        if (!(isAccessTokenCompliant && isRefreshTokenCompliant && isIdTokenCompliant)) {
            String nonCompliantCredentials = "[";
            if (!isAccessTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(AT)";
            }
            if (!isRefreshTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(RT)";
            }
            if (!isIdTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(ID)";
            }
            nonCompliantCredentials = nonCompliantCredentials + "]";
            throw new ClientException("Credential is missing schema-required fields.", nonCompliantCredentials);
        }
    }

    private void deleteAccessTokensWithIntersectingScopes(AccessTokenRecord referenceToken) {
        String methodName = "deleteAccessTokensWithIntersectingScopes";
        List<Credential> accessTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(referenceToken.getHomeAccountId(), referenceToken.getEnvironment(), CredentialType.AccessToken, referenceToken.getClientId(), referenceToken.getRealm(), null);
        Logger.verbose(TAG + ":" + "deleteAccessTokensWithIntersectingScopes", "Inspecting " + accessTokens.size() + " accessToken[s].");
        for (Credential accessToken : accessTokens) {
            if (!this.scopesIntersect(referenceToken, (AccessTokenRecord)accessToken)) continue;
            Logger.infoPII(TAG + ":" + "deleteAccessTokensWithIntersectingScopes", "Removing credential: " + accessToken);
            this.mAccountCredentialCache.removeCredential(accessToken);
        }
    }

    private boolean scopesIntersect(AccessTokenRecord token1, AccessTokenRecord token2) {
        String methodName = "scopesIntersect";
        Set<String> token1Scopes = this.scopesAsSet(token1);
        Set<String> token2Scopes = this.scopesAsSet(token2);
        boolean result = false;
        for (String scope : token2Scopes) {
            if (!token1Scopes.contains(scope)) continue;
            Logger.info(TAG + ":" + "scopesIntersect", "Scopes intersect.");
            Logger.infoPII(TAG + ":" + "scopesIntersect", token1Scopes.toString() + " contains [" + scope + "]");
            result = true;
            break;
        }
        return result;
    }

    private Set<String> scopesAsSet(AccessTokenRecord token) {
        HashSet<String> scopeSet = new HashSet<String>();
        String scopeString = token.getTarget();
        if (!StringExtensions.isNullOrBlank(scopeString)) {
            String[] scopeArray = scopeString.split("\\s+");
            scopeSet.addAll(Arrays.asList(scopeArray));
        }
        return scopeSet;
    }

    private static boolean isSchemaCompliant(Class<?> clazz, String[][] params) {
        String methodName = "isSchemaCompliant";
        boolean isCompliant = true;
        for (String[] param : params) {
            isCompliant = isCompliant && !StringExtensions.isNullOrBlank(param[1]);
        }
        if (!isCompliant) {
            Logger.warn(TAG + ":" + "isSchemaCompliant", clazz.getSimpleName() + " does not contain all required fields.");
            for (String[] param : params) {
                Logger.warn(TAG + ":" + "isSchemaCompliant", param[0] + " is null? [" + StringExtensions.isNullOrBlank(param[1]) + "]");
            }
        }
        return isCompliant;
    }

    private boolean isAccountSchemaCompliant(@NonNull AccountRecord account) {
        String[][] params = new String[][]{{"home_account_id", account.getHomeAccountId()}, {"environment", account.getEnvironment()}, {"local_account_id", account.getLocalAccountId()}, {"username", account.getUsername()}, {"authority_type", account.getAuthorityType()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(account.getClass(), params);
    }

    private boolean isAccessTokenSchemaCompliant(@NonNull AccessTokenRecord accessToken) {
        String[][] params = new String[][]{{"credential_type", accessToken.getCredentialType()}, {"home_account_id", accessToken.getHomeAccountId()}, {"environment", accessToken.getEnvironment()}, {"client_id", accessToken.getClientId()}, {"target", accessToken.getTarget()}, {"cached_at", accessToken.getCachedAt()}, {"expires_on", accessToken.getExpiresOn()}, {"secret", accessToken.getSecret()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(accessToken.getClass(), params);
    }

    private boolean isRefreshTokenSchemaCompliant(@NonNull RefreshTokenRecord refreshToken) {
        String[][] params = new String[][]{{"credential_type", refreshToken.getCredentialType()}, {"environment", refreshToken.getEnvironment()}, {"home_account_id", refreshToken.getHomeAccountId()}, {"client_id", refreshToken.getClientId()}, {"secret", refreshToken.getSecret()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(refreshToken.getClass(), params);
    }

    private boolean isIdTokenSchemaCompliant(@NonNull IdTokenRecord idToken) {
        String[][] params = new String[][]{{"home_account_id", idToken.getHomeAccountId()}, {"environment", idToken.getEnvironment()}, {"credential_type", idToken.getCredentialType()}, {"client_id", idToken.getClientId()}, {"secret", idToken.getSecret()}};
        return MsalOAuth2TokenCache.isSchemaCompliant(idToken.getClass(), params);
    }

    @Override
    public void setSingleSignOnState(GenericAccount account, GenericRefreshToken refreshToken) {
        String methodName = "setSingleSignOnState";
        try {
            AccountRecord accountDto = this.mAccountCredentialAdapter.asAccount(account);
            RefreshTokenRecord rt = this.mAccountCredentialAdapter.asRefreshToken(refreshToken);
            IdTokenRecord idToken = this.mAccountCredentialAdapter.asIdToken(account, refreshToken);
            this.validateCacheArtifacts(accountDto, null, rt, idToken);
            this.mAccountCredentialCache.saveAccount(accountDto);
            this.mAccountCredentialCache.saveCredential(idToken);
            this.mAccountCredentialCache.saveCredential(rt);
        }
        catch (ClientException e) {
            Logger.error(TAG + ":" + "setSingleSignOnState", "", new IllegalArgumentException("Cannot set SSO state. Invalid or inadequate Account and/or token provided. (See logs)", e));
        }
    }

    @Override
    public GenericRefreshToken getSingleSignOnState(GenericAccount account) {
        throw new UnsupportedOperationException("Unimplemented!");
    }
}

