/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.exception;

import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.exception.BaseException;
import java.util.HashMap;
import java.util.List;
import org.json.JSONException;

public class ServiceException
extends BaseException {
    private int mHttpStatusCode;
    private HashMap<String, String> mHttpResponseBody = null;
    private HashMap<String, List<String>> mHttpResponseHeaders = null;
    static final int DEFAULT_STATUS_CODE = 0;

    public int getHttpStatusCode() {
        return this.mHttpStatusCode;
    }

    public HashMap<String, String> getHttpResponseBody() {
        return this.mHttpResponseBody;
    }

    public HashMap<String, List<String>> getHttpResponseHeaders() {
        return this.mHttpResponseHeaders;
    }

    public void setHttpResponse(HttpWebResponse response) {
        if (null != response) {
            this.mHttpStatusCode = response.getStatusCode();
            if (null != response.getResponseHeaders()) {
                this.mHttpResponseHeaders = new HashMap<String, List<String>>(response.getResponseHeaders());
            }
            if (null != response.getBody()) {
                try {
                    this.mHttpResponseBody = new HashMap<String, String>(HashMapExtensions.getJsonResponse(response));
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
            }
        }
    }

    public ServiceException(String errorCode, String errorMessage, Throwable throwable) {
        super(errorCode, errorMessage, throwable);
        this.mHttpStatusCode = 0;
    }

    public ServiceException(String errorCode, String errorMessage, int httpStatusCode, Throwable throwable) {
        super(errorCode, errorMessage, throwable);
        this.mHttpStatusCode = httpStatusCode;
    }
}

