/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class AuthorizationResultFuture
implements Future<AuthorizationResult> {
    private final CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private AuthorizationResult mAuthorizationResult;

    @Override
    public boolean cancel(boolean b) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.mCountDownLatch.getCount() == 0L;
    }

    @Override
    public AuthorizationResult get() throws InterruptedException, ExecutionException {
        this.mCountDownLatch.await();
        return this.mAuthorizationResult;
    }

    @Override
    public AuthorizationResult get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.mCountDownLatch.await(l, timeUnit)) {
            return this.mAuthorizationResult;
        }
        throw new TimeoutException();
    }

    public void setAuthorizationResult(AuthorizationResult result) {
        this.mAuthorizationResult = result;
        this.mCountDownLatch.countDown();
    }
}

