/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.webview.AzureActiveDirectoryWebViewClient;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeCompletionCallback;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.Serializable;

public final class AuthorizationActivity
extends Activity {
    @VisibleForTesting
    static final String KEY_AUTH_INTENT = "authIntent";
    @VisibleForTesting
    static final String KEY_AUTHORIZATION_STARTED = "authStarted";
    @VisibleForTesting
    static final String KEY_PKEYAUTH_STATUS = "pkeyAuthStatus";
    @VisibleForTesting
    static final String KEY_AUTH_REQUEST_URL = "authRequestUrl";
    @VisibleForTesting
    static final String KEY_AUTH_REDIRECT_URI = "authRedirectUri";
    @VisibleForTesting
    static final String KEY_AUTH_AUTHORIZATION_AGENT = "authorizationAgent";
    private static final String TAG = AuthorizationActivity.class.getSimpleName();
    private boolean mAuthorizationStarted = false;
    private WebView mWebView;
    private Intent mAuthIntent;
    private boolean mPkeyAuthStatus = false;
    private String mAuthorizationRequestUrl;
    private String mRedirectUri;
    private AuthorizationAgent mAuthorizationAgent;

    public static Intent createStartIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, AuthorizationAgent authorizationAgent) {
        Intent intent = new Intent(context, AuthorizationActivity.class);
        intent.putExtra(KEY_AUTH_INTENT, (Parcelable)authIntent);
        intent.putExtra(KEY_AUTH_REQUEST_URL, requestUrl);
        intent.putExtra(KEY_AUTH_REDIRECT_URI, redirectUri);
        intent.putExtra(KEY_AUTH_AUTHORIZATION_AGENT, (Serializable)((Object)authorizationAgent));
        return intent;
    }

    public static Intent createCustomTabResponseIntent(Context context, String responseUri) {
        Intent intent = new Intent(context, AuthorizationActivity.class);
        intent.putExtra("com.microsoft.identity.customtab.redirect", responseUri);
        intent.addFlags(0x24000000);
        return intent;
    }

    private void extractState(Bundle state) {
        if (state == null) {
            Logger.warn(TAG, "No stored state. Unable to handle response");
            this.finish();
            return;
        }
        this.mAuthIntent = (Intent)state.getParcelable(KEY_AUTH_INTENT);
        this.mAuthorizationStarted = state.getBoolean(KEY_AUTHORIZATION_STARTED, false);
        this.mPkeyAuthStatus = state.getBoolean(KEY_PKEYAUTH_STATUS, false);
        this.mAuthorizationRequestUrl = state.getString(KEY_AUTH_REQUEST_URL);
        this.mRedirectUri = state.getString(KEY_AUTH_REDIRECT_URI);
        this.mAuthorizationAgent = (AuthorizationAgent)((Object)state.getSerializable(KEY_AUTH_AUTHORIZATION_AGENT));
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (savedInstanceState == null) {
            this.extractState(this.getIntent().getExtras());
        } else {
            this.extractState(savedInstanceState);
        }
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        if (!this.mAuthorizationStarted) {
            this.mAuthorizationStarted = true;
            if (this.mAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
                AzureActiveDirectoryWebViewClient webViewClient = new AzureActiveDirectoryWebViewClient(this, new ChallengeCompletionCallback(), this.mRedirectUri);
                this.setUpWebView(webViewClient);
                this.mWebView.post(new Runnable(){

                    @Override
                    public void run() {
                        AuthorizationActivity.this.mWebView.loadUrl("about:blank");
                        Logger.verbose(TAG, "Launching embedded WebView for acquiring auth code.");
                        Logger.verbosePII(TAG, "The start url is " + AuthorizationActivity.this.mAuthorizationRequestUrl);
                        AuthorizationActivity.this.mWebView.loadUrl(AuthorizationActivity.this.mAuthorizationRequestUrl);
                    }
                });
            } else if (this.mAuthIntent != null) {
                this.startActivity(this.mAuthIntent);
            } else {
                Intent resultIntent = new Intent();
                resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)new ClientException("Authorization intent is null."));
                this.setResult(2005, resultIntent);
                this.finish();
            }
            return;
        }
        if (!StringUtil.isEmpty(this.getIntent().getStringExtra("com.microsoft.identity.customtab.redirect"))) {
            Logger.info(TAG, null, "Received redirect from system webview.");
            String url = this.getIntent().getExtras().getString("com.microsoft.identity.customtab.redirect");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.identity.client.final.url", url);
            this.setResult(2003, resultIntent);
            this.finish();
        } else {
            this.setResult(2001, new Intent());
            this.finish();
        }
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_AUTH_INTENT, (Parcelable)this.mAuthIntent);
        outState.putBoolean(KEY_AUTHORIZATION_STARTED, this.mAuthorizationStarted);
        outState.putBoolean(KEY_PKEYAUTH_STATUS, this.mPkeyAuthStatus);
        outState.putSerializable(KEY_AUTH_AUTHORIZATION_AGENT, (Serializable)((Object)this.mAuthorizationAgent));
        outState.putString(KEY_AUTH_REDIRECT_URI, this.mRedirectUri);
        outState.putString(KEY_AUTH_REQUEST_URL, this.mAuthorizationRequestUrl);
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void setUpWebView(AzureActiveDirectoryWebViewClient webViewClient) {
        this.mWebView = (WebView)this.findViewById(R.id.webview);
        WebSettings userAgentSetting = this.mWebView.getSettings();
        String userAgent = userAgentSetting.getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.setVisibility(4);
        this.mWebView.setWebViewClient((WebViewClient)webViewClient);
    }

    class ChallengeCompletionCallback
    implements IChallengeCompletionCallback {
        ChallengeCompletionCallback() {
        }

        @Override
        public void onChallengeResponseReceived(int returnCode, Intent responseIntent) {
            Logger.verbose(TAG, null, "onChallengeResponseReceived:" + returnCode);
            AuthorizationActivity.this.setResult(returnCode, responseIntent);
            AuthorizationActivity.this.finish();
        }

        @Override
        public void setPKeyAuthStatus(boolean status) {
            AuthorizationActivity.this.mPkeyAuthStatus = status;
            Logger.verbose(TAG, null, "setPKeyAuthStatus:" + status);
        }
    }
}

