/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import android.support.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import java.util.Map;

public class AzureActiveDirectoryAccount
extends MicrosoftAccount {
    private static final String TAG = AzureActiveDirectoryAccount.class.getSimpleName();

    public AzureActiveDirectoryAccount() {
    }

    public AzureActiveDirectoryAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        super(idToken, clientInfo);
        Logger.verbose(TAG, "Init: " + TAG);
    }

    @Override
    public String getAuthorityType() {
        return "MSSTS";
    }

    @Override
    protected String getDisplayableId(Map<String, String> claims) {
        String methodName = "getDisplayableId";
        String displayableId = null;
        if (!StringExtensions.isNullOrBlank(claims.get("upn"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning upn as displayableId");
            displayableId = claims.get("upn");
        } else if (!StringExtensions.isNullOrBlank(claims.get("email"))) {
            Logger.info(TAG + ":" + "getDisplayableId", "Returning email as displayableId");
            displayableId = claims.get("email");
        }
        return displayableId;
    }

    @Override
    public String toString() {
        return "AzureActiveDirectoryAccount{} " + super.toString();
    }
}

