/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.HttpUrlConnectionFactory;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class HttpRequest {
    private static final String HOST = "Host";
    private static final int RETRY_TIME_WAITING_PERIOD_MSEC = 1000;
    private static final int STREAM_BUFFER_SIZE = 1024;
    static final String REQUEST_METHOD_GET = "GET";
    static final String REQUEST_METHOD_POST = "POST";
    private static final int DEFAULT_READ_TIMEOUT = 30000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 30000;
    private final URL mRequestUrl;
    private final byte[] mRequestContent;
    private final String mRequestContentType;
    private final String mRequestMethod;
    private final Map<String, String> mRequestHeaders = new HashMap<String, String>();

    private HttpRequest(URL requestUrl, Map<String, String> requestHeaders, String requestMethod) {
        this(requestUrl, requestHeaders, requestMethod, null, null);
    }

    private HttpRequest(URL requestUrl, Map<String, String> requestHeaders, String requestMethod, byte[] requestContent, String requestContentType) {
        this.mRequestUrl = requestUrl;
        this.mRequestHeaders.put(HOST, requestUrl.getAuthority());
        this.mRequestHeaders.putAll(requestHeaders);
        this.mRequestMethod = requestMethod;
        this.mRequestContent = requestContent;
        this.mRequestContentType = requestContentType;
    }

    public static HttpResponse sendPost(URL requestUrl, Map<String, String> requestHeaders, byte[] requestContent, String requestContentType) throws IOException {
        HttpRequest httpRequest = new HttpRequest(requestUrl, requestHeaders, REQUEST_METHOD_POST, requestContent, requestContentType);
        return httpRequest.send();
    }

    public static HttpResponse sendGet(URL requestUrl, Map<String, String> requestHeaders) throws IOException {
        HttpRequest httpRequest = new HttpRequest(requestUrl, requestHeaders, REQUEST_METHOD_GET);
        return httpRequest.send();
    }

    private HttpResponse send() throws IOException, SocketTimeoutException, UnknownServiceException {
        HttpResponse response = this.sendWithRetry();
        if (response != null && HttpRequest.isRetryableError(response.getStatusCode())) {
            throw new UnknownServiceException("Retry failed again with 500/503/504");
        }
        return response;
    }

    private HttpResponse sendWithRetry() throws IOException {
        HttpResponse httpResponse;
        try {
            httpResponse = this.executeHttpSend();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            this.waitBeforeRetry();
            return this.executeHttpSend();
        }
        if (HttpRequest.isRetryableError(httpResponse.getStatusCode())) {
            this.waitBeforeRetry();
            return this.executeHttpSend();
        }
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse executeHttpSend() throws IOException {
        HttpResponse response;
        HttpURLConnection urlConnection = this.setupConnection();
        urlConnection.setRequestMethod(this.mRequestMethod);
        HttpRequest.setRequestBody(urlConnection, this.mRequestContent, this.mRequestContentType);
        InputStream responseStream = null;
        try {
            try {
                responseStream = urlConnection.getInputStream();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                throw socketTimeoutException;
            }
            catch (IOException ioException) {
                responseStream = urlConnection.getErrorStream();
            }
            int statusCode = urlConnection.getResponseCode();
            String responseBody = responseStream == null ? "" : HttpRequest.convertStreamToString(responseStream);
            response = new HttpResponse(statusCode, responseBody, urlConnection.getHeaderFields());
        }
        finally {
            HttpRequest.safeCloseStream(responseStream);
        }
        return response;
    }

    private HttpURLConnection setupConnection() throws IOException {
        HttpURLConnection urlConnection = HttpUrlConnectionFactory.createHttpURLConnection(this.mRequestUrl);
        urlConnection.setRequestProperty("Connection", "close");
        Set<Map.Entry<String, String>> headerEntries = this.mRequestHeaders.entrySet();
        for (Map.Entry<String, String> entry : headerEntries) {
            urlConnection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        urlConnection.setConnectTimeout(30000);
        urlConnection.setReadTimeout(30000);
        urlConnection.setInstanceFollowRedirects(true);
        urlConnection.setUseCaches(false);
        urlConnection.setDoInput(true);
        return urlConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRequestBody(HttpURLConnection connection, byte[] contentRequest, String requestContentType) throws IOException {
        if (contentRequest == null) {
            return;
        }
        connection.setDoOutput(true);
        if (!StringUtil.isEmpty(requestContentType)) {
            connection.setRequestProperty("Content-Type", requestContentType);
        }
        connection.setRequestProperty("Content-Length", String.valueOf(contentRequest.length));
        OutputStream out = null;
        try {
            out = connection.getOutputStream();
            out.write(contentRequest);
        }
        finally {
            HttpRequest.safeCloseStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) throws IOException {
        try {
            int charsRead;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            char[] buffer = new char[1024];
            StringBuilder stringBuilder = new StringBuilder();
            while ((charsRead = reader.read(buffer)) > -1) {
                stringBuilder.append(buffer, 0, charsRead);
            }
            String string = stringBuilder.toString();
            return string;
        }
        finally {
            HttpRequest.safeCloseStream(inputStream);
        }
    }

    private static void safeCloseStream(Closeable stream) {
        if (stream == null) {
            return;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static boolean isRetryableError(int statusCode) {
        return statusCode == 500 || statusCode == 504 || statusCode == 503;
    }

    private void waitBeforeRetry() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

