/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import java.util.Map;

public final class SchemaUtil {
    private static final String TAG = SchemaUtil.class.getSimpleName();

    private SchemaUtil() {
    }

    public static String getAuthority(IDToken idToken) {
        String methodName = "getAuthority";
        String issuer = null;
        if (null != idToken) {
            Map<String, String> idTokenClaims = idToken.getTokenClaims();
            if (null != idTokenClaims) {
                issuer = idTokenClaims.get("iss");
                Logger.verbosePII(TAG + ":" + "getAuthority", "Issuer: " + issuer);
                if (null == issuer) {
                    Logger.warn(TAG + ":" + "getAuthority", "Environment was null or could not be parsed.");
                }
            } else {
                Logger.warn(TAG + ":" + "getAuthority", "IDToken claims were null");
            }
        } else {
            Logger.warn(TAG + ":" + "getAuthority", "IDToken was null");
        }
        return issuer;
    }

    public static String getAvatarUrl(IDToken idToken) {
        String methodName = "getAvatarUrl";
        String avatarUrl = null;
        if (null != idToken) {
            Map<String, String> idTokenClaims = idToken.getTokenClaims();
            if (null != idTokenClaims) {
                avatarUrl = idTokenClaims.get("picture");
                Logger.verbosePII(TAG + ":" + "getAvatarUrl", "Avatar URL: " + avatarUrl);
                if (null == avatarUrl) {
                    Logger.warn(TAG + ":" + "getAvatarUrl", "Avatar URL was null.");
                }
            } else {
                Logger.warn(TAG + ":" + "getAvatarUrl", "IDToken claims were null.");
            }
        } else {
            Logger.warn(TAG + ":" + "getAvatarUrl", "IDToken was null.");
        }
        return avatarUrl;
    }

    public static String getAlternativeAccountId(IDToken idToken) {
        String methodName = "getAlternativeAccountId";
        String alternativeAccountId = null;
        if (null != idToken) {
            Map<String, String> idTokenClaims = idToken.getTokenClaims();
            if (null != idTokenClaims) {
                alternativeAccountId = idTokenClaims.get("altsecid");
                Logger.verbosePII(TAG + ":" + "getAlternativeAccountId", "alternative_account_id: " + alternativeAccountId);
                if (null == alternativeAccountId) {
                    Logger.warn(TAG + ":" + "getAlternativeAccountId", "alternative_account_id was null.");
                }
            } else {
                Logger.warn(TAG + ":" + "getAlternativeAccountId", "IDToken claims were null.");
            }
        } else {
            Logger.warn(TAG + ":" + "getAlternativeAccountId", "IDToken was null.");
        }
        return alternativeAccountId;
    }

    public static String getHomeAccountId(ClientInfo clientInfo) {
        String methodName = ":getHomeAccountId";
        String homeAccountId = null;
        if (null != clientInfo) {
            String uid = clientInfo.getUid();
            String utid = clientInfo.getUtid();
            if (StringExtensions.isNullOrBlank(uid)) {
                Logger.warn(TAG + ":" + ":getHomeAccountId", "uid was null/blank");
            }
            if (StringExtensions.isNullOrBlank(utid)) {
                Logger.warn(TAG + ":" + ":getHomeAccountId", "utid was null/blank");
            }
            if (!StringExtensions.isNullOrBlank(uid) && !StringExtensions.isNullOrBlank(utid)) {
                homeAccountId = uid + "." + utid;
            }
            Logger.verbosePII(TAG + ":" + ":getHomeAccountId", "home_account_id: " + homeAccountId);
        } else {
            Logger.warn(TAG + ":" + ":getHomeAccountId", "ClientInfo was null.");
        }
        return homeAccountId;
    }
}

