/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFuture;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;

public class EmbeddedWebViewAuthorizationStrategy<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest>
extends AuthorizationStrategy<GenericOAuth2Strategy, GenericAuthorizationRequest> {
    private static final String TAG = EmbeddedWebViewAuthorizationStrategy.class.getSimpleName();
    private WeakReference<Activity> mReferencedActivity;
    private AuthorizationResultFuture mAuthorizationResultFuture;
    private GenericOAuth2Strategy mOAuth2Strategy;
    private GenericAuthorizationRequest mAuthorizationRequest;

    public EmbeddedWebViewAuthorizationStrategy(Activity activity) {
        this.mReferencedActivity = new WeakReference<Activity>(activity);
    }

    @Override
    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest authorizationRequest, GenericOAuth2Strategy oAuth2Strategy) throws UnsupportedEncodingException {
        this.mAuthorizationResultFuture = new AuthorizationResultFuture();
        this.mOAuth2Strategy = oAuth2Strategy;
        this.mAuthorizationRequest = authorizationRequest;
        Logger.verbose(TAG, "Perform the authorization request with embedded webView.");
        Uri requestUrl = ((AuthorizationRequest)authorizationRequest).getAuthorizationRequestAsHttpRequest();
        Intent authIntent = AuthorizationActivity.createStartIntent(((Activity)this.mReferencedActivity.get()).getApplicationContext(), null, requestUrl.toString(), ((AuthorizationRequest)this.mAuthorizationRequest).getRedirectUri(), AuthorizationAgent.WEBVIEW);
        ((Activity)this.mReferencedActivity.get()).startActivityForResult(authIntent, 1001);
        return this.mAuthorizationResultFuture;
    }

    @Override
    public void completeAuthorization(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            Object result = ((OAuth2Strategy)this.mOAuth2Strategy).getAuthorizationResultFactory().createAuthorizationResult(resultCode, data, this.mAuthorizationRequest);
            this.mAuthorizationResultFuture.setAuthorizationResult((AuthorizationResult)result);
        } else {
            Logger.warnPII(TAG, "Unknown request code " + requestCode);
        }
    }
}

