/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.net.Uri;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.platform.Device;
import com.microsoft.identity.common.internal.providers.oauth2.AccessToken;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Configuration;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.List;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Future;

public abstract class OAuth2Strategy<GenericAccessToken extends AccessToken, GenericAccount extends BaseAccount, GenericAuthorizationRequest extends AuthorizationRequest, GenericAuthorizationRequestBuilder extends AuthorizationRequest.Builder, GenericAuthorizationStrategy extends AuthorizationStrategy, GenericOAuth2Configuration extends OAuth2Configuration, GenericAuthorizationResponse extends AuthorizationResponse, GenericRefreshToken extends RefreshToken, GenericTokenRequest extends TokenRequest, GenericTokenResponse extends TokenResponse, GenericTokenResult extends TokenResult, GenericAuthorizationResult extends AuthorizationResult> {
    private static final String TAG = OAuth2Strategy.class.getSimpleName();
    protected static final String TOKEN_REQUEST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    protected final GenericOAuth2Configuration mConfig;
    protected String mTokenEndpoint;
    protected String mAuthorizationEndpoint;
    private Uri mIssuer;

    public OAuth2Strategy(GenericOAuth2Configuration config) {
        this.mConfig = config;
    }

    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest request, GenericAuthorizationStrategy authorizationStrategy) {
        this.validateAuthorizationRequest(request);
        Future<AuthorizationResult> future = null;
        try {
            future = ((AuthorizationStrategy)authorizationStrategy).requestAuthorization(request, (OAuth2Strategy)this);
        }
        catch (ClientException | UnsupportedEncodingException exception) {
            // empty catch block
        }
        return future;
    }

    public abstract AuthorizationResultFactory getAuthorizationResultFactory();

    public GenericTokenResult requestToken(GenericTokenRequest request) throws IOException {
        String methodName = ":requestToken";
        Logger.verbose(TAG + ":requestToken", "Requesting token...");
        this.validateTokenRequest(request);
        HttpResponse response = this.performTokenRequest(request);
        return this.getTokenResultFromHttpResponse(response);
    }

    protected HttpResponse performTokenRequest(GenericTokenRequest request) throws IOException {
        String methodName = ":performTokenRequest";
        Logger.verbose(TAG + ":performTokenRequest", "Performing token request...");
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(request);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String correlationId = UUID.randomUUID().toString();
        headers.put("client-request-id", correlationId);
        headers.putAll(Device.getPlatformIdParameters());
        return HttpRequest.sendPost(new URL(this.mTokenEndpoint), headers, requestBody.getBytes("UTF-8"), TOKEN_REQUEST_CONTENT_TYPE);
    }

    protected final void setTokenEndpoint(String tokenEndpoint) {
        this.mTokenEndpoint = tokenEndpoint;
    }

    protected final void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.mAuthorizationEndpoint = authorizationEndpoint;
    }

    protected GenericOAuth2Configuration getOAuth2Configuration() {
        return this.mConfig;
    }

    protected Uri getIssuer() {
        return this.mIssuer;
    }

    protected final void setIssuer(Uri issuer) {
        this.mIssuer = issuer;
    }

    public abstract String getIssuerCacheIdentifier(GenericAuthorizationRequest var1);

    public abstract GenericAccessToken getAccessTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericRefreshToken getRefreshTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericAccount createAccount(GenericTokenResponse var1);

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder();

    public abstract GenericAuthorizationRequestBuilder createAuthorizationRequestBuilder(IAccountRecord var1);

    public abstract GenericTokenRequest createTokenRequest(GenericAuthorizationRequest var1, GenericAuthorizationResponse var2);

    public abstract GenericTokenRequest createRefreshTokenRequest(RefreshTokenRecord var1, List<String> var2);

    protected abstract void validateAuthorizationRequest(GenericAuthorizationRequest var1);

    protected abstract void validateTokenRequest(GenericTokenRequest var1);

    protected abstract GenericTokenResult getTokenResultFromHttpResponse(HttpResponse var1);
}

