/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.util;

import android.net.Uri;
import android.util.Base64;
import android.util.Log;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public final class StringExtensions {
    public static final String ENCODING_UTF8 = "UTF_8";
    private static final String TAG = StringExtensions.class.getSimpleName();
    private static final String TOKEN_HASH_ALGORITHM = "SHA256";

    private StringExtensions() {
    }

    public static boolean isNullOrBlank(String param) {
        return param == null || param.trim().length() == 0;
    }

    public static String createHash(String msg) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        if (!StringExtensions.isNullOrBlank(msg)) {
            MessageDigest digester = MessageDigest.getInstance(TOKEN_HASH_ALGORITHM);
            byte[] msgInBytes = msg.getBytes(ENCODING_UTF8);
            return new String(Base64.encode((byte[])digester.digest(msgInBytes), (int)2), ENCODING_UTF8);
        }
        return msg;
    }

    public static String urlFormEncode(String source) throws UnsupportedEncodingException {
        return URLEncoder.encode(source, ENCODING_UTF8);
    }

    public static String urlFormDecode(String source) throws UnsupportedEncodingException {
        return URLDecoder.decode(source, ENCODING_UTF8);
    }

    public static String encodeBase64URLSafeString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(Base64.encode((byte[])bytes, (int)11), ENCODING_UTF8);
    }

    public static URL getUrl(String endpoint) {
        URL authority = null;
        try {
            authority = new URL(endpoint);
        }
        catch (MalformedURLException e1) {
            Log.e((String)TAG, (String)"authority_url_not_valid");
        }
        return authority;
    }

    public static HashMap<String, String> getUrlParameters(String finalUrl) {
        Uri response = Uri.parse((String)finalUrl);
        String fragment = response.getFragment();
        HashMap<String, String> parameters = HashMapExtensions.urlFormDecode(fragment);
        if (parameters == null || parameters.isEmpty()) {
            String queryParameters = response.getEncodedQuery();
            parameters = HashMapExtensions.urlFormDecode(queryParameters);
        }
        return parameters;
    }

    public static List<String> getStringTokens(String items, String delimiter) {
        StringTokenizer st = new StringTokenizer(items, delimiter);
        ArrayList<String> itemList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            if (StringExtensions.isNullOrBlank(name)) continue;
            itemList.add(name);
        }
        return itemList;
    }

    public static ArrayList<String> splitWithQuotes(String input, char delimiter) {
        String item;
        ArrayList<String> items = new ArrayList<String>();
        int startIndex = 0;
        boolean insideString = false;
        for (int i = 0; i < input.length(); ++i) {
            if (input.charAt(i) == delimiter && !insideString) {
                item = input.substring(startIndex, i);
                if (!StringExtensions.isNullOrBlank(item.trim())) {
                    items.add(item);
                }
                startIndex = i + 1;
                continue;
            }
            if (input.charAt(i) != '\"') continue;
            insideString = !insideString;
        }
        item = input.substring(startIndex);
        if (!StringExtensions.isNullOrBlank(item.trim())) {
            items.add(item);
        }
        return items;
    }

    public static String removeQuoteInHeaderValue(String value) {
        if (!StringExtensions.isNullOrBlank(value)) {
            return value.replace("\"", "");
        }
        return null;
    }

    public static boolean hasPrefixInHeader(String value, String prefix) {
        return value.startsWith(prefix) && value.length() > prefix.length() + 2 && Character.isWhitespace(value.charAt(prefix.length()));
    }

    public static String base64UrlEncodeToString(String message) {
        return Base64.encodeToString((byte[])message.getBytes(Charset.forName(ENCODING_UTF8)), (int)10);
    }

    public static String appendQueryParameterToUrl(String url, Map<String, String> requestParams) throws UnsupportedEncodingException {
        if (StringExtensions.isNullOrBlank(url)) {
            throw new IllegalArgumentException("Empty authority endpoint parameter.");
        }
        if (requestParams.isEmpty()) {
            return url;
        }
        Uri.Builder builtUri = Uri.parse((String)url).buildUpon();
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            builtUri.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return builtUri.build().toString();
    }
}

