/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview.challengehandlers;

import android.support.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PKeyAuthChallenge
implements Serializable {
    private static final String CHALLENGE_REQUEST_CERT_AUTH_DELIMITER = ";";
    private static final long serialVersionUID = 1035116074451575588L;
    private String mNonce = "";
    private String mContext = "";
    private List<String> mCertAuthorities;
    private String mThumbprint = "";
    private String mVersion = null;
    private String mSubmitUrl = "";

    public PKeyAuthChallenge(@NonNull String redirectUri) throws ClientException {
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(redirectUri);
        PKeyAuthChallenge.validatePKeyAuthChallenge(parameters);
        this.mNonce = parameters.get(PKeyAuthChallengeHandler.RequestField.Nonce.name().toLowerCase(Locale.US));
        this.mContext = parameters.get(PKeyAuthChallengeHandler.RequestField.Context.name());
        this.mCertAuthorities = StringExtensions.getStringTokens(parameters.get(PKeyAuthChallengeHandler.RequestField.CertAuthorities.name()), CHALLENGE_REQUEST_CERT_AUTH_DELIMITER);
        this.mThumbprint = null;
        this.mVersion = parameters.get(PKeyAuthChallengeHandler.RequestField.Version.name());
        this.mSubmitUrl = parameters.get(PKeyAuthChallengeHandler.RequestField.SubmitUrl.name());
    }

    public String getNonce() {
        return this.mNonce;
    }

    public String getContext() {
        return this.mContext;
    }

    public List<String> getCertAuthorities() {
        return this.mCertAuthorities;
    }

    public String getThumbprint() {
        return this.mThumbprint;
    }

    public String getVersion() {
        return this.mVersion;
    }

    public String getSubmitUrl() {
        return this.mSubmitUrl;
    }

    private static void validatePKeyAuthChallenge(Map<String, String> headerItems) throws ClientException {
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Nonce.name()) && !headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new ClientException("Device certificate request is invalid", "Nonce is empty.");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Version.name())) {
            throw new ClientException("Device certificate request is invalid", "Version name is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.SubmitUrl.name())) {
            throw new ClientException("Device certificate request is invalid", "SubmitUrl is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.Context.name())) {
            throw new ClientException("Device certificate request is invalid", "Context is empty");
        }
        if (!headerItems.containsKey(PKeyAuthChallengeHandler.RequestField.CertAuthorities.name())) {
            throw new ClientException("Device certificate request is invalid", "CertAuthorities is empty");
        }
    }
}

