/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.webview;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.RequiresApi;
import android.webkit.ClientCertRequest;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.ui.webview.OAuth2WebViewClient;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.ClientCertAuthChallengeHandler;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IChallengeCompletionCallback;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallenge;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.PKeyAuthChallengeHandler;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.HashMap;
import java.util.Locale;

public class AzureActiveDirectoryWebViewClient
extends OAuth2WebViewClient {
    private static final String TAG = AzureActiveDirectoryWebViewClient.class.getSimpleName();
    private static final String INSTALL_URL_KEY = "app_link";
    public static final String ERROR = "error";
    public static final String ERROR_DESCRIPTION = "error_description";
    private final String mRedirectUrl;

    public AzureActiveDirectoryWebViewClient(@NonNull Activity activity, @NonNull IChallengeCompletionCallback callback, @NonNull String redirectUrl) {
        super(activity, callback);
        this.getActivity().setContentView(R.layout.activity_authentication);
        this.mRedirectUrl = redirectUrl;
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (StringUtil.isEmpty(url)) {
            throw new IllegalArgumentException("Redirect to empty url in web view.");
        }
        return this.handleUrl(view, url);
    }

    @RequiresApi(value=24)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        Uri requestUrl = request.getUrl();
        return this.handleUrl(view, requestUrl.toString());
    }

    private boolean handleUrl(WebView view, String url) {
        String formattedURL = url.toLowerCase(Locale.US);
        if (this.isPkeyAuthUrl(formattedURL)) {
            Logger.verbose(TAG, "WebView detected request for pkeyauth challenge.");
            try {
                PKeyAuthChallenge pKeyAuthChallenge = new PKeyAuthChallenge(url);
                PKeyAuthChallengeHandler pKeyAuthChallengeHandler = new PKeyAuthChallengeHandler(view, this.getCompletionCallback());
                pKeyAuthChallengeHandler.processChallenge(pKeyAuthChallenge);
            }
            catch (ClientException exception) {
                Logger.error(TAG, exception.getErrorCode(), null);
                Logger.errorPII(TAG, exception.getMessage(), exception);
                this.returnError(exception.getErrorCode(), exception.getMessage());
                view.stopLoading();
            }
            return true;
        }
        if (this.isRedirectUrl(formattedURL)) {
            Logger.verbose(TAG, "Navigation starts with the redirect uri.");
            return this.processRedirectUrl(view, url);
        }
        if (this.isWebsiteRequestUrl(formattedURL)) {
            Logger.verbose(TAG, "It is an external website request");
            return this.processWebsiteRequest(view, url);
        }
        if (this.isInstallRequestUrl(formattedURL)) {
            Logger.verbose(TAG, "It is an install request");
            return this.processInstallRequest(view, url);
        }
        Logger.verbose(TAG, "It is an invalid redirect uri.");
        return this.processInvalidUrl(view, url);
    }

    private boolean isPkeyAuthUrl(@NonNull String url) {
        return url.startsWith("urn:http-auth:PKeyAuth".toLowerCase());
    }

    private boolean isRedirectUrl(@NonNull String url) {
        return url.startsWith(this.mRedirectUrl.toLowerCase(Locale.US));
    }

    private boolean isWebsiteRequestUrl(@NonNull String url) {
        return url.startsWith("browser://");
    }

    private boolean isInstallRequestUrl(@NonNull String url) {
        return url.startsWith("msauth://");
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        return callingIntent != null && !StringExtensions.isNullOrBlank(callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request"));
    }

    protected boolean processRedirectUrl(@NonNull WebView view, @NonNull String url) {
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        if (!StringExtensions.isNullOrBlank((String)parameters.get(ERROR))) {
            Logger.info(TAG, "Sending intent to cancel authentication activity");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", (String)parameters.get(ERROR));
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get(ERROR_DESCRIPTION));
            this.getCompletionCallback().onChallengeResponseReceived(2001, resultIntent);
            view.stopLoading();
        } else {
            Logger.verbose(TAG, "It is pointing to redirect. Final url can be processed to get the code or error.");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.identity.client.final.url", url);
            this.getCompletionCallback().onChallengeResponseReceived(2003, resultIntent);
            view.stopLoading();
        }
        return true;
    }

    private boolean processWebsiteRequest(@NonNull WebView view, @NonNull String url) {
        String link = url.replace("browser://", "https://");
        Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
        this.getActivity().getApplicationContext().startActivity(intent);
        view.stopLoading();
        Intent resultIntent = new Intent();
        this.getCompletionCallback().onChallengeResponseReceived(2001, resultIntent);
        return true;
    }

    private boolean processInstallRequest(final @NonNull WebView view, final @NonNull String url) {
        Logger.verbose(TAG, "Return to caller with BROKER_REQUEST_RESUME, and waiting for result.");
        Intent resultIntent = new Intent();
        this.getCompletionCallback().onChallengeResponseReceived(2006, resultIntent);
        Logger.verbose(TAG, "Error occurred when having thread sleeping for 1 second.");
        Handler handler = new Handler();
        int threadSleepForCallingActivity = 1000;
        handler.postDelayed(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
                String link = parameters.get(AzureActiveDirectoryWebViewClient.INSTALL_URL_KEY).replace("browser://", "https://");
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
                AzureActiveDirectoryWebViewClient.this.getActivity().getApplicationContext().startActivity(intent);
                view.stopLoading();
            }
        }, 1000L);
        return true;
    }

    private boolean processInvalidUrl(@NonNull WebView view, @NonNull String url) {
        if (this.isBrokerRequest(this.getActivity().getIntent()) && url.startsWith("msauth")) {
            Logger.error(TAG, "The RedirectUri is not as expected.", null);
            Logger.errorPII(TAG, String.format("Received %s and expected %s", url, this.mRedirectUrl), null);
            this.returnError("The redirectUri for broker is invalid", String.format("The RedirectUri is not as expected. Received %s and expected %s", url, this.mRedirectUrl));
            view.stopLoading();
            return true;
        }
        if (url.toLowerCase(Locale.US).equals("about:blank")) {
            Logger.verbose(TAG, "It is an blank page request");
            return true;
        }
        if (!url.toLowerCase(Locale.US).startsWith("https://")) {
            Logger.error(TAG, "The webView was redirected to an unsafe URL.", null);
            this.returnError("Redirect url scheme not SSL protected", "The webView was redirected to an unsafe URL.");
            view.stopLoading();
            return true;
        }
        return false;
    }

    private void returnError(String errorCode, String errorMessage) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", errorCode);
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", errorMessage);
        this.getCompletionCallback().onChallengeResponseReceived(2002, resultIntent);
    }

    @TargetApi(value=21)
    public void onReceivedClientCertRequest(WebView view, ClientCertRequest clientCertRequest) {
        ClientCertAuthChallengeHandler clientCertAuthChallengeHandler = new ClientCertAuthChallengeHandler(this.getActivity());
        clientCertAuthChallengeHandler.processChallenge(clientCertRequest);
    }
}

