/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import com.microsoft.identity.common.internal.logging.Logger;
import java.lang.ref.WeakReference;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CustomTabsManager {
    private static final String TAG = CustomTabsManager.class.getSimpleName();
    private CustomTabsIntent mCustomTabsIntent;
    private CustomTabsServiceConnection mCustomTabsServiceConnection;
    private final WeakReference<Activity> mActivityRef;
    private final AtomicReference<CustomTabsClient> mCustomTabsClient;
    private boolean mCustomTabsServiceIsBound;
    private final CountDownLatch mClientLatch;
    private static final long CUSTOM_TABS_MAX_CONNECTION_TIMEOUT = 1L;

    public CustomTabsIntent getCustomTabsIntent() {
        return this.mCustomTabsIntent;
    }

    public CustomTabsManager(@NonNull Activity activity) {
        this.mActivityRef = new WeakReference<Activity>(activity);
        this.mCustomTabsClient = new AtomicReference();
        this.mClientLatch = new CountDownLatch(1);
    }

    public synchronized void bind(@NonNull String browserPackage) {
        if (this.mCustomTabsServiceConnection != null) {
            return;
        }
        this.mCustomTabsServiceConnection = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                Logger.info(TAG, "CustomTabsService is connected");
                client.warmup(0L);
                CustomTabsManager.this.mCustomTabsServiceIsBound = true;
                CustomTabsManager.this.mCustomTabsClient.set(client);
                CustomTabsManager.this.mClientLatch.countDown();
            }

            public void onServiceDisconnected(ComponentName name) {
                Logger.info(TAG, "CustomTabsService is disconnected");
                CustomTabsManager.this.mCustomTabsServiceIsBound = false;
                CustomTabsManager.this.mCustomTabsClient.set(null);
            }
        };
        if (((Activity)this.mActivityRef.get()).getApplicationContext() == null || !CustomTabsClient.bindCustomTabsService((Context)((Context)this.mActivityRef.get()), (String)browserPackage, (CustomTabsServiceConnection)this.mCustomTabsServiceConnection)) {
            Logger.info(TAG, "Unable to bind custom tabs service");
            this.mClientLatch.countDown();
        }
        CustomTabsIntent.Builder builder = new CustomTabsIntent.Builder(this.getClient().newSession(null));
        this.mCustomTabsIntent = builder.setShowTitle(true).build();
        this.mCustomTabsIntent.intent.setPackage(browserPackage);
    }

    public CustomTabsClient getClient() {
        try {
            this.mClientLatch.await(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Logger.info(TAG, "Interrupted while waiting for browser connection");
            this.mClientLatch.countDown();
        }
        return this.mCustomTabsClient.get();
    }

    public synchronized void unbind() {
        if (this.mCustomTabsServiceConnection == null) {
            return;
        }
        if (this.mActivityRef.get() != null && this.mCustomTabsServiceIsBound) {
            ((Activity)this.mActivityRef.get()).unbindService((ServiceConnection)this.mCustomTabsServiceConnection);
        }
        this.mCustomTabsServiceIsBound = false;
        this.mCustomTabsClient.set(null);
        Logger.info(TAG, "CustomTabsService is unbound.");
    }
}

