/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.microsoftsts;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenErrorResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccessToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.net.URL;
import java.util.List;
import java.util.UUID;

public class MicrosoftStsOAuth2Strategy
extends OAuth2Strategy<MicrosoftStsAccessToken, MicrosoftStsAccount, MicrosoftStsAuthorizationRequest, MicrosoftStsAuthorizationRequest.Builder, AuthorizationStrategy, MicrosoftStsOAuth2Configuration, MicrosoftStsAuthorizationResponse, MicrosoftStsRefreshToken, MicrosoftStsTokenRequest, MicrosoftStsTokenResponse, TokenResult, AuthorizationResult> {
    private static final String TAG = MicrosoftStsOAuth2Strategy.class.getSimpleName();

    public MicrosoftStsOAuth2Strategy(@NonNull MicrosoftStsOAuth2Configuration config) {
        super(config);
        this.setTokenEndpoint(config.getTokenEndpoint().toString());
    }

    @Override
    public AuthorizationResultFactory getAuthorizationResultFactory() {
        return new MicrosoftStsAuthorizationResultFactory();
    }

    @Override
    public String getIssuerCacheIdentifier(MicrosoftStsAuthorizationRequest request) {
        String methodName = ":getIssuerCacheIdentifier";
        URL authority = request.getAuthority();
        AzureActiveDirectoryCloud cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authority);
        if (null != cloudEnv) {
            String preferredCacheHostName = cloudEnv.getPreferredCacheHostName();
            Logger.info(TAG + ":getIssuerCacheIdentifier", "Using preferred cache host name...");
            Logger.infoPII(TAG + ":getIssuerCacheIdentifier", "Preferred cache hostname: [" + preferredCacheHostName + "]");
            return preferredCacheHostName;
        }
        return authority.getHost();
    }

    @Override
    public MicrosoftStsAccessToken getAccessTokenFromResponse(@NonNull MicrosoftStsTokenResponse response) {
        String methodName = ":getAccessTokenFromResponse";
        Logger.verbose(TAG + ":getAccessTokenFromResponse", "Getting AT from TokenResponse...");
        return new MicrosoftStsAccessToken(response);
    }

    @Override
    public MicrosoftStsRefreshToken getRefreshTokenFromResponse(@NonNull MicrosoftStsTokenResponse response) {
        String methodName = ":getRefreshTokenFromResponse";
        Logger.verbose(TAG + ":getRefreshTokenFromResponse", "Getting RT from TokenResponse...");
        return new MicrosoftStsRefreshToken(response);
    }

    @Override
    public MicrosoftStsAccount createAccount(@NonNull MicrosoftStsTokenResponse response) {
        String methodName = ":createAccount";
        Logger.verbose(TAG + ":createAccount", "Creating account from TokenResponse...");
        IDToken idToken = null;
        ClientInfo clientInfo = null;
        try {
            idToken = new IDToken(response.getIdToken());
            clientInfo = new ClientInfo(response.getClientInfo());
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
        return MicrosoftStsAccount.create(idToken, clientInfo);
    }

    @Override
    public MicrosoftStsAuthorizationRequest.Builder createAuthorizationRequestBuilder() {
        String methodName = ":createAuthorizationRequestBuilder";
        Logger.verbose(TAG + ":createAuthorizationRequestBuilder", "Creating AuthorizationRequestBuilder...");
        MicrosoftStsAuthorizationRequest.Builder builder = new MicrosoftStsAuthorizationRequest.Builder();
        builder.setAuthority(((MicrosoftStsOAuth2Configuration)this.mConfig).getAuthorityUrl());
        if (((MicrosoftStsOAuth2Configuration)this.mConfig).getSlice() != null) {
            Logger.verbose(TAG + ":createAuthorizationRequestBuilder", "Setting slice params...");
            builder.setSlice(((MicrosoftStsOAuth2Configuration)this.mConfig).getSlice());
        }
        builder.setFlightParameters(((MicrosoftStsOAuth2Configuration)this.mConfig).getFlightParameters());
        return builder;
    }

    @Override
    public MicrosoftStsAuthorizationRequest.Builder createAuthorizationRequestBuilder(@Nullable IAccountRecord account) {
        String methodName = ":createAuthorizationRequestBuilder";
        Logger.verbose(TAG + ":createAuthorizationRequestBuilder", "Creating AuthorizationRequestBuilder");
        MicrosoftStsAuthorizationRequest.Builder builder = this.createAuthorizationRequestBuilder();
        if (null != account) {
            String homeAccountId = account.getHomeAccountId();
            int EXPECTED_LENGTH = 2;
            boolean INDEX_UID = false;
            boolean INDEX_UTID = true;
            String[] uidUtidPair = homeAccountId.split("\\.");
            if (2 == uidUtidPair.length && !StringExtensions.isNullOrBlank(uidUtidPair[0]) && !StringExtensions.isNullOrBlank(uidUtidPair[1])) {
                builder.setUid(uidUtidPair[0]);
                builder.setUtid(uidUtidPair[1]);
                Logger.verbosePII(TAG + ":createAuthorizationRequestBuilder", "Builder w/ uid: [" + uidUtidPair[0] + "]");
                Logger.verbosePII(TAG + ":createAuthorizationRequestBuilder", "Builder w/ utid: [" + uidUtidPair[1] + "]");
            }
        }
        return builder;
    }

    @Override
    public MicrosoftStsTokenRequest createTokenRequest(@NonNull MicrosoftStsAuthorizationRequest request, @NonNull MicrosoftStsAuthorizationResponse response) {
        String methodName = ":createTokenRequest";
        Logger.verbose(TAG + ":createTokenRequest", "Creating TokenRequest...");
        MicrosoftStsTokenRequest tokenRequest = new MicrosoftStsTokenRequest();
        tokenRequest.setCodeVerifier(request.getPkceChallenge().getCodeVerifier());
        tokenRequest.setCode(response.getCode());
        tokenRequest.setRedirectUri(request.getRedirectUri());
        tokenRequest.setClientId(request.getClientId());
        try {
            tokenRequest.setCorrelationId(UUID.fromString((String)DiagnosticContext.getRequestContext().get("correlation_id")));
        }
        catch (IllegalArgumentException ex) {
            Logger.error("MicrosoftSTSOAuth2Strategy", "Correlation id on diagnostic context is not a UUID.", ex);
        }
        return tokenRequest;
    }

    @Override
    public MicrosoftStsTokenRequest createRefreshTokenRequest(@NonNull RefreshTokenRecord refreshToken, @NonNull List<String> scopes) {
        String methodName = ":createRefreshTokenRequest";
        Logger.verbose(TAG + ":createRefreshTokenRequest", "Creating refresh token request");
        MicrosoftStsTokenRequest request = new MicrosoftStsTokenRequest();
        request.setRefreshToken(refreshToken.getSecret());
        request.setGrantType("refresh_token");
        request.setScope(StringUtil.join(' ', scopes));
        if (null != request.getScope()) {
            Logger.verbosePII(TAG + ":createRefreshTokenRequest", "Scopes: [" + request.getScope() + "]");
        }
        return request;
    }

    @Override
    protected void validateAuthorizationRequest(MicrosoftStsAuthorizationRequest request) {
    }

    @Override
    protected void validateTokenRequest(MicrosoftStsTokenRequest request) {
    }

    @Override
    protected TokenResult getTokenResultFromHttpResponse(HttpResponse response) {
        String methodName = ":getTokenResultFromHttpResponse";
        Logger.verbose(TAG + ":getTokenResultFromHttpResponse", "Getting TokenResult from HttpResponse...");
        TokenResponse tokenResponse = null;
        TokenErrorResponse tokenErrorResponse = null;
        if (response.getStatusCode() >= 400) {
            tokenErrorResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), MicrosoftTokenErrorResponse.class);
        } else {
            tokenResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), MicrosoftStsTokenResponse.class);
        }
        return new TokenResult(tokenResponse, tokenErrorResponse);
    }
}

