/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenErrorResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccessToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenRequest;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFactory;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.TokenErrorResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import java.util.List;

public class AzureActiveDirectoryOAuth2Strategy
extends OAuth2Strategy<AzureActiveDirectoryAccessToken, AzureActiveDirectoryAccount, AzureActiveDirectoryAuthorizationRequest, AzureActiveDirectoryAuthorizationRequest.Builder, AuthorizationStrategy, AzureActiveDirectoryOAuth2Configuration, AzureActiveDirectoryAuthorizationResponse, AzureActiveDirectoryRefreshToken, AzureActiveDirectoryTokenRequest, AzureActiveDirectoryTokenResponse, TokenResult, AuthorizationResult> {
    private static final String TAG = AzureActiveDirectoryOAuth2Strategy.class.getSimpleName();

    public AzureActiveDirectoryOAuth2Strategy(AzureActiveDirectoryOAuth2Configuration config) {
        super(config);
        Logger.verbose(TAG, "Init: " + TAG);
        if (null != config.getAuthorityUrl()) {
            this.setTokenEndpoint(config.getAuthorityUrl().toString() + "/oauth2/token");
        } else {
            this.setTokenEndpoint("https://login.microsoftonline.com/microsoft.com/oauth2/token");
        }
    }

    @Override
    public AuthorizationResultFactory getAuthorizationResultFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getIssuerCacheIdentifier(AzureActiveDirectoryAuthorizationRequest authRequest) {
        String methodName = "getIssuerCacheIdentifier";
        AzureActiveDirectoryCloud cloud = AzureActiveDirectory.getAzureActiveDirectoryCloud(authRequest.getAuthority());
        if (cloud == null && !((AzureActiveDirectoryOAuth2Configuration)this.getOAuth2Configuration()).isAuthorityHostValidationEnabled()) {
            Logger.warn(TAG + ":" + "getIssuerCacheIdentifier", "Discovery data does not include cloud authority and validation is off. Returning passed in Authority: " + authRequest.getAuthority().toString());
            return authRequest.getAuthority().toString();
        }
        if (!cloud.isValidated() && ((AzureActiveDirectoryOAuth2Configuration)this.getOAuth2Configuration()).isAuthorityHostValidationEnabled()) {
            Logger.warn(TAG + ":" + "getIssuerCacheIdentifier", "Authority host validation has been enabled. This data hasn't been validated, though.");
        }
        if (!cloud.isValidated() && !((AzureActiveDirectoryOAuth2Configuration)this.getOAuth2Configuration()).isAuthorityHostValidationEnabled()) {
            Logger.warn(TAG + ":" + "getIssuerCacheIdentifier", "Authority host validation not specified...but there is no cloud...Hence just return the passed in Authority");
            return authRequest.getAuthority().toString();
        }
        Logger.info(TAG, "Building authority URI");
        Uri authorityUri = Uri.parse((String)authRequest.getAuthority().toString()).buildUpon().authority(cloud.getPreferredCacheHostName()).build();
        String issuerCacheIdentifier = authorityUri.toString();
        Logger.infoPII(TAG, "Issuer cache identifier created: " + issuerCacheIdentifier);
        return issuerCacheIdentifier;
    }

    @Override
    public AzureActiveDirectoryAccessToken getAccessTokenFromResponse(@NonNull AzureActiveDirectoryTokenResponse response) {
        AzureActiveDirectoryAccessToken at = new AzureActiveDirectoryAccessToken(response);
        return at;
    }

    @Override
    public AzureActiveDirectoryRefreshToken getRefreshTokenFromResponse(@NonNull AzureActiveDirectoryTokenResponse response) {
        AzureActiveDirectoryRefreshToken rt = new AzureActiveDirectoryRefreshToken(response);
        return rt;
    }

    @Override
    public AzureActiveDirectoryAccount createAccount(@NonNull AzureActiveDirectoryTokenResponse response) {
        String methodName = "createAccount";
        IDToken idToken = null;
        ClientInfo clientInfo = null;
        try {
            Logger.info(TAG, "Constructing IDToken from response");
            idToken = new IDToken(response.getIdToken());
            Logger.info(TAG, "Constructing ClientInfo from response");
            clientInfo = new ClientInfo(response.getClientInfo());
        }
        catch (ServiceException ccse) {
            Logger.error(TAG + ":" + "createAccount", "Failed to construct IDToken or ClientInfo", null);
            Logger.errorPII(TAG + ":" + "createAccount", "Failed with Exception", ccse);
        }
        AzureActiveDirectoryAccount account = AzureActiveDirectoryAccount.create(idToken, clientInfo);
        Logger.info(TAG, "Account created");
        Logger.infoPII(TAG, account.toString());
        return account;
    }

    @Override
    public AzureActiveDirectoryAuthorizationRequest.Builder createAuthorizationRequestBuilder() {
        return new AzureActiveDirectoryAuthorizationRequest.Builder();
    }

    @Override
    public AzureActiveDirectoryAuthorizationRequest.Builder createAuthorizationRequestBuilder(IAccountRecord account) {
        return this.createAuthorizationRequestBuilder();
    }

    @Override
    public AzureActiveDirectoryTokenRequest createTokenRequest(AzureActiveDirectoryAuthorizationRequest request, AzureActiveDirectoryAuthorizationResponse response) {
        return null;
    }

    @Override
    public AzureActiveDirectoryTokenRequest createRefreshTokenRequest(RefreshTokenRecord refreshToken, List<String> scopes) {
        return null;
    }

    @Override
    protected void validateAuthorizationRequest(AzureActiveDirectoryAuthorizationRequest request) {
    }

    @Override
    protected void validateTokenRequest(AzureActiveDirectoryTokenRequest request) {
    }

    @Override
    protected TokenResult getTokenResultFromHttpResponse(HttpResponse response) {
        String methodName = "getTokenResultFromHttpResponse";
        TokenResponse tokenResponse = null;
        TokenErrorResponse tokenErrorResponse = null;
        if (response.getStatusCode() >= 400) {
            Logger.warn(TAG + ":" + "getTokenResultFromHttpResponse", "Status code was: " + response.getStatusCode());
            tokenErrorResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), MicrosoftTokenErrorResponse.class);
        } else {
            tokenResponse = ObjectMapper.deserializeJsonStringToObject(response.getBody(), AzureActiveDirectoryTokenResponse.class);
        }
        TokenResult result = new TokenResult(tokenResponse, tokenErrorResponse);
        return result;
    }
}

