/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;

public final class ObjectMapper {
    public static final String ENCODING_SCHEME = "UTF-8";
    public static final String TAG = ObjectMapper.class.getSimpleName();

    private ObjectMapper() {
    }

    public static String serializeObjectToJsonString(Object object) {
        return new Gson().toJson(object);
    }

    public static <T> T deserializeJsonStringToObject(String json, Class<T> objectClass) {
        return (T)new Gson().fromJson(json, objectClass);
    }

    public static String serializeObjectToFormUrlEncoded(Object object) throws UnsupportedEncodingException {
        String json = ObjectMapper.serializeObjectToJsonString(object);
        Type stringMap = new TypeToken<TreeMap<String, String>>(){}.getType();
        TreeMap fields = (TreeMap)new Gson().fromJson(json, stringMap);
        StringBuilder builder = new StringBuilder();
        Iterator iterator = fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            builder.append(URLEncoder.encode((String)entry.getKey(), ENCODING_SCHEME));
            builder.append('=');
            builder.append(URLEncoder.encode((String)entry.getValue(), ENCODING_SCHEME));
            if (!iterator.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    public static Map<String, String> serializeObjectHashMap(Object object) throws UnsupportedEncodingException {
        String json = ObjectMapper.serializeObjectToJsonString(object);
        return ObjectMapper.serializeNestedJsonToMap(json);
    }

    public static Map<String, String> serializeNestedJsonToMap(String jsonString) throws UnsupportedEncodingException {
        if (StringUtil.isEmpty(jsonString)) {
            return null;
        }
        HashMap<String, String> objectMap = new HashMap<String, String>();
        Type stringMap = new TypeToken<TreeMap<String, Object>>(){}.getType();
        TreeMap fields = (TreeMap)new Gson().fromJson(jsonString, stringMap);
        for (Map.Entry entry : fields.entrySet()) {
            if (entry.getValue() instanceof String && !StringUtil.isEmpty((String)entry.getKey()) && !StringUtil.isEmpty((String)entry.getValue())) {
                objectMap.put(URLDecoder.decode((String)entry.getKey(), ENCODING_SCHEME), URLDecoder.decode((String)entry.getValue(), ENCODING_SCHEME));
                continue;
            }
            Map<String, String> hashMap = ObjectMapper.serializeNestedJsonToMap(entry.getValue().toString());
            if (hashMap == null) continue;
            objectMap.putAll(hashMap);
        }
        return objectMap;
    }

    public static Map<String, String> deserializeQueryStringToMap(String queryString) {
        HashMap<String, String> decodedUrlMap = new HashMap<String, String>();
        if (StringUtil.isEmpty(queryString)) {
            return decodedUrlMap;
        }
        StringTokenizer tokenizer = new StringTokenizer(queryString, "&");
        while (tokenizer.hasMoreTokens()) {
            String pair = tokenizer.nextToken();
            String[] elements = pair.split("=");
            if (elements.length != 2) continue;
            try {
                String key = URLDecoder.decode(elements[0], ENCODING_SCHEME);
                String value = URLDecoder.decode(elements[1], ENCODING_SCHEME);
                if (StringUtil.isEmpty(key) || StringUtil.isEmpty(value)) continue;
                decodedUrlMap.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error(TAG, null, "Decode failed.", e);
            }
        }
        return decodedUrlMap;
    }
}

