/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.net.Uri;
import com.microsoft.identity.common.adal.internal.util.DateExtensions;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import java.util.Date;

public class ADALUserInfo {
    private String mUniqueId;
    private String mDisplayableId;
    private String mGivenName;
    private String mFamilyName;
    private String mIdentityProvider;
    private transient Uri mPasswordChangeUrl;
    private transient Date mPasswordExpiresOn;

    public ADALUserInfo(AzureActiveDirectoryAccount account) {
        this.mUniqueId = account.getUserId();
        this.mDisplayableId = account.getDisplayableId();
        this.mGivenName = account.getFirstName();
        this.mFamilyName = account.getFamilyName();
        this.mIdentityProvider = account.getIdentityProvider();
        this.mPasswordChangeUrl = account.getPasswordChangeUrl();
        this.mPasswordExpiresOn = account.getPasswordExpiresOn();
    }

    public String getUserId() {
        return this.mUniqueId;
    }

    void setUserId(String userid) {
        this.mUniqueId = userid;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    public String getFamilyName() {
        return this.mFamilyName;
    }

    public String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    void setDisplayableId(String displayableId) {
        this.mDisplayableId = displayableId;
    }

    public Uri getPasswordChangeUrl() {
        return this.mPasswordChangeUrl;
    }

    public Date getPasswordExpiresOn() {
        return DateExtensions.createCopy(this.mPasswordExpiresOn);
    }

    public String toString() {
        return "ADALUserInfo{mUniqueId='" + this.mUniqueId + '\'' + ", mDisplayableId='" + this.mDisplayableId + '\'' + ", mGivenName='" + this.mGivenName + '\'' + ", mFamilyName='" + this.mFamilyName + '\'' + ", mIdentityProvider='" + this.mIdentityProvider + '\'' + ", mPasswordChangeUrl=" + this.mPasswordChangeUrl + ", mPasswordExpiresOn=" + this.mPasswordExpiresOn + '}';
    }
}

