/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.net.Uri;
import com.microsoft.identity.common.Account;
import com.microsoft.identity.common.internal.net.HttpRequest;
import com.microsoft.identity.common.internal.net.HttpResponse;
import com.microsoft.identity.common.internal.net.ObjectMapper;
import com.microsoft.identity.common.internal.providers.oauth2.AccessToken;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResponse;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Configuration;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenRequest;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResult;
import java.io.IOException;
import java.net.URL;
import java.util.TreeMap;
import java.util.UUID;

public abstract class OAuth2Strategy<GenericAccessToken extends AccessToken, GenericAccount extends Account, GenericAuthorizationRequest extends AuthorizationRequest, GenericAuthorizationResponse extends AuthorizationResponse, GenericAuthorizationStrategy extends AuthorizationStrategy, GenericOAuth2Configuration extends OAuth2Configuration, GenericRefreshToken extends RefreshToken, GenericTokenRequest extends TokenRequest, GenericTokenResponse extends TokenResponse, GenericTokenResult extends TokenResult> {
    protected static final String TOKEN_REQUEST_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final GenericOAuth2Configuration mConfig;
    private String mTokenEndpoint;
    private String mAuthorizationEndpoint;
    private Uri mIssuer;

    public OAuth2Strategy(GenericOAuth2Configuration config) {
        this.mConfig = config;
    }

    public GenericAuthorizationResponse requestAuthorization(GenericAuthorizationRequest request, GenericAuthorizationStrategy authorizationStrategy) {
        this.validateAuthorizationRequest(request);
        Uri authorizationUri = this.createAuthorizationUri();
        AuthorizationResult result = ((AuthorizationStrategy)authorizationStrategy).requestAuthorization((AuthorizationRequest)request);
        AuthorizationResponse response = new AuthorizationResponse();
        return (GenericAuthorizationResponse)response;
    }

    public GenericTokenResult requestToken(GenericTokenRequest request) throws IOException {
        this.validateTokenRequest(request);
        HttpResponse response = this.performTokenRequest(request);
        return this.getTokenResultFromHttpResponse(response);
    }

    protected HttpResponse performTokenRequest(GenericTokenRequest request) throws IOException {
        String requestBody = ObjectMapper.serializeObjectToFormUrlEncoded(request);
        TreeMap<String, String> headers = new TreeMap<String, String>();
        String correlationId = UUID.randomUUID().toString();
        headers.put("client-request-id", correlationId);
        return HttpRequest.sendPost(new URL(this.mTokenEndpoint), headers, requestBody.getBytes("UTF-8"), TOKEN_REQUEST_CONTENT_TYPE);
    }

    protected Uri createAuthorizationUri() {
        Uri authorizationUri = Uri.withAppendedPath((Uri)this.mIssuer, (String)this.mAuthorizationEndpoint);
        return authorizationUri;
    }

    public String getAuthorizationEndpoint() {
        return this.mAuthorizationEndpoint;
    }

    protected String getTokenEndpoint() {
        return this.mTokenEndpoint;
    }

    protected final void setTokenEndpoint(String tokenEndpoint) {
        this.mTokenEndpoint = tokenEndpoint;
    }

    protected GenericOAuth2Configuration getOAuth2Configuration() {
        return this.mConfig;
    }

    protected Uri getIssuer() {
        return this.mIssuer;
    }

    protected final void setIssuer(Uri issuer) {
        this.mIssuer = issuer;
    }

    public abstract String getIssuerCacheIdentifier(GenericAuthorizationRequest var1);

    public abstract GenericAccessToken getAccessTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericRefreshToken getRefreshTokenFromResponse(GenericTokenResponse var1);

    public abstract GenericAccount createAccount(GenericTokenResponse var1);

    protected abstract void validateAuthorizationRequest(GenericAuthorizationRequest var1);

    protected abstract void validateTokenRequest(GenericTokenRequest var1);

    protected abstract GenericTokenResult getTokenResultFromHttpResponse(HttpResponse var1);
}

