/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.util.Base64;
import com.microsoft.identity.common.adal.internal.util.JsonExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ServiceException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import org.json.JSONException;

public class IDToken {
    public static final String SUBJECT = "sub";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";
    public static final String FAMILY_NAME = "family_name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NICKNAME = "nickname";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String PROFILE = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String LOCALE = "locale";
    public static final String PHONE_NUMBER = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    public static final String ADDRESS = "address";
    public static final String UPDATED_AT = "updated_at";
    private Map<String, String> mTokenClaims = null;
    private final String mRawIdToken;

    public IDToken(String rawIdToken) throws ServiceException {
        if (StringExtensions.isNullOrBlank(rawIdToken)) {
            throw new IllegalArgumentException("null or empty raw idtoken");
        }
        this.mRawIdToken = rawIdToken;
        this.mTokenClaims = this.parseJWT(rawIdToken);
    }

    public String getRawIDToken() {
        return this.mRawIdToken;
    }

    public Map<String, String> getTokenClaims() {
        return Collections.unmodifiableMap(this.mTokenClaims);
    }

    private Map<String, String> parseJWT(String idToken) throws ServiceException {
        String idTokenBody = this.extractJWTBody(idToken);
        byte[] data = Base64.decode((String)idTokenBody, (int)8);
        try {
            String decodedBody = new String(data, Charset.forName("UTF_8"));
            return JsonExtensions.extractJsonObjectIntoMap(decodedBody);
        }
        catch (JSONException e) {
            throw new ServiceException("", "invalid_jwt", e);
        }
    }

    private String extractJWTBody(String idToken) {
        int firstDot = idToken.indexOf(46);
        int secondDot = idToken.indexOf(46, firstDot + 1);
        int invalidDot = idToken.indexOf(46, secondDot + 1);
        if (invalidDot == -1 && firstDot > 0 && secondDot > 0) {
            return idToken.substring(firstDot + 1, secondDot);
        }
        throw new IllegalArgumentException("Invalid ID token format.");
    }
}

