/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;

public class AzureActiveDirectoryCloud {
    @SerializedName(value="preferred_network")
    private final String mPreferredNetworkHostName;
    @SerializedName(value="preferred_cache")
    private final String mPreferredCacheHostName;
    @SerializedName(value="aliases")
    private List<String> mCloudHostAliases;
    private boolean mIsValidated;

    public AzureActiveDirectoryCloud(boolean isValidated) {
        this.mIsValidated = isValidated;
        this.mPreferredNetworkHostName = null;
        this.mPreferredCacheHostName = null;
    }

    public AzureActiveDirectoryCloud(String preferredNetwork, String preferredCache, List<String> aliases) {
        this.mPreferredNetworkHostName = preferredNetwork;
        this.mPreferredCacheHostName = preferredCache;
        this.mCloudHostAliases = new ArrayList<String>();
        this.mCloudHostAliases.addAll(aliases);
        this.mIsValidated = true;
    }

    AzureActiveDirectoryCloud(String preferredNetwork, String preferredCache) {
        this.mPreferredNetworkHostName = preferredNetwork;
        this.mPreferredCacheHostName = preferredCache;
        this.mIsValidated = true;
    }

    public String getPreferredNetworkHostName() {
        return this.mPreferredNetworkHostName;
    }

    public String getPreferredCacheHostName() {
        return this.mPreferredCacheHostName;
    }

    public List<String> getHostAliases() {
        return this.mCloudHostAliases;
    }

    boolean isValidated() {
        return this.mIsValidated;
    }

    void setIsValidated(boolean isValidated) {
        this.mIsValidated = isValidated;
    }
}

