/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.providers.IdentityProvider;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Strategy;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.json.JSONException;

public class AzureActiveDirectory
extends IdentityProvider<AzureActiveDirectoryOAuth2Strategy, AzureActiveDirectoryOAuth2Configuration> {
    private static final String TENANT_DISCOVERY_ENDPOINT = "tenant_discovery_endpoint";
    private static final String METADATA = "metadata";
    private static ConcurrentMap<String, AzureActiveDirectoryCloud> sAadClouds = new ConcurrentHashMap<String, AzureActiveDirectoryCloud>();

    @Override
    public AzureActiveDirectoryOAuth2Strategy createOAuth2Strategy(AzureActiveDirectoryOAuth2Configuration config) {
        return new AzureActiveDirectoryOAuth2Strategy(config);
    }

    static boolean hasCloudHost(URL authorityUrl) {
        return sAadClouds.containsKey(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    static boolean isValidCloudHost(URL authorityUrl) {
        return AzureActiveDirectory.hasCloudHost(authorityUrl) && AzureActiveDirectory.getAzureActiveDirectoryCloud(authorityUrl).isValidated();
    }

    public static AzureActiveDirectoryCloud getAzureActiveDirectoryCloud(URL authorityUrl) {
        return (AzureActiveDirectoryCloud)sAadClouds.get(authorityUrl.getHost().toLowerCase(Locale.US));
    }

    public static void putCloud(String host, AzureActiveDirectoryCloud cloud) {
        sAadClouds.put(host.toLowerCase(Locale.US), cloud);
    }

    public static void initializeCloudMetadata(String authorityHost, Map<String, String> discoveryResponse) throws JSONException {
        boolean tenantDiscoveryEndpointReturned = discoveryResponse.containsKey(TENANT_DISCOVERY_ENDPOINT);
        String metadata = discoveryResponse.get(METADATA);
        if (!tenantDiscoveryEndpointReturned) {
            sAadClouds.put(authorityHost, new AzureActiveDirectoryCloud(false));
            return;
        }
        if (StringExtensions.isNullOrBlank(metadata)) {
            sAadClouds.put(authorityHost, new AzureActiveDirectoryCloud(authorityHost, authorityHost));
            return;
        }
        List<AzureActiveDirectoryCloud> clouds = AzureActiveDirectory.deserializeClouds(metadata);
        for (AzureActiveDirectoryCloud cloud : clouds) {
            cloud.setIsValidated(true);
            for (String alias : cloud.getHostAliases()) {
                sAadClouds.put(alias.toLowerCase(Locale.US), cloud);
            }
        }
    }

    private static List<AzureActiveDirectoryCloud> deserializeClouds(String jsonCloudArray) throws JSONException {
        Type listType = new TypeToken<List<AzureActiveDirectoryCloud>>(){}.getType();
        return (List)new Gson().fromJson(jsonCloudArray, listType);
    }
}

