/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft;

import android.support.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;

public class MicrosoftRefreshToken
extends RefreshToken {
    private ClientInfo mClientInfo;
    private IDToken mIdToken;
    private String mFamilyId;
    private String mScope;
    private String mClientId;
    private boolean mIsFamilyRefreshToken;

    public MicrosoftRefreshToken(@NonNull MicrosoftTokenResponse tokenResponse) {
        super(tokenResponse);
        try {
            this.mClientInfo = new ClientInfo(tokenResponse.getClientInfo());
            this.mIdToken = new IDToken(tokenResponse.getIdToken());
            this.mFamilyId = tokenResponse.getFamilyId();
            this.mScope = tokenResponse.getScope();
            this.mClientId = tokenResponse.getClientId();
            this.mIsFamilyRefreshToken = !StringExtensions.isNullOrBlank(this.mFamilyId);
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getHomeAccountId() {
        return SchemaUtil.getHomeAccountId(this.mClientInfo);
    }

    @Override
    public String getEnvironment() {
        return SchemaUtil.getEnvironment(this.mIdToken);
    }

    @Override
    public String getClientId() {
        return this.mClientId;
    }

    @Override
    public String getSecret() {
        return this.getRefreshToken();
    }

    @Override
    public String getTarget() {
        return this.mScope;
    }

    @Override
    public String getFamilyId() {
        return this.mFamilyId;
    }

    public boolean getIsFamilyRefreshToken() {
        return this.mIsFamilyRefreshToken;
    }

    public ClientInfo getClientInfo() {
        return this.mClientInfo;
    }
}

