/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public final class ObjectMapper {
    public static final String ENCODING_SCHEME = "UTF-8";

    private ObjectMapper() {
    }

    public static String serializeObjectToJsonString(Object object) {
        return new Gson().toJson(object);
    }

    public static <T> T deserializeJsonStringToObject(String json, Class<T> objectClass) {
        return (T)new Gson().fromJson(json, objectClass);
    }

    public static String serializeObjectToFormUrlEncoded(Object object) throws UnsupportedEncodingException {
        String json = ObjectMapper.serializeObjectToJsonString(object);
        Type stringMap = new TypeToken<TreeMap<String, String>>(){}.getType();
        TreeMap fields = (TreeMap)new Gson().fromJson(json, stringMap);
        StringBuilder builder = new StringBuilder();
        Iterator iterator = fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            builder.append(URLEncoder.encode((String)entry.getKey(), ENCODING_SCHEME));
            builder.append('=');
            builder.append(URLEncoder.encode((String)entry.getValue(), ENCODING_SCHEME));
            if (!iterator.hasNext()) continue;
            builder.append('&');
        }
        return builder.toString();
    }
}

