/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.util;

import android.text.TextUtils;
import android.util.Log;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

public final class HashMapExtensions {
    private static final String TAG = "HashMapExtensions";

    private HashMapExtensions() {
    }

    static HashMap<String, String> urlFormDecode(String parameters) {
        return HashMapExtensions.urlFormDecodeData(parameters, "&");
    }

    static HashMap<String, String> urlFormDecodeData(String parameters, String delimiter) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringExtensions.isNullOrBlank(parameters)) {
            StringTokenizer parameterTokenizer = new StringTokenizer(parameters, delimiter);
            while (parameterTokenizer.hasMoreTokens()) {
                String pair = parameterTokenizer.nextToken();
                String[] elements = pair.split("=");
                if (elements.length != 2) continue;
                String key = null;
                String value = null;
                try {
                    key = StringExtensions.urlFormDecode(elements[0].trim());
                    value = StringExtensions.urlFormDecode(elements[1].trim());
                }
                catch (UnsupportedEncodingException e) {
                    Log.d((String)TAG, (String)e.getMessage());
                }
                if (StringExtensions.isNullOrBlank(key) || StringExtensions.isNullOrBlank(value)) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    public static Map<String, String> getJsonResponse(HttpWebResponse webResponse) throws JSONException {
        HashMap<String, String> response = new HashMap<String, String>();
        if (webResponse != null && !TextUtils.isEmpty((CharSequence)webResponse.getBody())) {
            JSONObject jsonObject = new JSONObject(webResponse.getBody());
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                response.put(key, jsonObject.getString(key));
            }
        }
        return response;
    }
}

