/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.support.annotation.NonNull;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.IShareSingleSignOnState;
import com.microsoft.identity.common.internal.dto.AccessToken;
import com.microsoft.identity.common.internal.dto.Account;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdToken;
import com.microsoft.identity.common.internal.dto.RefreshToken;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2TokenCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MsalOAuth2TokenCache
extends OAuth2TokenCache<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse>
implements IShareSingleSignOnState<MicrosoftAccount, MicrosoftRefreshToken> {
    private static final String TAG = MsalOAuth2TokenCache.class.getSimpleName();
    private List<IShareSingleSignOnState> mSharedSsoCaches;
    private IAccountCredentialCache mAccountCredentialCache;
    private IAccountCredentialAdapter<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> mAccountCredentialAdapter;

    public MsalOAuth2TokenCache(Context context, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> accountCredentialAdapter) {
        super(context);
        Logger.verbose(TAG, "Init: " + TAG);
        this.mAccountCredentialCache = accountCredentialCache;
        this.mSharedSsoCaches = new ArrayList<IShareSingleSignOnState>();
        this.mAccountCredentialAdapter = accountCredentialAdapter;
    }

    public MsalOAuth2TokenCache(Context context, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> accountCredentialAdapter, List<IShareSingleSignOnState> sharedSsoCaches) {
        super(context);
        Logger.verbose(TAG, "Init: " + TAG);
        this.mAccountCredentialCache = accountCredentialCache;
        this.mSharedSsoCaches = sharedSsoCaches;
        this.mAccountCredentialAdapter = accountCredentialAdapter;
    }

    @Override
    public void saveTokens(MicrosoftStsOAuth2Strategy oAuth2Strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) throws ClientException {
        Account accountToSave = this.mAccountCredentialAdapter.createAccount(oAuth2Strategy, request, response);
        AccessToken accessTokenToSave = this.mAccountCredentialAdapter.createAccessToken(oAuth2Strategy, request, response);
        RefreshToken refreshTokenToSave = this.mAccountCredentialAdapter.createRefreshToken(oAuth2Strategy, request, response);
        IdToken idTokenToSave = this.mAccountCredentialAdapter.createIdToken(oAuth2Strategy, request, response);
        this.validateCacheArtifacts(accountToSave, accessTokenToSave, refreshTokenToSave, idTokenToSave);
        this.saveAccounts(accountToSave);
        this.saveCredentials(accessTokenToSave, refreshTokenToSave, idTokenToSave);
    }

    private void saveAccounts(Account ... accounts) {
        for (Account account : accounts) {
            this.mAccountCredentialCache.saveAccount(account);
        }
    }

    private void saveCredentials(Credential ... credentials) {
        for (Credential credential : credentials) {
            if (credential instanceof AccessToken) {
                this.deleteAccessTokensWithIntersectingScopes((AccessToken)credential);
            }
            this.mAccountCredentialCache.saveCredential(credential);
        }
    }

    private void validateCacheArtifacts(@NonNull Account accountToSave, AccessToken accessTokenToSave, @NonNull RefreshToken refreshTokenToSave, @NonNull IdToken idTokenToSave) throws ClientException {
        boolean isAccountCompliant = MsalOAuth2TokenCache.isAccountSchemaCompliant(accountToSave);
        boolean isAccessTokenCompliant = null == accessTokenToSave || MsalOAuth2TokenCache.isAccessTokenSchemaCompliant(accessTokenToSave);
        boolean isRefreshTokenCompliant = MsalOAuth2TokenCache.isRefreshTokenSchemaCompliant(refreshTokenToSave);
        boolean isIdTokenCompliant = MsalOAuth2TokenCache.isIdTokenSchemaCompliant(idTokenToSave);
        if (!isAccountCompliant) {
            throw new ClientException("Account is missing schema-required fields.");
        }
        if (!(isAccessTokenCompliant && isRefreshTokenCompliant && isIdTokenCompliant)) {
            String nonCompliantCredentials = "[";
            if (!isAccessTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(AT)";
            }
            if (!isRefreshTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(RT)";
            }
            if (!isIdTokenCompliant) {
                nonCompliantCredentials = nonCompliantCredentials + "(ID)";
            }
            nonCompliantCredentials = nonCompliantCredentials + "]";
            throw new ClientException("Credential is missing schema-required fields.", nonCompliantCredentials);
        }
    }

    private void deleteAccessTokensWithIntersectingScopes(AccessToken referenceToken) {
        String methodName = "deleteAccessTokensWithIntersectingScopes";
        List<Credential> accessTokens = this.mAccountCredentialCache.getCredentialsFilteredBy(referenceToken.getHomeAccountId(), referenceToken.getEnvironment(), CredentialType.AccessToken, referenceToken.getClientId(), referenceToken.getRealm(), null);
        Logger.verbose(TAG + ":" + "deleteAccessTokensWithIntersectingScopes", "Inspecting " + accessTokens.size() + " accessToken[s].");
        for (Credential accessToken : accessTokens) {
            if (!this.scopesIntersect(referenceToken, (AccessToken)accessToken)) continue;
            Logger.infoPII(TAG + ":" + "deleteAccessTokensWithIntersectingScopes", "Removing credential: " + accessToken);
            this.mAccountCredentialCache.removeCredential(accessToken);
        }
    }

    private boolean scopesIntersect(AccessToken token1, AccessToken token2) {
        String methodName = "scopesIntersect";
        Set<String> token1Scopes = this.scopesAsSet(token1);
        Set<String> token2Scopes = this.scopesAsSet(token2);
        boolean result = false;
        for (String scope : token2Scopes) {
            if (!token1Scopes.contains(scope)) continue;
            Logger.info(TAG + ":" + "scopesIntersect", "Scopes intersect.");
            Logger.infoPII(TAG + ":" + "scopesIntersect", token1Scopes.toString() + " contains [" + scope + "]");
            result = true;
            break;
        }
        return result;
    }

    private Set<String> scopesAsSet(AccessToken token) {
        HashSet<String> scopeSet = new HashSet<String>();
        String scopeString = token.getTarget();
        if (!StringExtensions.isNullOrBlank(scopeString)) {
            String[] scopeArray = scopeString.split("\\s+");
            scopeSet.addAll(Arrays.asList(scopeArray));
        }
        return scopeSet;
    }

    private static boolean isSchemaCompliant(Class<?> clazz, String[][] params) {
        String methodName = "isSchemaCompliant";
        boolean isCompliant = true;
        for (String[] param : params) {
            isCompliant = isCompliant && !StringExtensions.isNullOrBlank(param[1]);
        }
        if (!isCompliant) {
            Logger.warn(TAG + ":" + "isSchemaCompliant", clazz.getSimpleName() + " does not contain all required fields.");
            for (String[] param : params) {
                Logger.warn(TAG + ":" + "isSchemaCompliant", param[0] + " is null? [" + StringExtensions.isNullOrBlank(param[1]) + "]");
            }
        }
        return isCompliant;
    }

    private static boolean isAccountSchemaCompliant(@NonNull Account account) {
        String[][] params = new String[][]{{"home_account_id", account.getHomeAccountId()}, {"environment", account.getEnvironment()}, {"realm", account.getRealm()}, {"local_account_id", account.getLocalAccountId()}, {"username", account.getUsername()}, {"authority_type", account.getAuthorityType()}};
        boolean isCompliant = MsalOAuth2TokenCache.isSchemaCompliant(account.getClass(), params);
        return isCompliant;
    }

    private static boolean isAccessTokenSchemaCompliant(@NonNull AccessToken accessToken) {
        String[][] params = new String[][]{{"credential_type", accessToken.getCredentialType()}, {"home_account_id", accessToken.getHomeAccountId()}, {"realm", accessToken.getRealm()}, {"environment", accessToken.getEnvironment()}, {"client_id", accessToken.getClientId()}, {"target", accessToken.getTarget()}, {"cached_at", accessToken.getCachedAt()}, {"expires_on", accessToken.getExpiresOn()}, {"secret", accessToken.getSecret()}};
        boolean isValid = MsalOAuth2TokenCache.isSchemaCompliant(accessToken.getClass(), params);
        return isValid;
    }

    private static boolean isRefreshTokenSchemaCompliant(@NonNull RefreshToken refreshToken) {
        String[][] params = new String[][]{{"credential_type", refreshToken.getCredentialType()}, {"environment", refreshToken.getEnvironment()}, {"home_account_id", refreshToken.getHomeAccountId()}, {"client_id", refreshToken.getClientId()}, {"secret", refreshToken.getSecret()}};
        boolean isValid = MsalOAuth2TokenCache.isSchemaCompliant(refreshToken.getClass(), params);
        return isValid;
    }

    private static boolean isIdTokenSchemaCompliant(@NonNull IdToken idToken) {
        String[][] params = new String[][]{{"home_account_id", idToken.getHomeAccountId()}, {"environment", idToken.getEnvironment()}, {"realm", idToken.getRealm()}, {"credential_type", idToken.getCredentialType()}, {"client_id", idToken.getClientId()}, {"secret", idToken.getSecret()}};
        boolean isValid = MsalOAuth2TokenCache.isSchemaCompliant(idToken.getClass(), params);
        return isValid;
    }

    @Override
    public void setSingleSignOnState(MicrosoftAccount account, MicrosoftRefreshToken refreshToken) {
        String methodName = "setSingleSignOnState";
        try {
            Account accountDto = this.mAccountCredentialAdapter.asAccount(account);
            RefreshToken rt = this.mAccountCredentialAdapter.asRefreshToken(refreshToken);
            IdToken idToken = this.mAccountCredentialAdapter.asIdToken(account, refreshToken);
            this.validateCacheArtifacts(accountDto, null, rt, idToken);
            this.mAccountCredentialCache.saveAccount(accountDto);
            this.mAccountCredentialCache.saveCredential(idToken);
            this.mAccountCredentialCache.saveCredential(rt);
        }
        catch (ClientException e) {
            Logger.error(TAG + ":" + "setSingleSignOnState", "", new IllegalArgumentException("Cannot set SSO state. Invalid or inadequate Account and/or token provided. (See logs)", e));
        }
    }

    @Override
    public MicrosoftRefreshToken getSingleSignOnState(MicrosoftAccount account) {
        MicrosoftRefreshToken result = null;
        return result;
    }
}

