/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.support.annotation.NonNull;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.dto.AccessToken;
import com.microsoft.identity.common.internal.dto.Account;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IdToken;
import com.microsoft.identity.common.internal.dto.RefreshToken;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftAccount;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftIdToken;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsTokenResponse;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;
import java.util.concurrent.TimeUnit;

public class MicrosoftStsAccountCredentialAdapter
implements IAccountCredentialAdapter<MicrosoftStsOAuth2Strategy, MicrosoftStsAuthorizationRequest, MicrosoftStsTokenResponse, MicrosoftAccount, MicrosoftRefreshToken> {
    private static final String TAG = MicrosoftStsAccountCredentialAdapter.class.getSimpleName();
    private static final String BEARER = "Bearer";

    @Override
    public Account createAccount(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        Logger.verbose(TAG, "Creating Account");
        Account account = new Account(strategy.createAccount(response));
        return account;
    }

    @Override
    public AccessToken createAccessToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            long cachedAt = this.getCachedAt();
            long expiresOn = this.getExpiresOn(response);
            MicrosoftIdToken msIdToken = new MicrosoftIdToken(response.getIdToken());
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            AccessToken accessToken = new AccessToken();
            accessToken.setCredentialType(CredentialType.AccessToken.name());
            accessToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            accessToken.setRealm(this.getRealm(strategy, response));
            accessToken.setEnvironment(SchemaUtil.getEnvironment(msIdToken));
            accessToken.setClientId(request.getClientId());
            accessToken.setTarget(request.getScope());
            accessToken.setCachedAt(String.valueOf(cachedAt));
            accessToken.setExpiresOn(String.valueOf(expiresOn));
            accessToken.setSecret(response.getAccessToken());
            accessToken.setExtendedExpiresOn(this.getExtendedExpiresOn(strategy, response));
            accessToken.setAuthority(request.getAuthority().toString());
            accessToken.setClientInfo(response.getClientInfo());
            accessToken.setAccessTokenType(BEARER);
            return accessToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RefreshToken createRefreshToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            long cachedAt = this.getCachedAt();
            MicrosoftIdToken msIdToken = new MicrosoftIdToken(response.getIdToken());
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            RefreshToken refreshToken = new RefreshToken();
            refreshToken.setCredentialType(CredentialType.RefreshToken.name());
            refreshToken.setEnvironment(SchemaUtil.getEnvironment(msIdToken));
            refreshToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            refreshToken.setClientId(response.getClientId());
            refreshToken.setSecret(response.getRefreshToken());
            refreshToken.setFamilyId(response.getFamilyId());
            refreshToken.setTarget(request.getScope());
            refreshToken.setClientInfo(response.getClientInfo());
            refreshToken.setCachedAt(String.valueOf(cachedAt));
            return refreshToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IdToken createIdToken(MicrosoftStsOAuth2Strategy strategy, MicrosoftStsAuthorizationRequest request, MicrosoftStsTokenResponse response) {
        try {
            ClientInfo clientInfo = new ClientInfo(response.getClientInfo());
            MicrosoftIdToken msIdToken = new MicrosoftIdToken(response.getIdToken());
            IdToken idToken = new IdToken();
            idToken.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            idToken.setEnvironment(SchemaUtil.getEnvironment(msIdToken));
            idToken.setRealm(this.getRealm(strategy, response));
            idToken.setCredentialType(CredentialType.IdToken.name());
            idToken.setClientId(request.getClientId());
            idToken.setSecret(response.getIdToken());
            idToken.setAuthority(request.getAuthority().toString());
            return idToken;
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RefreshToken asRefreshToken(@NonNull MicrosoftRefreshToken refreshTokenIn) {
        RefreshToken refreshTokenOut = new RefreshToken();
        refreshTokenOut.setHomeAccountId(refreshTokenIn.getHomeAccountId());
        refreshTokenOut.setEnvironment(refreshTokenIn.getEnvironment());
        refreshTokenOut.setCredentialType(CredentialType.RefreshToken.name());
        refreshTokenOut.setClientId(refreshTokenIn.getClientId());
        refreshTokenOut.setSecret(refreshTokenIn.getSecret());
        refreshTokenOut.setTarget(refreshTokenIn.getTarget());
        refreshTokenOut.setCachedAt(String.valueOf(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())));
        refreshTokenOut.setClientInfo(refreshTokenIn.getClientInfo().getRawClientInfo());
        refreshTokenOut.setFamilyId(refreshTokenIn.getFamilyId());
        return refreshTokenOut;
    }

    @Override
    public Account asAccount(MicrosoftAccount account) {
        Account acct = new Account(account);
        return acct;
    }

    @Override
    public IdToken asIdToken(MicrosoftAccount msAccount, MicrosoftRefreshToken refreshToken) {
        long cachedAt = this.getCachedAt();
        IDToken msIdToken = msAccount.getIDToken();
        IdToken idToken = new IdToken();
        idToken.setHomeAccountId(refreshToken.getHomeAccountId());
        idToken.setEnvironment(refreshToken.getEnvironment());
        idToken.setRealm(msAccount.getRealm());
        idToken.setCredentialType(CredentialType.IdToken.name());
        idToken.setClientId(refreshToken.getClientId());
        idToken.setSecret(msIdToken.getRawIDToken());
        idToken.setCachedAt(String.valueOf(cachedAt));
        idToken.setAuthority(SchemaUtil.getAuthority(msIdToken));
        return idToken;
    }

    private String getExtendedExpiresOn(OAuth2Strategy strategy, TokenResponse response) {
        String result = null;
        return result;
    }

    private String getRealm(MicrosoftStsOAuth2Strategy msStrategy, MicrosoftStsTokenResponse msTokenResponse) {
        MicrosoftStsAccount msAccount = msStrategy.createAccount(msTokenResponse);
        return msAccount.getRealm();
    }

    private long getCachedAt() {
        long currentTimeMillis = System.currentTimeMillis();
        long cachedAt = TimeUnit.MILLISECONDS.toSeconds(currentTimeMillis);
        return cachedAt;
    }

    private long getExpiresOn(MicrosoftStsTokenResponse msTokenResponse) {
        long millisSince1970 = msTokenResponse.getExpiresOn().getTime();
        long secondsSince1970 = TimeUnit.MILLISECONDS.toSeconds(millisSince1970);
        return secondsSince1970;
    }
}

