/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.adal.internal.net;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import com.microsoft.identity.common.adal.internal.PowerManagerWrapper;
import com.microsoft.identity.common.adal.internal.UsageStatsManagerWrapper;
import com.microsoft.identity.common.adal.internal.net.IConnectionService;

public class DefaultConnectionService
implements IConnectionService {
    private final Context mConnectionContext;

    public DefaultConnectionService(Context ctx) {
        this.mConnectionContext = ctx;
    }

    @Override
    public boolean isConnectionAvailable() {
        ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
        NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
        return activeNetwork != null && activeNetwork.isConnectedOrConnecting() && !this.isNetworkDisabledFromOptimizations();
    }

    @TargetApi(value=23)
    public boolean isNetworkDisabledFromOptimizations() {
        if (Build.VERSION.SDK_INT >= 23) {
            UsageStatsManagerWrapper usageStatsManagerWrapper = UsageStatsManagerWrapper.getInstance();
            if (usageStatsManagerWrapper.isAppInactive(this.mConnectionContext)) {
                return true;
            }
            PowerManagerWrapper powerManagerWrapper = PowerManagerWrapper.getInstance();
            if (powerManagerWrapper.isDeviceIdleMode(this.mConnectionContext) && !powerManagerWrapper.isIgnoringBatteryOptimizations(this.mConnectionContext)) {
                return true;
            }
        }
        return false;
    }
}

