/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.constraintlayout.widget.ConstraintSet;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.microsoft.device.display.DisplayMask;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.java.flighting.CommonFlight;
import com.microsoft.identity.common.java.flighting.CommonFlightsManager;
import com.microsoft.identity.common.java.flighting.IFlightConfig;
import com.microsoft.identity.common.logging.Logger;
import java.util.List;

public class DualScreenActivity
extends FragmentActivity {
    public void setContentView(int layoutResID) {
        this.initializeContentView();
        RelativeLayout contentLayout = (RelativeLayout)this.findViewById(R.id.dual_screen_content);
        LayoutInflater.from((Context)this).inflate(layoutResID, (ViewGroup)contentLayout);
    }

    private void initializeContentView() {
        super.setContentView(R.layout.dual_screen_layout);
        if (CommonFlightsManager.INSTANCE.getFlightsProvider().isFlightEnabled((IFlightConfig)CommonFlight.ENABLE_HANDLING_FOR_EDGE_TO_EDGE)) {
            try {
                ViewCompat.setOnApplyWindowInsetsListener((View)this.findViewById(0x1020002), (view, insets) -> {
                    int topInset = insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).top;
                    int bottomInset = insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).bottom;
                    int leftInset = insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).left;
                    int rightInset = insets.getInsets((int)WindowInsetsCompat.Type.systemBars()).right;
                    view.setPadding(leftInset, topInset, rightInset, bottomInset);
                    return insets;
                });
            }
            catch (Throwable throwable) {
                Logger.warn("DualScreenActivity:initializeContentView", "Failed to set OnApplyWindowInsetsListener");
            }
        }
        this.adjustLayoutForDualScreenActivity();
    }

    public void setFragment(@NonNull Fragment fragment) {
        this.initializeContentView();
        this.getSupportFragmentManager().beginTransaction().setTransitionStyle(4099).replace(R.id.dual_screen_content, fragment).commit();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.adjustLayoutForDualScreenActivity();
    }

    private void adjustLayoutForDualScreenActivity() {
        int rotation = this.getRotation((Activity)this);
        boolean isAppSpanned = this.isAppSpanned((Activity)this);
        boolean isHorizontal = rotation == 0 || rotation == 2;
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.connect(R.id.dual_screen_content, 1, R.id.dual_screen_layout, 1, 0);
        constraintSet.connect(R.id.dual_screen_content, 2, R.id.dual_screen_layout, 2, 0);
        constraintSet.connect(R.id.dual_screen_content, 3, R.id.dual_screen_layout, 3, 0);
        constraintSet.connect(R.id.dual_screen_content, 4, R.id.dual_screen_layout, 4, 0);
        constraintSet.connect(R.id.dual_screen_empty_view, 1, R.id.dual_screen_layout, 1, 0);
        constraintSet.connect(R.id.dual_screen_empty_view, 2, R.id.dual_screen_layout, 2, 0);
        constraintSet.connect(R.id.dual_screen_empty_view, 3, R.id.dual_screen_layout, 3, 0);
        constraintSet.connect(R.id.dual_screen_empty_view, 4, R.id.dual_screen_layout, 4, 0);
        this.getWindow().setSoftInputMode(16);
        if (isAppSpanned) {
            int duoHingeWidth;
            if (isHorizontal) {
                duoHingeWidth = this.getHinge((Context)this, rotation).width() / 2;
                constraintSet.connect(R.id.dual_screen_content, 1, R.id.vertical_guideline, 2, duoHingeWidth);
                constraintSet.connect(R.id.dual_screen_empty_view, 2, R.id.vertical_guideline, 1, 0);
            } else {
                duoHingeWidth = this.getHinge((Context)this, rotation).height() / 2;
                constraintSet.connect(R.id.dual_screen_content, 4, R.id.horizontal_guideline, 3, duoHingeWidth);
                constraintSet.connect(R.id.dual_screen_empty_view, 3, R.id.horizontal_guideline, 4, 0);
                this.getWindow().setSoftInputMode(48);
            }
        } else {
            constraintSet.clear(R.id.dual_screen_empty_view);
        }
        ConstraintLayout dualScreenLayout = (ConstraintLayout)this.findViewById(R.id.dual_screen_layout);
        dualScreenLayout.setConstraintSet(constraintSet);
    }

    public boolean isAppSpanned(Activity activity) {
        if (!this.isDualScreenDevice((Context)activity)) {
            return false;
        }
        int rotation = this.getRotation(activity);
        Rect hinge = this.getHinge((Context)activity, rotation);
        Rect windowRect = this.getWindowRect(activity);
        if (windowRect.width() > 0 && windowRect.height() > 0) {
            return hinge.intersect(windowRect);
        }
        return false;
    }

    public int getRotation(Activity activity) {
        WindowManager wm = (WindowManager)activity.getSystemService("window");
        int rotation = 0;
        if (wm != null) {
            rotation = wm.getDefaultDisplay().getRotation();
        }
        return rotation;
    }

    private boolean isDualScreenDevice(Context context) {
        String feature = "com.microsoft.device.display.displaymask";
        PackageManager pm = context.getPackageManager();
        return pm.hasSystemFeature("com.microsoft.device.display.displaymask");
    }

    private Rect getHinge(Context context, int rotation) {
        String methodTag = "DualScreenActivity:getHinge";
        try {
            DisplayMask displayMask = DisplayMask.fromResourcesRect((Context)context);
            List boundings = displayMask.getBoundingRectsForRotation(rotation);
            if (boundings.size() == 0) {
                return new Rect(0, 0, 0, 0);
            }
            return (Rect)boundings.get(0);
        }
        catch (Throwable throwable) {
            Logger.error("DualScreenActivity:getHinge", "Failed to get hinge rect", throwable);
            return new Rect(0, 0, 0, 0);
        }
    }

    private Rect getWindowRect(Activity activity) {
        Rect windowRect = new Rect();
        activity.getWindowManager().getDefaultDisplay().getRectSize(windowRect);
        return windowRect;
    }
}

