/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.nativeauth.internal.controllers;

import androidx.annotation.VisibleForTesting;
import com.microsoft.identity.common.internal.commands.RefreshOnCommand;
import com.microsoft.identity.common.internal.telemetry.Telemetry;
import com.microsoft.identity.common.internal.telemetry.events.ApiEndEvent;
import com.microsoft.identity.common.java.AuthenticationConstants;
import com.microsoft.identity.common.java.authscheme.AbstractAuthenticationScheme;
import com.microsoft.identity.common.java.cache.ICacheRecord;
import com.microsoft.identity.common.java.commands.BaseCommand;
import com.microsoft.identity.common.java.commands.parameters.CommandParameters;
import com.microsoft.identity.common.java.commands.parameters.SilentTokenCommandParameters;
import com.microsoft.identity.common.java.configuration.LibraryConfiguration;
import com.microsoft.identity.common.java.controllers.CommandDispatcher;
import com.microsoft.identity.common.java.dto.AccountRecord;
import com.microsoft.identity.common.java.exception.ArgumentException;
import com.microsoft.identity.common.java.exception.ClientException;
import com.microsoft.identity.common.java.exception.ServiceException;
import com.microsoft.identity.common.java.logging.LogSession;
import com.microsoft.identity.common.java.logging.Logger;
import com.microsoft.identity.common.java.nativeauth.authorities.NativeAuthCIAMAuthority;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.AcquireTokenNoFixedScopesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseNativeAuthCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.BaseSignInTokenCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.ResetPasswordSubmitNewPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignInWithContinuationTokenCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpResendCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpStartCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitCodeCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitPasswordCommandParameters;
import com.microsoft.identity.common.java.nativeauth.commands.parameters.SignUpSubmitUserAttributesCommandParameters;
import com.microsoft.identity.common.java.nativeauth.controllers.results.INativeAuthCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordResendCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordStartCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordSubmitCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.ResetPasswordSubmitNewPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInResendCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInStartCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInSubmitCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInSubmitPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignInWithContinuationTokenCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpResendCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpStartCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitCodeCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitPasswordCommandResult;
import com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitUserAttributesCommandResult;
import com.microsoft.identity.common.java.nativeauth.providers.NativeAuthOAuth2Strategy;
import com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordPollCompletionApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordStartApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.resetpassword.ResetPasswordSubmitApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInInitiateApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signin.SignInTokenApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpChallengeApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpContinueApiResult;
import com.microsoft.identity.common.java.nativeauth.providers.responses.signup.SignUpStartApiResult;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsAuthorizationRequest;
import com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2StrategyParameters;
import com.microsoft.identity.common.java.providers.oauth2.OAuth2TokenCache;
import com.microsoft.identity.common.java.providers.oauth2.TokenResponse;
import com.microsoft.identity.common.java.request.SdkType;
import com.microsoft.identity.common.java.result.AcquireTokenResult;
import com.microsoft.identity.common.java.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.java.result.LocalAuthenticationResult;
import com.microsoft.identity.common.java.telemetry.events.BaseEvent;
import com.microsoft.identity.common.java.util.StringUtil;
import com.microsoft.identity.common.java.util.ThreadUtils;
import com.microsoft.identity.common.nativeauth.internal.controllers.BaseNativeAuthController;
import com.microsoft.identity.common.nativeauth.internal.util.CommandUtil;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00d6\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 |2\u00020\u0001:\u0001|B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u001e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J.\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0016H\u0007J\u0018\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u001aH\u0007J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020!H\u0002J \u0010\"\u001a\u00020#2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020)H\u0002J \u0010*\u001a\u00020+2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u0010,\u001a\u00020-2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020.H\u0002J \u0010/\u001a\u0002002\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\tH\u0002J\u0018\u00101\u001a\u0002022\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u000203H\u0007J\u0018\u00104\u001a\u0002052\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u000206H\u0002J\u0018\u00107\u001a\u0002052\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u000208H\u0002J\u0018\u00109\u001a\u0002052\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020:H\u0007J*\u0010;\u001a\u00020<2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010=\u001a\u0004\u0018\u00010.2\u0006\u0010>\u001a\u00020+2\u0006\u0010?\u001a\u00020@H\u0002J.\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020-2\n\b\u0002\u0010=\u001a\u0004\u0018\u00010.2\u0006\u0010\u0015\u001a\u00020\u000e2\b\b\u0002\u0010?\u001a\u00020@H\u0007Jp\u0010C\u001a\u00020D2\u0006\u0010\u0005\u001a\u00020E2\u0006\u0010F\u001a\u00020\u00042\u0012\u0010G\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030H2:\u0010\r\u001a6\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030I2\u0006\u0010J\u001a\u00020KH\u0002J(\u0010L\u001a\u00020M2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010N\u001a\u00020OH\u0002J\u000e\u0010P\u001a\u00020Q2\u0006\u0010\u0005\u001a\u00020RJ\u000e\u0010S\u001a\u00020T2\u0006\u0010\u0005\u001a\u00020&J\u000e\u0010U\u001a\u00020V2\u0006\u0010\u0005\u001a\u00020!J\u000e\u0010W\u001a\u00020M2\u0006\u0010\u0005\u001a\u00020)J \u0010X\u001a\u00020Y2\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020Z2\u0006\u0010[\u001a\u00020\\H\u0002J&\u0010]\u001a\u00020D2\u0006\u0010F\u001a\u00020\u00042\u0006\u0010=\u001a\u00020E2\f\u0010^\u001a\b\u0012\u0004\u0012\u00020K0\bH\u0002J\u000e\u0010_\u001a\u00020`2\u0006\u0010\u0005\u001a\u00020aJ\u000e\u0010b\u001a\u00020<2\u0006\u0010\u0005\u001a\u00020.J\u000e\u0010c\u001a\u00020d2\u0006\u0010\u0005\u001a\u00020\u0018J\u000e\u0010e\u001a\u00020f2\u0006\u0010\u0005\u001a\u00020\u001aJ\u000e\u0010g\u001a\u00020h2\u0006\u0010\u0005\u001a\u00020\u0016J\u000e\u0010i\u001a\u00020j2\u0006\u0010\u0005\u001a\u00020kJ\u000e\u0010l\u001a\u00020m2\u0006\u0010\u0005\u001a\u000203J\u000e\u0010n\u001a\u00020o2\u0006\u0010\u0005\u001a\u000206J\u000e\u0010p\u001a\u00020q2\u0006\u0010\u0005\u001a\u000208J\u000e\u0010r\u001a\u00020s2\u0006\u0010\u0005\u001a\u00020:J\f\u0010t\u001a\u00020T*\u00020\u001cH\u0002J\u001c\u0010u\u001a\u00020<*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020.H\u0002J\u001c\u0010v\u001a\u00020f*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000e2\u0006\u0010=\u001a\u00020\u001aH\u0002J\f\u0010w\u001a\u00020m*\u000200H\u0002J\u0014\u0010x\u001a\u00020o*\u0002052\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0014\u0010y\u001a\u00020q*\u0002052\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\u0014\u0010z\u001a\u00020s*\u0002052\u0006\u0010\u0015\u001a\u00020\u000eH\u0002J\f\u0010{\u001a\u00020s*\u000200H\u0002\u00a8\u0006}"}, d2={"Lcom/microsoft/identity/common/nativeauth/internal/controllers/NativeAuthMsalController;", "Lcom/microsoft/identity/common/nativeauth/internal/controllers/BaseNativeAuthController;", "()V", "acquireTokenSilent", "Lcom/microsoft/identity/common/java/result/AcquireTokenResult;", "parameters", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/AcquireTokenNoFixedScopesCommandParameters;", "addDefaultScopes", "", "", "scopes", "createAuthorizationRequest", "Lcom/microsoft/identity/common/java/providers/microsoft/microsoftsts/MicrosoftStsAuthorizationRequest;", "strategy", "Lcom/microsoft/identity/common/java/nativeauth/providers/NativeAuthOAuth2Strategy;", "clientId", "applicationIdentifier", "createOAuth2Strategy", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/BaseNativeAuthCommandParameters;", "performContinuationTokenTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult;", "oAuth2Strategy", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInWithContinuationTokenCommandParameters;", "performOOBTokenRequest", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitCodeCommandParameters;", "performPasswordTokenCall", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInSubmitPasswordCommandParameters;", "performResetPasswordChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordChallengeApiResult;", "continuationToken", "correlationId", "performResetPasswordContinueCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordContinueApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitCodeCommandParameters;", "performResetPasswordPollCompletionCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordPollCompletionApiResult;", "performResetPasswordStartCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordStartApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordStartCommandParameters;", "performResetPasswordSubmitCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/resetpassword/ResetPasswordSubmitApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordSubmitNewPasswordCommandParameters;", "performSignInChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInChallengeApiResult;", "performSignInInitiateCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInInitiateApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInStartCommandParameters;", "performSignUpChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpChallengeApiResult;", "performSignUpStartUsingPasswordRequest", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpStartApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpStartCommandParameters;", "performSignUpSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signup/SignUpContinueApiResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitCodeCommandParameters;", "performSignUpSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitPasswordCommandParameters;", "performSignUpSubmitUserAttributes", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpSubmitUserAttributesCommandParameters;", "processSignInChallengeCall", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInStartCommandResult;", "parametersWithScopes", "result", "usePassword", "", "processSignInInitiateApiResult", "initiateApiResult", "renewAT", "", "Lcom/microsoft/identity/common/java/commands/parameters/SilentTokenCommandParameters;", "acquireTokenSilentResult", "tokenCache", "Lcom/microsoft/identity/common/java/providers/oauth2/OAuth2TokenCache;", "Lcom/microsoft/identity/common/java/providers/oauth2/OAuth2Strategy;", "cacheRecord", "Lcom/microsoft/identity/common/java/cache/ICacheRecord;", "resetPasswordPollCompletion", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordSubmitNewPasswordCommandResult;", "pollIntervalInSeconds", "", "resetPasswordResendCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordResendCodeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/ResetPasswordResendCodeCommandParameters;", "resetPasswordStart", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordStartCommandResult;", "resetPasswordSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/ResetPasswordSubmitCodeCommandResult;", "resetPasswordSubmitNewPassword", "saveAndReturnTokens", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInCommandResult$Complete;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/BaseSignInTokenCommandParameters;", "tokenApiResult", "Lcom/microsoft/identity/common/java/nativeauth/providers/responses/signin/SignInTokenApiResult$Success;", "setAcquireTokenResult", "cacheRecords", "signInResendCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInResendCodeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignInResendCodeCommandParameters;", "signInStart", "signInSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInSubmitCodeCommandResult;", "signInSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInSubmitPasswordCommandResult;", "signInWithContinuationToken", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignInWithContinuationTokenCommandResult;", "signUpResendCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpResendCodeCommandResult;", "Lcom/microsoft/identity/common/java/nativeauth/commands/parameters/SignUpResendCodeCommandParameters;", "signUpStart", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpStartCommandResult;", "signUpSubmitCode", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpSubmitCodeCommandResult;", "signUpSubmitPassword", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpSubmitPasswordCommandResult;", "signUpSubmitUserAttributes", "Lcom/microsoft/identity/common/java/nativeauth/controllers/results/SignUpSubmitUserAttributesCommandResult;", "toResetPasswordStartCommandResult", "toSignInStartCommandResult", "toSignInSubmitPasswordCommandResult", "toSignUpStartCommandResult", "toSignUpSubmitCodeCommandResult", "toSignUpSubmitPasswordCommandResult", "toSignUpSubmitUserAttributesCommandResult", "toSignUpSubmitUserAttrsCommandResult", "Companion", "common_distRelease"})
public final class NativeAuthMsalController
extends BaseNativeAuthController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final String TAG = NativeAuthMsalController.class.getSimpleName();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignInStartCommandResult signInStart(@NotNull SignInStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signInStart");
        try {
            boolean hasPassword;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignInInitiateApiResult initiateApiResult = this.performSignInInitiateCall(oAuth2Strategy, parameters);
            boolean bl = parameters.password != null ? !(parameters.password.length == 0) : (hasPassword = false);
            if (hasPassword) {
                Logger.verbose((String)TAG, (String)parameters.getCorrelationId(), (String)"Parameters has password");
                List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
                SignInStartCommandParameters parametersWithScopes = CommandUtil.createSignInStartCommandParametersWithScopes(parameters, mergedScopes);
                try {
                    SignInStartCommandResult signInStartCommandResult = this.processSignInInitiateApiResult(initiateApiResult, parametersWithScopes, oAuth2Strategy, true);
                    return signInStartCommandResult;
                }
                finally {
                    StringUtil.overwriteWithNull((char[])parametersWithScopes.password);
                }
            }
            Logger.verbose((String)TAG, (String)parameters.getCorrelationId(), (String)"Parameters doesn't have password");
            return NativeAuthMsalController.processSignInInitiateApiResult$default(this, initiateApiResult, null, oAuth2Strategy, false, 10, null);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInStart", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignInWithContinuationTokenCommandResult signInWithContinuationToken(@NotNull SignInWithContinuationTokenCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signInWithContinuationToken");
        try {
            SignInTokenApiResult tokenApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
            SignInWithContinuationTokenCommandParameters parametersWithScopes = CommandUtil.createSignInWithContinuationTokenCommandParametersWithScopes(parameters, mergedScopes);
            Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
            SignInTokenApiResult signInTokenApiResult = tokenApiResult = this.performContinuationTokenTokenRequest(oAuth2Strategy, parametersWithScopes);
            if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
                return (SignInWithContinuationTokenCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)tokenApiResult);
            }
            if (((((signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType ? true : signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) ? true : signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)tokenApiResult.getCorrelationId(), (String)("Unexpected result: " + tokenApiResult));
                Intrinsics.checkNotNull((Object)tokenApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)tokenApiResult;
                String string2 = ((ApiErrorResult)tokenApiResult).getError();
                String string3 = "API returned unexpected result: " + tokenApiResult;
                List list = ((ApiErrorResult)tokenApiResult).getErrorCodes();
                String string4 = tokenApiResult.getCorrelationId();
                return (SignInWithContinuationTokenCommandResult)new INativeAuthCommandResult.UnknownError(string2, string3, null, string4, list, null, 36, null);
            }
            throw new NoWhenBranchMatchedException();
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInWithContinuationToken", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignInSubmitCodeCommandResult signInSubmitCode(@NotNull SignInSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signInSubmitCode");
        try {
            SignInSubmitCodeCommandResult signInSubmitCodeCommandResult;
            SignInTokenApiResult tokenApiResult;
            List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
            SignInSubmitCodeCommandParameters parametersWithScopes = CommandUtil.createSignInSubmitCodeCommandParametersWithScopes(parameters, mergedScopes);
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
            SignInTokenApiResult signInTokenApiResult = tokenApiResult = this.performOOBTokenRequest(oAuth2Strategy, parametersWithScopes);
            if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
                signInSubmitCodeCommandResult = (SignInSubmitCodeCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)tokenApiResult);
            } else if (signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect) {
                String string2 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getError();
                String string3 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getErrorDescription();
                List list = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getErrorCodes();
                String string4 = ((SignInTokenApiResult.CodeIncorrect)tokenApiResult).getSubError();
                String string5 = tokenApiResult.getCorrelationId();
                signInSubmitCodeCommandResult = (SignInSubmitCodeCommandResult)new SignInCommandResult.IncorrectCode(string2, string3, string5, list, string4);
            } else if ((((signInTokenApiResult instanceof SignInTokenApiResult.UnknownError ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType) ? true : signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound) {
                Logger.warn((String)TAG, (String)tokenApiResult.getCorrelationId(), (String)("Unexpected result: " + tokenApiResult));
                Intrinsics.checkNotNull((Object)tokenApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)tokenApiResult;
                String string6 = ((ApiErrorResult)tokenApiResult).getError();
                String string7 = ((ApiErrorResult)tokenApiResult).getErrorDescription();
                List list = ((ApiErrorResult)tokenApiResult).getErrorCodes();
                String string8 = tokenApiResult.getCorrelationId();
                signInSubmitCodeCommandResult = (SignInSubmitCodeCommandResult)new INativeAuthCommandResult.UnknownError(string6, string7, null, string8, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return signInSubmitCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInSubmitCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignInResendCodeCommandResult signInResendCode(@NotNull SignInResendCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signInResendCode");
        try {
            SignInResendCodeCommandResult signInResendCodeCommandResult;
            SignInChallengeApiResult result;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            String string2 = parameters.continuationToken;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameters.continuationToken");
            String string3 = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.correlationId");
            SignInChallengeApiResult signInChallengeApiResult = result = this.performSignInChallengeCall(oAuth2Strategy, string2, string3);
            if (signInChallengeApiResult instanceof SignInChallengeApiResult.OOBRequired) {
                String string4 = ((SignInChallengeApiResult.OOBRequired)result).getContinuationToken();
                int n = ((SignInChallengeApiResult.OOBRequired)result).getCodeLength();
                String string5 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeTargetLabel();
                String string6 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeChannel();
                String string7 = result.getCorrelationId();
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new SignInCommandResult.CodeRequired(string4, string7, string5, string6, n);
            } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.PasswordRequired) {
                Logger.warn((String)TAG, (String)result.getCorrelationId(), (String)("Unexpected result: " + result));
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new INativeAuthCommandResult.UnknownError("unexpected_api_result", "API returned unexpected result: " + result, null, result.getCorrelationId(), null, null, 52, null);
            } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.Redirect) {
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId());
            } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)("Unexpected result: " + result));
                String string8 = ((SignInChallengeApiResult.UnknownError)result).getError();
                String string9 = ((SignInChallengeApiResult.UnknownError)result).getErrorDescription();
                List list = ((SignInChallengeApiResult.UnknownError)result).getErrorCodes();
                String string10 = result.getCorrelationId();
                signInResendCodeCommandResult = (SignInResendCodeCommandResult)new INativeAuthCommandResult.UnknownError(string8, string9, null, string10, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return signInResendCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInResendCode", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final SignInSubmitPasswordCommandResult signInSubmitPassword(@NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signInSubmitPassword");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            List<String> mergedScopes = this.addDefaultScopes(parameters.scopes);
            SignInSubmitPasswordCommandParameters parametersWithScopes = CommandUtil.createSignInSubmitPasswordCommandParametersWithScopes(parameters, parameters.getCorrelationId(), mergedScopes);
            try {
                Intrinsics.checkNotNullExpressionValue((Object)parametersWithScopes, (String)"parametersWithScopes");
                SignInSubmitPasswordCommandResult signInSubmitPasswordCommandResult = this.toSignInSubmitPasswordCommandResult(this.performPasswordTokenCall(oAuth2Strategy, parametersWithScopes), oAuth2Strategy, parametersWithScopes);
                return signInSubmitPasswordCommandResult;
            }
            finally {
                StringUtil.overwriteWithNull((char[])parametersWithScopes.password);
            }
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signInSubmitPassword", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpStartCommandResult signUpStart(@NotNull SignUpStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signUpStart");
        try {
            SignUpStartCommandResult signUpStartCommandResult;
            SignUpStartApiResult signUpStartApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignUpStartApiResult signUpStartApiResult2 = signUpStartApiResult = this.performSignUpStartUsingPasswordRequest(oAuth2Strategy, parameters);
            if (signUpStartApiResult2 instanceof SignUpStartApiResult.Success) {
                signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpStartApiResult.Success)signUpStartApiResult).getContinuationToken(), signUpStartApiResult.getCorrelationId()));
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.InvalidPassword) {
                String string2 = ((SignUpStartApiResult.InvalidPassword)signUpStartApiResult).getError();
                String string3 = ((SignUpStartApiResult.InvalidPassword)signUpStartApiResult).getErrorDescription();
                String string4 = ((SignUpStartApiResult.InvalidPassword)signUpStartApiResult).getSubError();
                String string5 = signUpStartApiResult.getCorrelationId();
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.InvalidPassword(string2, string3, string5, string4);
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.InvalidAttributes) {
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.InvalidAttributes(((SignUpStartApiResult.InvalidAttributes)signUpStartApiResult).getError(), ((SignUpStartApiResult.InvalidAttributes)signUpStartApiResult).getErrorDescription(), ((SignUpStartApiResult.InvalidAttributes)signUpStartApiResult).getInvalidAttributes(), signUpStartApiResult.getCorrelationId());
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.UsernameAlreadyExists) {
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.UsernameAlreadyExists(((SignUpStartApiResult.UsernameAlreadyExists)signUpStartApiResult).getError(), ((SignUpStartApiResult.UsernameAlreadyExists)signUpStartApiResult).getErrorDescription(), signUpStartApiResult.getCorrelationId());
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.InvalidUsername) {
                signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.InvalidUsername(((SignUpStartApiResult.InvalidUsername)signUpStartApiResult).getError(), ((SignUpStartApiResult.InvalidUsername)signUpStartApiResult).getErrorDescription(), null, signUpStartApiResult.getCorrelationId(), null, null, 52, null);
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.AuthNotSupported) {
                signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.AuthNotSupported(((SignUpStartApiResult.AuthNotSupported)signUpStartApiResult).getError(), ((SignUpStartApiResult.AuthNotSupported)signUpStartApiResult).getErrorDescription(), signUpStartApiResult.getCorrelationId());
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.Redirect) {
                signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.Redirect(signUpStartApiResult.getCorrelationId());
            } else if (signUpStartApiResult2 instanceof SignUpStartApiResult.UnsupportedChallengeType ? true : signUpStartApiResult2 instanceof SignUpStartApiResult.UnknownError) {
                Intrinsics.checkNotNull((Object)signUpStartApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)signUpStartApiResult;
                Logger.warn((String)TAG, (String)signUpStartApiResult.getCorrelationId(), (String)("Unexpected result: " + signUpStartApiResult));
                signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)signUpStartApiResult).getError(), ((ApiErrorResult)signUpStartApiResult).getErrorDescription(), null, signUpStartApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return signUpStartCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpStart", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpSubmitCodeCommandResult signUpSubmitCode(@NotNull SignUpSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signUpSubmitCode");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignUpContinueApiResult signUpSubmitCodeResult = this.performSignUpSubmitCode(oAuth2Strategy, parameters);
            return this.toSignUpSubmitCodeCommandResult(signUpSubmitCodeResult, oAuth2Strategy);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpSubmitCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpResendCodeCommandResult signUpResendCode(@NotNull SignUpResendCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signUpResendCode");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            String string2 = parameters.continuationToken;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameters.continuationToken");
            String string3 = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.correlationId");
            SignUpStartCommandResult signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, string2, string3));
            Intrinsics.checkNotNull((Object)signUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpResendCodeCommandResult");
            return (SignUpResendCodeCommandResult)signUpStartCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpResendCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpSubmitUserAttributesCommandResult signUpSubmitUserAttributes(@NotNull SignUpSubmitUserAttributesCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signUpSubmitUserAttributes");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            SignUpContinueApiResult signUpContinueApiResult = this.performSignUpSubmitUserAttributes(oAuth2Strategy, parameters);
            return this.toSignUpSubmitUserAttributesCommandResult(signUpContinueApiResult, oAuth2Strategy);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpSubmitUserAttributes", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final SignUpSubmitPasswordCommandResult signUpSubmitPassword(@NotNull SignUpSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".signUpSubmitPassword");
        try {
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            return this.toSignUpSubmitPasswordCommandResult(this.performSignUpSubmitPassword(oAuth2Strategy, parameters), oAuth2Strategy);
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in signUpSubmitPassword", (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final AcquireTokenResult acquireTokenSilent(@NotNull AcquireTokenNoFixedScopesCommandParameters parameters) throws IOException, ClientException, ArgumentException, ServiceException {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".acquireTokenSilent");
        AcquireTokenResult acquireTokenSilentResult = new AcquireTokenResult();
        parameters.validate();
        SilentTokenCommandParameters silentTokenCommandParameters = CommandUtil.convertAcquireTokenNoFixedScopesCommandParameters(parameters, parameters.getCorrelationId());
        AccountRecord accountRecord = this.getCachedAccountRecord(silentTokenCommandParameters);
        Intrinsics.checkNotNullExpressionValue((Object)accountRecord, (String)"getCachedAccountRecord(s\u2026ntTokenCommandParameters)");
        AccountRecord targetAccount = accountRecord;
        AbstractAuthenticationScheme authScheme = silentTokenCommandParameters.getAuthenticationScheme();
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).authenticationScheme(authScheme).build();
        OAuth2Strategy strategy = silentTokenCommandParameters.getAuthority().createOAuth2Strategy(strategyParameters);
        OAuth2TokenCache tokenCache = silentTokenCommandParameters.getOAuth2TokenCache();
        List list = tokenCache.loadWithAggregatedAccountData(silentTokenCommandParameters.getClientId(), parameters.getApplicationIdentifier(), null, null, targetAccount, authScheme);
        Intrinsics.checkNotNull((Object)list, (String)"null cannot be cast to non-null type kotlin.collections.List<com.microsoft.identity.common.java.cache.ICacheRecord>");
        List cacheRecords = list;
        ICacheRecord fullCacheRecord = (ICacheRecord)cacheRecords.get(0);
        if (this.accessTokenIsNull(fullCacheRecord)) {
            throw new ServiceException("native_auth_no_access_token_found", "No access token found during refresh - user must be signed out.", null);
        }
        if (LibraryConfiguration.getInstance().isRefreshInEnabled() && fullCacheRecord.getAccessToken() != null && fullCacheRecord.getAccessToken().refreshOnIsActive()) {
            Logger.info((String)TAG, (String)parameters.getCorrelationId(), (String)"RefreshOn is active. This will extend your token usage in the rare case servers are not available.");
        }
        if (LibraryConfiguration.getInstance().isRefreshInEnabled() && fullCacheRecord.getAccessToken() != null && fullCacheRecord.getAccessToken().shouldRefresh()) {
            if (!fullCacheRecord.getAccessToken().isExpired()) {
                Intrinsics.checkNotNullExpressionValue((Object)silentTokenCommandParameters, (String)"silentTokenCommandParameters");
                this.setAcquireTokenResult(acquireTokenSilentResult, silentTokenCommandParameters, cacheRecords);
                RefreshOnCommand refreshOnCommand = new RefreshOnCommand((CommandParameters)parameters, this.asControllerFactory(), "1201");
                CommandDispatcher.submitAndForget((BaseCommand)refreshOnCommand);
            } else {
                Logger.warn((String)TAG, (String)parameters.getCorrelationId(), (String)"Access token is expired. Removing from cache...");
                Intrinsics.checkNotNullExpressionValue((Object)silentTokenCommandParameters, (String)"silentTokenCommandParameters");
                Intrinsics.checkNotNullExpressionValue((Object)tokenCache, (String)"tokenCache");
                Intrinsics.checkNotNullExpressionValue((Object)strategy, (String)"strategy");
                this.renewAT(silentTokenCommandParameters, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
            }
        } else if (this.accessTokenIsNull(fullCacheRecord) || this.refreshTokenIsNull(fullCacheRecord) || silentTokenCommandParameters.isForceRefresh() || !this.isRequestAuthorityRealmSameAsATRealm(silentTokenCommandParameters.getAuthority(), fullCacheRecord.getAccessToken()) || !strategy.validateCachedResult(authScheme, fullCacheRecord)) {
            if (this.refreshTokenIsNull(fullCacheRecord)) {
                ServiceException exception = new ServiceException("no_tokens_found", "No refresh token was found.", null);
                Telemetry.emit((BaseEvent)((BaseEvent)new ApiEndEvent().putException((Exception)exception).putApiId("103")));
                throw exception;
            }
            Intrinsics.checkNotNullExpressionValue((Object)silentTokenCommandParameters, (String)"silentTokenCommandParameters");
            Intrinsics.checkNotNullExpressionValue((Object)tokenCache, (String)"tokenCache");
            Intrinsics.checkNotNullExpressionValue((Object)strategy, (String)"strategy");
            this.renewAT(silentTokenCommandParameters, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else if (fullCacheRecord.getAccessToken().isExpired()) {
            Logger.warn((String)TAG, (String)parameters.getCorrelationId(), (String)"Access token is expired. Removing from cache...");
            Intrinsics.checkNotNullExpressionValue((Object)silentTokenCommandParameters, (String)"silentTokenCommandParameters");
            Intrinsics.checkNotNullExpressionValue((Object)tokenCache, (String)"tokenCache");
            Intrinsics.checkNotNullExpressionValue((Object)strategy, (String)"strategy");
            this.renewAT(silentTokenCommandParameters, acquireTokenSilentResult, tokenCache, strategy, fullCacheRecord);
        } else {
            Logger.verbose((String)TAG, (String)parameters.getCorrelationId(), (String)"Returning silent result");
            Intrinsics.checkNotNullExpressionValue((Object)silentTokenCommandParameters, (String)"silentTokenCommandParameters");
            this.setAcquireTokenResult(acquireTokenSilentResult, silentTokenCommandParameters, cacheRecords);
        }
        Telemetry.emit((BaseEvent)((BaseEvent)new ApiEndEvent().putResult(acquireTokenSilentResult).putApiId("103")));
        return acquireTokenSilentResult;
    }

    private final void setAcquireTokenResult(AcquireTokenResult acquireTokenSilentResult, SilentTokenCommandParameters parametersWithScopes, List<? extends ICacheRecord> cacheRecords) throws ClientException {
        ICacheRecord fullCacheRecord = cacheRecords.get(0);
        acquireTokenSilentResult.setLocalAuthenticationResult((ILocalAuthenticationResult)new LocalAuthenticationResult(this.finalizeCacheRecordForResult(fullCacheRecord, parametersWithScopes.getAuthenticationScheme()), cacheRecords, SdkType.MSAL, true));
    }

    @NotNull
    public final ResetPasswordStartCommandResult resetPasswordStart(@NotNull ResetPasswordStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".resetPasswordStart");
        try {
            ResetPasswordStartCommandResult resetPasswordStartCommandResult;
            ResetPasswordStartApiResult resetPasswordStartApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            ResetPasswordStartApiResult resetPasswordStartApiResult2 = resetPasswordStartApiResult = this.performResetPasswordStartCall(oAuth2Strategy, parameters);
            if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.Success) {
                resetPasswordStartCommandResult = this.toResetPasswordStartCommandResult(this.performResetPasswordChallengeCall(oAuth2Strategy, ((ResetPasswordStartApiResult.Success)resetPasswordStartApiResult).getContinuationToken(), resetPasswordStartApiResult.getCorrelationId()));
            } else if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.Redirect) {
                resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.Redirect(resetPasswordStartApiResult.getCorrelationId());
            } else if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.UserNotFound) {
                resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new ResetPasswordCommandResult.UserNotFound(((ResetPasswordStartApiResult.UserNotFound)resetPasswordStartApiResult).getError(), ((ResetPasswordStartApiResult.UserNotFound)resetPasswordStartApiResult).getErrorDescription(), resetPasswordStartApiResult.getCorrelationId());
            } else if (resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.UnsupportedChallengeType ? true : resetPasswordStartApiResult2 instanceof ResetPasswordStartApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)parameters.getCorrelationId(), (String)("Unexpected result: " + resetPasswordStartApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordStartApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordStartApiResult;
                resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)resetPasswordStartApiResult).getError(), ((ApiErrorResult)resetPasswordStartApiResult).getErrorDescription(), null, resetPasswordStartApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordStartCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordStart", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final ResetPasswordSubmitCodeCommandResult resetPasswordSubmitCode(@NotNull ResetPasswordSubmitCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".resetPasswordSubmitCode");
        try {
            ResetPasswordSubmitCodeCommandResult resetPasswordSubmitCodeCommandResult;
            ResetPasswordContinueApiResult resetPasswordContinueApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            ResetPasswordContinueApiResult resetPasswordContinueApiResult2 = resetPasswordContinueApiResult = this.performResetPasswordContinueCall(oAuth2Strategy, parameters);
            if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.PasswordRequired) {
                String string2 = ((ResetPasswordContinueApiResult.PasswordRequired)resetPasswordContinueApiResult).getContinuationToken();
                String string3 = resetPasswordContinueApiResult.getCorrelationId();
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new ResetPasswordCommandResult.PasswordRequired(string3, string2);
            } else if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.CodeIncorrect) {
                String string4 = ((ResetPasswordContinueApiResult.CodeIncorrect)resetPasswordContinueApiResult).getError();
                String string5 = ((ResetPasswordContinueApiResult.CodeIncorrect)resetPasswordContinueApiResult).getErrorDescription();
                String string6 = ((ResetPasswordContinueApiResult.CodeIncorrect)resetPasswordContinueApiResult).getSubError();
                String string7 = resetPasswordContinueApiResult.getCorrelationId();
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new ResetPasswordCommandResult.IncorrectCode(string4, string5, string7, string6);
            } else if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.Redirect) {
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new INativeAuthCommandResult.Redirect(resetPasswordContinueApiResult.getCorrelationId());
            } else if (resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.ExpiredToken ? true : resetPasswordContinueApiResult2 instanceof ResetPasswordContinueApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)("Unexpected result: " + resetPasswordContinueApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordContinueApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordContinueApiResult;
                resetPasswordSubmitCodeCommandResult = (ResetPasswordSubmitCodeCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)resetPasswordContinueApiResult).getError(), ((ApiErrorResult)resetPasswordContinueApiResult).getErrorDescription(), null, resetPasswordContinueApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordSubmitCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordSubmitCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final ResetPasswordResendCodeCommandResult resetPasswordResendCode(@NotNull ResetPasswordResendCodeCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".resetPasswordResendCode");
        try {
            ResetPasswordResendCodeCommandResult resetPasswordResendCodeCommandResult;
            ResetPasswordChallengeApiResult resetPasswordChallengeApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            String string2 = parameters.continuationToken;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parameters.continuationToken");
            String string3 = parameters.getCorrelationId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parameters.correlationId");
            ResetPasswordChallengeApiResult resetPasswordChallengeApiResult2 = resetPasswordChallengeApiResult = this.performResetPasswordChallengeCall(oAuth2Strategy, string2, string3);
            if (resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.CodeRequired) {
                String string4 = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getContinuationToken();
                int n = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getCodeLength();
                String string5 = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getChallengeTargetLabel();
                String string6 = ((ResetPasswordChallengeApiResult.CodeRequired)resetPasswordChallengeApiResult).getChallengeChannel();
                String string7 = resetPasswordChallengeApiResult.getCorrelationId();
                resetPasswordResendCodeCommandResult = (ResetPasswordResendCodeCommandResult)new ResetPasswordCommandResult.CodeRequired(string7, string4, n, string5, string6);
            } else if (resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.Redirect) {
                resetPasswordResendCodeCommandResult = (ResetPasswordResendCodeCommandResult)new INativeAuthCommandResult.Redirect(resetPasswordChallengeApiResult.getCorrelationId());
            } else if ((resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.ExpiredToken ? true : resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.UnsupportedChallengeType) ? true : resetPasswordChallengeApiResult2 instanceof ResetPasswordChallengeApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)resetPasswordChallengeApiResult.getCorrelationId(), (String)("Unexpected result: " + resetPasswordChallengeApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordChallengeApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordChallengeApiResult;
                resetPasswordResendCodeCommandResult = (ResetPasswordResendCodeCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)resetPasswordChallengeApiResult).getError(), ((ApiErrorResult)resetPasswordChallengeApiResult).getErrorDescription(), null, resetPasswordChallengeApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordResendCodeCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordResendCode", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    public final ResetPasswordSubmitNewPasswordCommandResult resetPasswordSubmitNewPassword(@NotNull ResetPasswordSubmitNewPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".resetPasswordSubmitNewPassword");
        try {
            ResetPasswordSubmitNewPasswordCommandResult resetPasswordSubmitNewPasswordCommandResult;
            ResetPasswordSubmitApiResult resetPasswordSubmitApiResult;
            NativeAuthOAuth2Strategy oAuth2Strategy = this.createOAuth2Strategy((BaseNativeAuthCommandParameters)parameters);
            ResetPasswordSubmitApiResult resetPasswordSubmitApiResult2 = resetPasswordSubmitApiResult = this.performResetPasswordSubmitCall(oAuth2Strategy, parameters);
            if (resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.SubmitSuccess) {
                String string2 = ((ResetPasswordSubmitApiResult.SubmitSuccess)resetPasswordSubmitApiResult).getContinuationToken();
                int n = ((ResetPasswordSubmitApiResult.SubmitSuccess)resetPasswordSubmitApiResult).getPollInterval();
                String string3 = resetPasswordSubmitApiResult.getCorrelationId();
                resetPasswordSubmitNewPasswordCommandResult = this.resetPasswordPollCompletion(oAuth2Strategy, string2, string3, n);
            } else if (resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.PasswordInvalid) {
                String string4 = ((ResetPasswordSubmitApiResult.PasswordInvalid)resetPasswordSubmitApiResult).getError();
                String string5 = ((ResetPasswordSubmitApiResult.PasswordInvalid)resetPasswordSubmitApiResult).getErrorDescription();
                String string6 = ((ResetPasswordSubmitApiResult.PasswordInvalid)resetPasswordSubmitApiResult).getSubError();
                String string7 = resetPasswordSubmitApiResult.getCorrelationId();
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.PasswordNotAccepted(string4, string5, string7, string6);
            } else if (resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.ExpiredToken ? true : resetPasswordSubmitApiResult2 instanceof ResetPasswordSubmitApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)resetPasswordSubmitApiResult.getCorrelationId(), (String)("Unexpected result: " + resetPasswordSubmitApiResult));
                Intrinsics.checkNotNull((Object)resetPasswordSubmitApiResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordSubmitApiResult;
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)resetPasswordSubmitApiResult).getError(), ((ApiErrorResult)resetPasswordSubmitApiResult).getErrorDescription(), null, resetPasswordSubmitApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordSubmitNewPasswordCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)parameters.getCorrelationId(), (String)"Exception thrown in resetPasswordSubmitNewPassword", (Throwable)e);
            throw e;
        }
    }

    private final ResetPasswordSubmitNewPasswordCommandResult resetPasswordPollCompletion(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId, int pollIntervalInSeconds) {
        String methodTag = TAG + ":resetPasswordPollCompletion";
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, TAG + ".resetPasswordPollCompletion");
        try {
            ResetPasswordSubmitNewPasswordCommandResult resetPasswordSubmitNewPasswordCommandResult;
            int pollWaitInterval = pollIntervalInSeconds * 1000;
            ResetPasswordPollCompletionApiResult pollCompletionApiResult = this.performResetPasswordPollCompletionCall(oAuth2Strategy, continuationToken, correlationId);
            long startTime = System.currentTimeMillis();
            while (pollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.InProgress) {
                ThreadUtils.sleepSafely((int)pollWaitInterval, (String)methodTag, (String)"Waiting between reset password polls");
                if (NativeAuthMsalController.resetPasswordPollCompletion$pollCompletionTimedOut(startTime)) {
                    Logger.warn((String)TAG, (String)pollCompletionApiResult.getCorrelationId(), (String)"Reset password completion timed out.");
                    return (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.PasswordResetFailed("timeout", "Command timed out while polling for password reset result.", pollCompletionApiResult.getCorrelationId());
                }
                pollCompletionApiResult = this.performResetPasswordPollCompletionCall(oAuth2Strategy, continuationToken, correlationId);
            }
            ResetPasswordPollCompletionApiResult resetPasswordPollCompletionApiResult = pollCompletionApiResult;
            if (resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.PollingFailed) {
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.PasswordResetFailed(((ResetPasswordPollCompletionApiResult.PollingFailed)pollCompletionApiResult).getError(), ((ResetPasswordPollCompletionApiResult.PollingFailed)pollCompletionApiResult).getErrorDescription(), pollCompletionApiResult.getCorrelationId());
            } else if (resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.PollingSucceeded) {
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new ResetPasswordCommandResult.Complete(((ResetPasswordPollCompletionApiResult.PollingSucceeded)pollCompletionApiResult).getContinuationToken(), ((ResetPasswordPollCompletionApiResult.PollingSucceeded)pollCompletionApiResult).getExpiresIn(), pollCompletionApiResult.getCorrelationId());
            } else if (resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.InProgress) {
                Logger.warn((String)TAG, (String)pollCompletionApiResult.getCorrelationId(), (String)"in_progress received after polling, illegal state");
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.UnknownError("illegal_state", "in_progress received after polling concluded, illegal state", null, pollCompletionApiResult.getCorrelationId(), null, null, 52, null);
            } else if (((resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.ExpiredToken ? true : resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.UserNotFound) ? true : resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.PasswordInvalid) ? true : resetPasswordPollCompletionApiResult instanceof ResetPasswordPollCompletionApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)pollCompletionApiResult.getCorrelationId(), (String)("Unexpected result: " + pollCompletionApiResult));
                ResetPasswordPollCompletionApiResult resetPasswordPollCompletionApiResult2 = pollCompletionApiResult;
                Intrinsics.checkNotNull((Object)resetPasswordPollCompletionApiResult2, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)resetPasswordPollCompletionApiResult2;
                resetPasswordSubmitNewPasswordCommandResult = (ResetPasswordSubmitNewPasswordCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)pollCompletionApiResult).getError(), ((ApiErrorResult)pollCompletionApiResult).getErrorDescription(), null, pollCompletionApiResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return resetPasswordSubmitNewPasswordCommandResult;
        }
        catch (Exception e) {
            Logger.error((String)TAG, (String)correlationId, (String)"Exception thrown in resetPasswordPollCompletion", (Throwable)e);
            throw e;
        }
    }

    @VisibleForTesting
    @NotNull
    public final SignInTokenApiResult performContinuationTokenTokenRequest(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignInWithContinuationTokenCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".performContinuationTokenTokenRequest");
        return oAuth2Strategy.performContinuationTokenTokenRequest(parameters);
    }

    private final SignInTokenApiResult performOOBTokenRequest(NativeAuthOAuth2Strategy oAuth2Strategy, SignInSubmitCodeCommandParameters parameters) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".performOOBTokenRequest");
        return oAuth2Strategy.performOOBTokenRequest(parameters);
    }

    @VisibleForTesting
    @NotNull
    public final SignInTokenApiResult performPasswordTokenCall(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignInSubmitPasswordCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".performPasswordTokenCall");
        return oAuth2Strategy.performPasswordTokenRequest(parameters);
    }

    private final SignInInitiateApiResult performSignInInitiateCall(NativeAuthOAuth2Strategy oAuth2Strategy, SignInStartCommandParameters parameters) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".performSignInInitiateCall");
        return oAuth2Strategy.performSignInInitiate(parameters);
    }

    private final SignInChallengeApiResult performSignInChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, TAG + ".performSignInChallengeCall");
        return oAuth2Strategy.performSignInChallenge(continuationToken, correlationId);
    }

    private final ResetPasswordStartApiResult performResetPasswordStartCall(NativeAuthOAuth2Strategy oAuth2Strategy, ResetPasswordStartCommandParameters parameters) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".performResetPasswordStartCall");
        return oAuth2Strategy.performResetPasswordStart(parameters);
    }

    private final ResetPasswordChallengeApiResult performResetPasswordChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, TAG + ".performResetPasswordChallengeCall");
        return oAuth2Strategy.performResetPasswordChallenge(continuationToken, correlationId);
    }

    private final ResetPasswordContinueApiResult performResetPasswordContinueCall(NativeAuthOAuth2Strategy oAuth2Strategy, ResetPasswordSubmitCodeCommandParameters parameters) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".performResetPasswordContinueCall");
        return oAuth2Strategy.performResetPasswordContinue(parameters);
    }

    private final ResetPasswordSubmitApiResult performResetPasswordSubmitCall(NativeAuthOAuth2Strategy oAuth2Strategy, ResetPasswordSubmitNewPasswordCommandParameters parameters) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parameters.getCorrelationId(), TAG + ".performResetPasswordSubmitCall");
        return oAuth2Strategy.performResetPasswordSubmit(parameters);
    }

    private final ResetPasswordPollCompletionApiResult performResetPasswordPollCompletionCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, correlationId, TAG + ".performResetPasswordPollCompletionCall");
        return oAuth2Strategy.performResetPasswordPollCompletion(continuationToken, correlationId);
    }

    private final SignInCommandResult.Complete saveAndReturnTokens(NativeAuthOAuth2Strategy oAuth2Strategy, BaseSignInTokenCommandParameters parametersWithScopes, SignInTokenApiResult.Success tokenApiResult) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, parametersWithScopes.getCorrelationId(), TAG + ".saveAndReturnTokens");
        Intrinsics.checkNotNull((Object)oAuth2Strategy, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy");
        OAuth2Strategy oAuth2Strategy2 = (OAuth2Strategy)((MicrosoftStsOAuth2Strategy)oAuth2Strategy);
        List list = parametersWithScopes.scopes;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parametersWithScopes.scopes");
        String string2 = parametersWithScopes.getClientId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parametersWithScopes.clientId");
        String string3 = parametersWithScopes.getApplicationIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parametersWithScopes.applicationIdentifier");
        List list2 = this.saveTokens(oAuth2Strategy2, (AuthorizationRequest)this.createAuthorizationRequest(oAuth2Strategy, list, string2, string3), (TokenResponse)tokenApiResult.getTokenResponse(), parametersWithScopes.getOAuth2TokenCache());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"saveTokens(\n            \u2026Auth2TokenCache\n        )");
        List records = list2;
        ICacheRecord newestRecord = (ICacheRecord)records.get(0);
        LocalAuthenticationResult localAuthenticationResult = new LocalAuthenticationResult(this.finalizeCacheRecordForResult(newestRecord, parametersWithScopes.getAuthenticationScheme()), records, SdkType.MSAL, false);
        String string4 = tokenApiResult.getCorrelationId();
        return new SignInCommandResult.Complete(string4, (ILocalAuthenticationResult)localAuthenticationResult);
    }

    private final MicrosoftStsAuthorizationRequest createAuthorizationRequest(NativeAuthOAuth2Strategy strategy, List<String> scopes, String clientId, String applicationIdentifier) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".createAuthorizationRequest");
        MicrosoftStsAuthorizationRequest.Builder builder = new MicrosoftStsAuthorizationRequest.Builder();
        builder.setAuthority(new URL(strategy.getAuthority()));
        builder.setClientId(clientId);
        builder.setScope(StringUtil.join((CharSequence)" ", (Iterable)scopes));
        builder.setApplicationIdentifier(applicationIdentifier);
        MicrosoftStsAuthorizationRequest microsoftStsAuthorizationRequest = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)microsoftStsAuthorizationRequest, (String)"builder.build()");
        return microsoftStsAuthorizationRequest;
    }

    private final List<String> addDefaultScopes(List<String> scopes) {
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, null, TAG + ".createAuthorizationRequest");
        List list = scopes;
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        List requestScopes = list;
        Set set = AuthenticationConstants.DEFAULT_SCOPES;
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"DEFAULT_SCOPES");
        requestScopes.addAll(set);
        Collection collection = requestScopes;
        Object object = new String[]{"", null};
        object = CollectionsKt.listOf((Object[])object);
        TypeIntrinsics.asMutableCollection((Object)collection).removeAll((Collection<?>)object);
        return CollectionsKt.toList((Iterable)requestScopes);
    }

    private final ResetPasswordStartCommandResult toResetPasswordStartCommandResult(ResetPasswordChallengeApiResult $this$toResetPasswordStartCommandResult) {
        ResetPasswordStartCommandResult resetPasswordStartCommandResult;
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        LogSession.Companion.logMethodCall(string, $this$toResetPasswordStartCommandResult.getCorrelationId(), TAG + ".createAuthorizationRequest");
        ResetPasswordChallengeApiResult resetPasswordChallengeApiResult = $this$toResetPasswordStartCommandResult;
        if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.CodeRequired) {
            String string2 = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getContinuationToken();
            int n = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getCodeLength();
            String string3 = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getChallengeTargetLabel();
            String string4 = ((ResetPasswordChallengeApiResult.CodeRequired)$this$toResetPasswordStartCommandResult).getChallengeChannel();
            String string5 = $this$toResetPasswordStartCommandResult.getCorrelationId();
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new ResetPasswordCommandResult.CodeRequired(string5, string2, n, string3, string4);
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.Redirect) {
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.Redirect($this$toResetPasswordStartCommandResult.getCorrelationId());
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.ExpiredToken) {
            Logger.warn((String)TAG, (String)$this$toResetPasswordStartCommandResult.getCorrelationId(), (String)("Expire token result: " + $this$toResetPasswordStartCommandResult));
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.UnknownError(((ResetPasswordChallengeApiResult.ExpiredToken)$this$toResetPasswordStartCommandResult).getError(), ((ResetPasswordChallengeApiResult.ExpiredToken)$this$toResetPasswordStartCommandResult).getErrorDescription(), null, $this$toResetPasswordStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.UnsupportedChallengeType) {
            Logger.warn((String)TAG, (String)$this$toResetPasswordStartCommandResult.getCorrelationId(), (String)("Unsupported challenge type: " + $this$toResetPasswordStartCommandResult));
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.UnknownError(((ResetPasswordChallengeApiResult.UnsupportedChallengeType)$this$toResetPasswordStartCommandResult).getError(), ((ResetPasswordChallengeApiResult.UnsupportedChallengeType)$this$toResetPasswordStartCommandResult).getErrorDescription(), null, $this$toResetPasswordStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else if (resetPasswordChallengeApiResult instanceof ResetPasswordChallengeApiResult.UnknownError) {
            Logger.warn((String)TAG, (String)$this$toResetPasswordStartCommandResult.getCorrelationId(), (String)("Unexpected result: " + $this$toResetPasswordStartCommandResult));
            resetPasswordStartCommandResult = (ResetPasswordStartCommandResult)new INativeAuthCommandResult.UnknownError(((ResetPasswordChallengeApiResult.UnknownError)$this$toResetPasswordStartCommandResult).getError(), ((ResetPasswordChallengeApiResult.UnknownError)$this$toResetPasswordStartCommandResult).getErrorDescription(), null, $this$toResetPasswordStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resetPasswordStartCommandResult;
    }

    /*
     * Unable to fully structure code
     */
    private final void renewAT(SilentTokenCommandParameters parameters, AcquireTokenResult acquireTokenSilentResult, OAuth2TokenCache<?, ?, ?> tokenCache, OAuth2Strategy<?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?> strategy, ICacheRecord cacheRecord) throws IOException, ClientException, ServiceException {
        Logger.verbose((String)NativeAuthMsalController.TAG, (String)parameters.getCorrelationId(), (String)"Renewing access token...");
        v0 = cacheRecord.getAccessToken().getTarget();
        if (v0 == null || (v0 = (var9_7 = new Regex(" ")).split(var8_6 = (CharSequence)v0, var10_8 = 0)) == null) ** GOTO lbl-1000
        $this$dropLastWhile$iv = v0;
        $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                it = (String)iterator$iv.previous();
                $i$a$-dropLastWhile-NativeAuthMsalController$renewAT$accessTokenScopes$1 = false;
                if (((CharSequence)it).length() == 0) continue;
                v1 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv), (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            v1 = v0 = CollectionsKt.emptyList();
        }
        if (v1 != null) {
            v2 = CollectionsKt.toSet((Iterable)((Iterable)v0));
        } else lbl-1000:
        // 2 sources

        {
            v2 = null;
        }
        accessTokenScopes = v2;
        parametersWithScopes = ((SilentTokenCommandParameters.SilentTokenCommandParametersBuilder)parameters.toBuilder().scopes(accessTokenScopes)).build();
        this.renewAccessToken(parametersWithScopes, acquireTokenSilentResult, tokenCache, strategy, cacheRecord);
    }

    @VisibleForTesting
    @NotNull
    public final SignUpStartApiResult performSignUpStartUsingPasswordRequest(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignUpStartCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return oAuth2Strategy.performSignUpStart(parameters);
    }

    private final SignUpChallengeApiResult performSignUpChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, String continuationToken, String correlationId) {
        return oAuth2Strategy.performSignUpChallenge(continuationToken, correlationId);
    }

    private final SignUpContinueApiResult performSignUpSubmitCode(NativeAuthOAuth2Strategy oAuth2Strategy, SignUpSubmitCodeCommandParameters parameters) {
        return oAuth2Strategy.performSignUpSubmitCode(parameters);
    }

    private final SignUpContinueApiResult performSignUpSubmitPassword(NativeAuthOAuth2Strategy oAuth2Strategy, SignUpSubmitPasswordCommandParameters parameters) {
        return oAuth2Strategy.performSignUpSubmitPassword(parameters);
    }

    @VisibleForTesting
    @NotNull
    public final SignUpContinueApiResult performSignUpSubmitUserAttributes(@NotNull NativeAuthOAuth2Strategy oAuth2Strategy, @NotNull SignUpSubmitUserAttributesCommandParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        return oAuth2Strategy.performSignUpSubmitUserAttributes(parameters);
    }

    private final SignUpSubmitUserAttributesCommandResult toSignUpSubmitUserAttrsCommandResult(SignUpChallengeApiResult $this$toSignUpSubmitUserAttrsCommandResult) {
        SignUpSubmitUserAttributesCommandResult signUpSubmitUserAttributesCommandResult;
        SignUpChallengeApiResult signUpChallengeApiResult = $this$toSignUpSubmitUserAttrsCommandResult;
        if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.Redirect) {
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitUserAttrsCommandResult.getCorrelationId());
        } else if ((((signUpChallengeApiResult instanceof SignUpChallengeApiResult.ExpiredToken ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnsupportedChallengeType) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.OOBRequired) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.PasswordRequired) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnknownError) {
            Logger.warn((String)TAG, (String)$this$toSignUpSubmitUserAttrsCommandResult.getCorrelationId(), (String)("Unexpected result: " + $this$toSignUpSubmitUserAttrsCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignUpSubmitUserAttrsCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpSubmitUserAttrsCommandResult;
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)$this$toSignUpSubmitUserAttrsCommandResult).getError(), ((ApiErrorResult)$this$toSignUpSubmitUserAttrsCommandResult).getErrorDescription(), null, $this$toSignUpSubmitUserAttrsCommandResult.getCorrelationId(), null, null, 52, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signUpSubmitUserAttributesCommandResult;
    }

    private final SignUpStartCommandResult toSignUpStartCommandResult(SignUpChallengeApiResult $this$toSignUpStartCommandResult) {
        SignUpStartCommandResult signUpStartCommandResult;
        SignUpChallengeApiResult signUpChallengeApiResult = $this$toSignUpStartCommandResult;
        if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.OOBRequired) {
            String string = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getContinuationToken();
            int n = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getCodeLength();
            String string2 = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getChallengeTargetLabel();
            String string3 = ((SignUpChallengeApiResult.OOBRequired)$this$toSignUpStartCommandResult).getChallengeChannel();
            String string4 = $this$toSignUpStartCommandResult.getCorrelationId();
            signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.CodeRequired(string4, string, string2, string3, n);
        } else if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.PasswordRequired) {
            String string = ((SignUpChallengeApiResult.PasswordRequired)$this$toSignUpStartCommandResult).getContinuationToken();
            String string5 = $this$toSignUpStartCommandResult.getCorrelationId();
            signUpStartCommandResult = (SignUpStartCommandResult)new SignUpCommandResult.PasswordRequired(string5, string);
        } else if (signUpChallengeApiResult instanceof SignUpChallengeApiResult.Redirect) {
            signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpStartCommandResult.getCorrelationId());
        } else if ((signUpChallengeApiResult instanceof SignUpChallengeApiResult.ExpiredToken ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnsupportedChallengeType) ? true : signUpChallengeApiResult instanceof SignUpChallengeApiResult.UnknownError) {
            Logger.warn((String)TAG, (String)$this$toSignUpStartCommandResult.getCorrelationId(), (String)("Unexpected result: " + $this$toSignUpStartCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpStartCommandResult;
            signUpStartCommandResult = (SignUpStartCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)$this$toSignUpStartCommandResult).getError(), ((ApiErrorResult)$this$toSignUpStartCommandResult).getErrorDescription(), null, $this$toSignUpStartCommandResult.getCorrelationId(), null, null, 52, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signUpStartCommandResult;
    }

    private final SignUpSubmitCodeCommandResult toSignUpSubmitCodeCommandResult(SignUpContinueApiResult $this$toSignUpSubmitCodeCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy) {
        SignUpSubmitCodeCommandResult signUpSubmitCodeCommandResult;
        SignUpContinueApiResult signUpContinueApiResult = $this$toSignUpSubmitCodeCommandResult;
        if (signUpContinueApiResult instanceof SignUpContinueApiResult.Success) {
            String string = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitCodeCommandResult).getContinuationToken();
            Integer n = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitCodeCommandResult).getExpiresIn();
            String string2 = $this$toSignUpSubmitCodeCommandResult.getCorrelationId();
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.Complete(string2, string, n);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.ExpiredToken) {
            Logger.warn((String)TAG, (String)$this$toSignUpSubmitCodeCommandResult.getCorrelationId(), (String)("Expire token result: " + $this$toSignUpSubmitCodeCommandResult));
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.UnknownError(((SignUpContinueApiResult.ExpiredToken)$this$toSignUpSubmitCodeCommandResult).getError(), ((SignUpContinueApiResult.ExpiredToken)$this$toSignUpSubmitCodeCommandResult).getErrorDescription(), null, $this$toSignUpSubmitCodeCommandResult.getCorrelationId(), null, null, 52, null);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UsernameAlreadyExists) {
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.UsernameAlreadyExists(((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitCodeCommandResult).getError(), ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitCodeCommandResult).getErrorDescription(), $this$toSignUpSubmitCodeCommandResult.getCorrelationId());
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.AttributesRequired) {
            signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.AttributesRequired(((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getContinuationToken(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getError(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getErrorDescription(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitCodeCommandResult).getRequiredAttributes(), $this$toSignUpSubmitCodeCommandResult.getCorrelationId());
        } else {
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.CredentialRequired) {
                SignUpStartCommandResult signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpContinueApiResult.CredentialRequired)$this$toSignUpSubmitCodeCommandResult).getContinuationToken(), $this$toSignUpSubmitCodeCommandResult.getCorrelationId()));
                Intrinsics.checkNotNull((Object)signUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitCodeCommandResult");
                return (SignUpSubmitCodeCommandResult)signUpStartCommandResult;
            }
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidOOBValue) {
                String string = ((SignUpContinueApiResult.InvalidOOBValue)$this$toSignUpSubmitCodeCommandResult).getError();
                String string3 = ((SignUpContinueApiResult.InvalidOOBValue)$this$toSignUpSubmitCodeCommandResult).getErrorDescription();
                String string4 = ((SignUpContinueApiResult.InvalidOOBValue)$this$toSignUpSubmitCodeCommandResult).getSubError();
                String string5 = $this$toSignUpSubmitCodeCommandResult.getCorrelationId();
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new SignUpCommandResult.InvalidCode(string, string3, string5, string4);
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.Redirect) {
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitCodeCommandResult.getCorrelationId());
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)$this$toSignUpSubmitCodeCommandResult.getCorrelationId(), (String)("Unexpected result: " + $this$toSignUpSubmitCodeCommandResult));
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.UnknownError(((SignUpContinueApiResult.UnknownError)$this$toSignUpSubmitCodeCommandResult).getError(), ((SignUpContinueApiResult.UnknownError)$this$toSignUpSubmitCodeCommandResult).getErrorDescription(), null, $this$toSignUpSubmitCodeCommandResult.getCorrelationId(), null, null, 52, null);
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidAttributes ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidPassword) {
                Logger.warn((String)TAG, (String)$this$toSignUpSubmitCodeCommandResult.getCorrelationId(), (String)("Unexpected result: " + $this$toSignUpSubmitCodeCommandResult));
                signUpSubmitCodeCommandResult = (SignUpSubmitCodeCommandResult)new INativeAuthCommandResult.UnknownError("unexpected_api_result", "API returned unexpected result: " + $this$toSignUpSubmitCodeCommandResult, null, $this$toSignUpSubmitCodeCommandResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signUpSubmitCodeCommandResult;
    }

    private final SignUpSubmitUserAttributesCommandResult toSignUpSubmitUserAttributesCommandResult(SignUpContinueApiResult $this$toSignUpSubmitUserAttributesCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy) {
        SignUpSubmitUserAttributesCommandResult signUpSubmitUserAttributesCommandResult;
        SignUpContinueApiResult signUpContinueApiResult = $this$toSignUpSubmitUserAttributesCommandResult;
        if (signUpContinueApiResult instanceof SignUpContinueApiResult.Success) {
            String string = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitUserAttributesCommandResult).getContinuationToken();
            Integer n = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitUserAttributesCommandResult).getExpiresIn();
            String string2 = $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId();
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.Complete(string2, string, n);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UsernameAlreadyExists) {
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.UsernameAlreadyExists(((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitUserAttributesCommandResult).getError(), ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription(), $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId());
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.AttributesRequired) {
            signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.AttributesRequired(((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getContinuationToken(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getError(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitUserAttributesCommandResult).getRequiredAttributes(), $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId());
        } else {
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.CredentialRequired) {
                return this.toSignUpSubmitUserAttrsCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpContinueApiResult.CredentialRequired)$this$toSignUpSubmitUserAttributesCommandResult).getContinuationToken(), $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId()));
            }
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.Redirect) {
                signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId());
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidAttributes) {
                signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new SignUpCommandResult.InvalidAttributes(((SignUpContinueApiResult.InvalidAttributes)$this$toSignUpSubmitUserAttributesCommandResult).getError(), ((SignUpContinueApiResult.InvalidAttributes)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription(), ((SignUpContinueApiResult.InvalidAttributes)$this$toSignUpSubmitUserAttributesCommandResult).getInvalidAttributes(), $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId());
            } else if (((signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidOOBValue ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidPassword) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.ExpiredToken) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)$this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId(), (String)("Expire token result: " + $this$toSignUpSubmitUserAttributesCommandResult));
                Intrinsics.checkNotNull((Object)$this$toSignUpSubmitUserAttributesCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpSubmitUserAttributesCommandResult;
                signUpSubmitUserAttributesCommandResult = (SignUpSubmitUserAttributesCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)$this$toSignUpSubmitUserAttributesCommandResult).getError(), ((ApiErrorResult)$this$toSignUpSubmitUserAttributesCommandResult).getErrorDescription(), null, $this$toSignUpSubmitUserAttributesCommandResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signUpSubmitUserAttributesCommandResult;
    }

    private final SignUpSubmitPasswordCommandResult toSignUpSubmitPasswordCommandResult(SignUpContinueApiResult $this$toSignUpSubmitPasswordCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy) {
        SignUpSubmitPasswordCommandResult signUpSubmitPasswordCommandResult;
        SignUpContinueApiResult signUpContinueApiResult = $this$toSignUpSubmitPasswordCommandResult;
        if (signUpContinueApiResult instanceof SignUpContinueApiResult.Success) {
            String string = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitPasswordCommandResult).getContinuationToken();
            Integer n = ((SignUpContinueApiResult.Success)$this$toSignUpSubmitPasswordCommandResult).getExpiresIn();
            String string2 = $this$toSignUpSubmitPasswordCommandResult.getCorrelationId();
            signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.Complete(string2, string, n);
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.UsernameAlreadyExists) {
            signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.UsernameAlreadyExists(((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitPasswordCommandResult).getError(), ((SignUpContinueApiResult.UsernameAlreadyExists)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription(), $this$toSignUpSubmitPasswordCommandResult.getCorrelationId());
        } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.AttributesRequired) {
            signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.AttributesRequired(((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getContinuationToken(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getError(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription(), ((SignUpContinueApiResult.AttributesRequired)$this$toSignUpSubmitPasswordCommandResult).getRequiredAttributes(), $this$toSignUpSubmitPasswordCommandResult.getCorrelationId());
        } else {
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.CredentialRequired) {
                SignUpStartCommandResult signUpStartCommandResult = this.toSignUpStartCommandResult(this.performSignUpChallengeCall(oAuth2Strategy, ((SignUpContinueApiResult.CredentialRequired)$this$toSignUpSubmitPasswordCommandResult).getContinuationToken(), $this$toSignUpSubmitPasswordCommandResult.getCorrelationId()));
                Intrinsics.checkNotNull((Object)signUpStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.controllers.results.SignUpSubmitPasswordCommandResult");
                return (SignUpSubmitPasswordCommandResult)signUpStartCommandResult;
            }
            if (signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidPassword) {
                String string = ((SignUpContinueApiResult.InvalidPassword)$this$toSignUpSubmitPasswordCommandResult).getError();
                String string3 = ((SignUpContinueApiResult.InvalidPassword)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription();
                String string4 = ((SignUpContinueApiResult.InvalidPassword)$this$toSignUpSubmitPasswordCommandResult).getSubError();
                String string5 = $this$toSignUpSubmitPasswordCommandResult.getCorrelationId();
                signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new SignUpCommandResult.InvalidPassword(string, string3, string5, string4);
            } else if (signUpContinueApiResult instanceof SignUpContinueApiResult.Redirect) {
                signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new INativeAuthCommandResult.Redirect($this$toSignUpSubmitPasswordCommandResult.getCorrelationId());
            } else if (((signUpContinueApiResult instanceof SignUpContinueApiResult.ExpiredToken ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidOOBValue) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.InvalidAttributes) ? true : signUpContinueApiResult instanceof SignUpContinueApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)$this$toSignUpSubmitPasswordCommandResult.getCorrelationId(), (String)("Error in signup continue result: " + $this$toSignUpSubmitPasswordCommandResult));
                Intrinsics.checkNotNull((Object)$this$toSignUpSubmitPasswordCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
                ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignUpSubmitPasswordCommandResult;
                signUpSubmitPasswordCommandResult = (SignUpSubmitPasswordCommandResult)new INativeAuthCommandResult.UnknownError(((ApiErrorResult)$this$toSignUpSubmitPasswordCommandResult).getError(), ((ApiErrorResult)$this$toSignUpSubmitPasswordCommandResult).getErrorDescription(), null, $this$toSignUpSubmitPasswordCommandResult.getCorrelationId(), null, null, 52, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signUpSubmitPasswordCommandResult;
    }

    private final SignInStartCommandResult toSignInStartCommandResult(SignInTokenApiResult $this$toSignInStartCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy, SignInStartCommandParameters parametersWithScopes) {
        SignInStartCommandResult signInStartCommandResult;
        SignInTokenApiResult signInTokenApiResult = $this$toSignInStartCommandResult;
        if (signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) {
            String string = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInStartCommandResult).getError();
            String string2 = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInStartCommandResult).getErrorDescription();
            List list = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInStartCommandResult).getErrorCodes();
            String string3 = $this$toSignInStartCommandResult.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.InvalidCredentials(string, string2, string3, list);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
            signInStartCommandResult = (SignInStartCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)$this$toSignInStartCommandResult);
        } else if ((((signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect ? true : signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UnknownError) {
            Logger.warn((String)TAG, (String)$this$toSignInStartCommandResult.getCorrelationId(), (String)("Unexpected result: " + $this$toSignInStartCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignInStartCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignInStartCommandResult;
            String string = "API returned unexpected result: " + $this$toSignInStartCommandResult;
            List list = ((ApiErrorResult)$this$toSignInStartCommandResult).getErrorCodes();
            String string4 = $this$toSignInStartCommandResult.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.UnknownError("unexpected_api_result", string, null, string4, list, null, 36, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signInStartCommandResult;
    }

    private final SignInSubmitPasswordCommandResult toSignInSubmitPasswordCommandResult(SignInTokenApiResult $this$toSignInSubmitPasswordCommandResult, NativeAuthOAuth2Strategy oAuth2Strategy, SignInSubmitPasswordCommandParameters parametersWithScopes) {
        SignInSubmitPasswordCommandResult signInSubmitPasswordCommandResult;
        SignInTokenApiResult signInTokenApiResult = $this$toSignInSubmitPasswordCommandResult;
        if (signInTokenApiResult instanceof SignInTokenApiResult.InvalidCredentials) {
            String string = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInSubmitPasswordCommandResult).getError();
            String string2 = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInSubmitPasswordCommandResult).getErrorDescription();
            List list = ((SignInTokenApiResult.InvalidCredentials)$this$toSignInSubmitPasswordCommandResult).getErrorCodes();
            String string3 = $this$toSignInSubmitPasswordCommandResult.getCorrelationId();
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)new SignInCommandResult.InvalidCredentials(string, string2, string3, list);
        } else if (signInTokenApiResult instanceof SignInTokenApiResult.Success) {
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)this.saveAndReturnTokens(oAuth2Strategy, (BaseSignInTokenCommandParameters)parametersWithScopes, (SignInTokenApiResult.Success)$this$toSignInSubmitPasswordCommandResult);
        } else if ((((signInTokenApiResult instanceof SignInTokenApiResult.UserNotFound ? true : signInTokenApiResult instanceof SignInTokenApiResult.CodeIncorrect) ? true : signInTokenApiResult instanceof SignInTokenApiResult.MFARequired) ? true : signInTokenApiResult instanceof SignInTokenApiResult.InvalidAuthenticationType) ? true : signInTokenApiResult instanceof SignInTokenApiResult.UnknownError) {
            Logger.warn((String)TAG, (String)$this$toSignInSubmitPasswordCommandResult.getCorrelationId(), (String)("Unexpected result: " + $this$toSignInSubmitPasswordCommandResult));
            Intrinsics.checkNotNull((Object)$this$toSignInSubmitPasswordCommandResult, (String)"null cannot be cast to non-null type com.microsoft.identity.common.java.nativeauth.providers.responses.ApiErrorResult");
            ApiErrorResult cfr_ignored_0 = (ApiErrorResult)$this$toSignInSubmitPasswordCommandResult;
            String string = "API returned unexpected result: " + $this$toSignInSubmitPasswordCommandResult;
            List list = ((ApiErrorResult)$this$toSignInSubmitPasswordCommandResult).getErrorCodes();
            String string4 = $this$toSignInSubmitPasswordCommandResult.getCorrelationId();
            signInSubmitPasswordCommandResult = (SignInSubmitPasswordCommandResult)new INativeAuthCommandResult.UnknownError("unexpected_api_result", string, null, string4, list, null, 36, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signInSubmitPasswordCommandResult;
    }

    @VisibleForTesting
    @NotNull
    public final SignInStartCommandResult processSignInInitiateApiResult(@NotNull SignInInitiateApiResult initiateApiResult, @Nullable SignInStartCommandParameters parametersWithScopes, @NotNull NativeAuthOAuth2Strategy oAuth2Strategy, boolean usePassword) {
        SignInStartCommandResult signInStartCommandResult;
        Intrinsics.checkNotNullParameter((Object)initiateApiResult, (String)"initiateApiResult");
        Intrinsics.checkNotNullParameter((Object)oAuth2Strategy, (String)"oAuth2Strategy");
        SignInInitiateApiResult signInInitiateApiResult = initiateApiResult;
        if (signInInitiateApiResult instanceof SignInInitiateApiResult.Redirect) {
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.Redirect(initiateApiResult.getCorrelationId());
        } else {
            if (signInInitiateApiResult instanceof SignInInitiateApiResult.Success) {
                SignInChallengeApiResult signInChallengeResult = this.performSignInChallengeCall(oAuth2Strategy, ((SignInInitiateApiResult.Success)initiateApiResult).getContinuationToken(), initiateApiResult.getCorrelationId());
                return this.processSignInChallengeCall(oAuth2Strategy, parametersWithScopes, signInChallengeResult, usePassword);
            }
            if (signInInitiateApiResult instanceof SignInInitiateApiResult.UserNotFound) {
                String string = ((SignInInitiateApiResult.UserNotFound)initiateApiResult).getError();
                String string2 = ((SignInInitiateApiResult.UserNotFound)initiateApiResult).getErrorDescription();
                List list = ((SignInInitiateApiResult.UserNotFound)initiateApiResult).getErrorCodes();
                String string3 = initiateApiResult.getCorrelationId();
                signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.UserNotFound(string, string2, string3, list);
            } else if (signInInitiateApiResult instanceof SignInInitiateApiResult.UnknownError) {
                Logger.warn((String)TAG, (String)initiateApiResult.getCorrelationId(), (String)("Unexpected result: " + initiateApiResult));
                String string = ((SignInInitiateApiResult.UnknownError)initiateApiResult).getError();
                String string4 = ((SignInInitiateApiResult.UnknownError)initiateApiResult).getErrorDescription();
                List list = ((SignInInitiateApiResult.UnknownError)initiateApiResult).getErrorCodes();
                String string5 = initiateApiResult.getCorrelationId();
                signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.UnknownError(string, string4, null, string5, list, null, 36, null);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return signInStartCommandResult;
    }

    public static /* synthetic */ SignInStartCommandResult processSignInInitiateApiResult$default(NativeAuthMsalController nativeAuthMsalController, SignInInitiateApiResult signInInitiateApiResult, SignInStartCommandParameters signInStartCommandParameters, NativeAuthOAuth2Strategy nativeAuthOAuth2Strategy, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            signInStartCommandParameters = null;
        }
        if ((n & 8) != 0) {
            bl = false;
        }
        return nativeAuthMsalController.processSignInInitiateApiResult(signInInitiateApiResult, signInStartCommandParameters, nativeAuthOAuth2Strategy, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SignInStartCommandResult processSignInChallengeCall(NativeAuthOAuth2Strategy oAuth2Strategy, SignInStartCommandParameters parametersWithScopes, SignInChallengeApiResult result, boolean usePassword) {
        SignInStartCommandResult signInStartCommandResult;
        SignInChallengeApiResult signInChallengeApiResult = result;
        if (signInChallengeApiResult instanceof SignInChallengeApiResult.OOBRequired) {
            String string = ((SignInChallengeApiResult.OOBRequired)result).getContinuationToken();
            int n = ((SignInChallengeApiResult.OOBRequired)result).getCodeLength();
            String string2 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeTargetLabel();
            String string3 = ((SignInChallengeApiResult.OOBRequired)result).getChallengeChannel();
            String string4 = result.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.CodeRequired(string, string4, string2, string3, n);
        } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.PasswordRequired) {
            if (usePassword) {
                if (parametersWithScopes == null) {
                    throw new IllegalArgumentException("Parameters must be provided in password flow");
                }
                SignInSubmitPasswordCommandParameters signInSubmitPasswordCommandParameters = CommandUtil.createSignInSubmitPasswordCommandParameters(parametersWithScopes, result.getCorrelationId(), ((SignInChallengeApiResult.PasswordRequired)result).getContinuationToken());
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)signInSubmitPasswordCommandParameters, (String)"signInSubmitPasswordCommandParameters");
                    SignInStartCommandResult signInStartCommandResult2 = this.toSignInStartCommandResult(this.performPasswordTokenCall(oAuth2Strategy, signInSubmitPasswordCommandParameters), oAuth2Strategy, parametersWithScopes);
                    return signInStartCommandResult2;
                }
                finally {
                    StringUtil.overwriteWithNull((char[])signInSubmitPasswordCommandParameters.password);
                }
            }
            String string = ((SignInChallengeApiResult.PasswordRequired)result).getContinuationToken();
            String string5 = result.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new SignInCommandResult.PasswordRequired(string5, string);
        } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.Redirect) {
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.Redirect(result.getCorrelationId());
        } else if (signInChallengeApiResult instanceof SignInChallengeApiResult.UnknownError) {
            Logger.warn((String)TAG, (String)result.getCorrelationId(), (String)("Unexpected result: " + result));
            String string = ((SignInChallengeApiResult.UnknownError)result).getError();
            String string6 = ((SignInChallengeApiResult.UnknownError)result).getErrorDescription();
            List list = ((SignInChallengeApiResult.UnknownError)result).getErrorCodes();
            String string7 = result.getCorrelationId();
            signInStartCommandResult = (SignInStartCommandResult)new INativeAuthCommandResult.UnknownError(string, string6, null, string7, list, null, 36, null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return signInStartCommandResult;
    }

    private final NativeAuthOAuth2Strategy createOAuth2Strategy(BaseNativeAuthCommandParameters parameters) {
        OAuth2StrategyParameters strategyParameters = OAuth2StrategyParameters.builder().platformComponents(parameters.getPlatformComponents()).challengeTypes(parameters.challengeType).build();
        NativeAuthCIAMAuthority nativeAuthCIAMAuthority = parameters.authority;
        Intrinsics.checkNotNullExpressionValue((Object)strategyParameters, (String)"strategyParameters");
        return nativeAuthCIAMAuthority.createOAuth2Strategy(strategyParameters);
    }

    private static final boolean resetPasswordPollCompletion$pollCompletionTimedOut(long startTime) {
        long currentTime = System.currentTimeMillis();
        return currentTime - startTime > 300000L;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/microsoft/identity/common/nativeauth/internal/controllers/NativeAuthMsalController$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "common_distRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

