/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import androidx.annotation.NonNull;
import com.microsoft.identity.common.internal.cache.IMultiTypeNameValueStorageReencrypter;
import com.microsoft.identity.common.java.cache.IMultiTypeNameValueStorage;
import com.microsoft.identity.common.java.util.TaskCompletedCallbackWithError;
import java.util.HashMap;
import java.util.Map;

public class DefaultMultiTypeNameValueStorageReencrypter
implements IMultiTypeNameValueStorageReencrypter {
    @Override
    public void reencrypt(@NonNull IMultiTypeNameValueStorage fileManager, @NonNull IMultiTypeNameValueStorageReencrypter.IStringEncrypter encrypter, @NonNull IMultiTypeNameValueStorageReencrypter.IStringDecrypter decrypter, @NonNull IMultiTypeNameValueStorageReencrypter.ReencryptionParams params) throws Exception {
        HashMap cacheEntries = new HashMap(fileManager.getAll());
        for (Map.Entry entry : cacheEntries.entrySet()) {
            String clearTextKey = (String)entry.getKey();
            String encryptedTextValye = (String)entry.getValue();
            try {
                String decryptedTextValue = decrypter.decrypt(encryptedTextValye);
                String reencryptedTextValue = encrypter.encrypt(decryptedTextValue);
                fileManager.putString(clearTextKey, reencryptedTextValue);
            }
            catch (Exception e) {
                if (params.eraseEntryOnError()) {
                    fileManager.remove(clearTextKey);
                }
                if (params.eraseAllOnError()) {
                    fileManager.clear();
                    if (!params.abortOnError()) break;
                    throw e;
                }
                if (!params.abortOnError()) continue;
                throw e;
            }
        }
    }

    @Override
    public void reencryptAsync(final @NonNull IMultiTypeNameValueStorage fileManager, final @NonNull IMultiTypeNameValueStorageReencrypter.IStringEncrypter encrypter, final @NonNull IMultiTypeNameValueStorageReencrypter.IStringDecrypter decrypter, final @NonNull IMultiTypeNameValueStorageReencrypter.ReencryptionParams params, final @NonNull TaskCompletedCallbackWithError<Void, Exception> callback) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    DefaultMultiTypeNameValueStorageReencrypter.this.reencrypt(fileManager, encrypter, decrypter, params);
                    callback.onTaskCompleted(null);
                }
                catch (Exception e) {
                    callback.onError((Object)e);
                }
            }
        }).start();
    }
}

