/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.controllers;

import android.content.Intent;
import android.support.annotation.NonNull;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.internal.controllers.BaseController;
import com.microsoft.identity.common.internal.controllers.TokenOperation;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.ILocalAuthenticationCallback;
import com.microsoft.identity.common.internal.request.OperationParameters;
import com.microsoft.identity.common.internal.result.AcquireTokenResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class TokenCommand
implements TokenOperation {
    private static final String TAG = TokenCommand.class.getSimpleName();
    protected OperationParameters mParameters;
    protected List<BaseController> mControllers;
    protected ILocalAuthenticationCallback mCallback;

    public TokenCommand() {
    }

    public TokenCommand(@NonNull OperationParameters parameters, @NonNull BaseController controller, @NonNull ILocalAuthenticationCallback callback) {
        this.mParameters = parameters;
        this.mControllers = new ArrayList<BaseController>();
        this.mCallback = callback;
        this.mControllers.add(controller);
    }

    public TokenCommand(@NonNull OperationParameters parameters, @NonNull List<BaseController> controllers, @NonNull ILocalAuthenticationCallback callback) {
        this.mParameters = parameters;
        this.mControllers = controllers;
        this.mCallback = callback;
    }

    @Override
    public AcquireTokenResult execute() throws InterruptedException, ExecutionException, IOException, BaseException {
        AcquireTokenResult result = null;
        String methodName = ":execute";
        for (int ii = 0; ii < this.mControllers.size(); ++ii) {
            BaseController controller = this.mControllers.get(ii);
            try {
                Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName());
                result = controller.acquireTokenSilent((AcquireTokenSilentOperationParameters)this.getParameters());
                if (!result.getSucceeded().booleanValue()) continue;
                Logger.verbose(TAG + ":execute", "Executing with controller: " + controller.getClass().getSimpleName() + ": Succeeded");
                return result;
            }
            catch (ClientException | UiRequiredException e) {
                if (e.getErrorCode().equals("invalid_grant") && this.mControllers.size() > ii + 1 || (e.getErrorCode().equals("no_tokens_found") || e.getErrorCode().equals("no_account_found")) && this.mControllers.size() > ii + 1) continue;
                throw e;
            }
        }
        return result;
    }

    @Override
    public void notify(int requestCode, int resultCode, Intent data) {
        throw new UnsupportedOperationException();
    }

    public OperationParameters getParameters() {
        return this.mParameters;
    }

    public void setParameters(OperationParameters parameters) {
        if (!(parameters instanceof AcquireTokenSilentOperationParameters)) {
            throw new IllegalArgumentException("Invalid operation parameters");
        }
        this.mParameters = parameters;
    }

    public BaseController getDefaultController() {
        return this.mControllers.get(0);
    }

    public List<BaseController> getControllers() {
        return this.mControllers;
    }

    public void setControllers(List<BaseController> controllers) {
        this.mControllers = controllers;
    }

    public ILocalAuthenticationCallback getCallback() {
        return this.mCallback;
    }

    public void setCallback(ILocalAuthenticationCallback callback) {
        this.mCallback = callback;
    }
}

