/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.internal.cache.CacheRecord;
import com.microsoft.identity.common.internal.cache.IAccountCredentialAdapter;
import com.microsoft.identity.common.internal.cache.IAccountCredentialCache;
import com.microsoft.identity.common.internal.cache.ICacheRecord;
import com.microsoft.identity.common.internal.cache.MsalOAuth2TokenCache;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.Credential;
import com.microsoft.identity.common.internal.dto.RefreshTokenRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;
import com.microsoft.identity.common.internal.providers.oauth2.TokenResponse;

public class MicrosoftFamilyOAuth2TokenCache<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest, GenericTokenResponse extends TokenResponse, GenericAccount extends BaseAccount, GenericRefreshToken extends RefreshToken>
extends MsalOAuth2TokenCache<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> {
    private static final String TAG = MicrosoftFamilyOAuth2TokenCache.class.getSimpleName();

    public MicrosoftFamilyOAuth2TokenCache(Context context, IAccountCredentialCache accountCredentialCache, IAccountCredentialAdapter<GenericOAuth2Strategy, GenericAuthorizationRequest, GenericTokenResponse, GenericAccount, GenericRefreshToken> accountCredentialAdapter) {
        super(context, accountCredentialCache, accountCredentialAdapter);
    }

    public ICacheRecord loadByFamilyId(@Nullable String clientId, @NonNull AccountRecord accountRecord) {
        String methodName = ":loadByFamilyId";
        String familyId = "1";
        Logger.verbose(TAG + ":loadByFamilyId", "ClientId[" + clientId + ", " + "1" + "]");
        RefreshTokenRecord rtToReturn = null;
        for (Credential credential : this.getAccountCredentialCache().getCredentials()) {
            RefreshTokenRecord rtRecord;
            if (!(credential instanceof RefreshTokenRecord) || !"1".equals((rtRecord = (RefreshTokenRecord)credential).getFamilyId()) || !accountRecord.getEnvironment().equals(rtRecord.getEnvironment()) || !accountRecord.getHomeAccountId().equals(rtRecord.getHomeAccountId())) continue;
            rtToReturn = rtRecord;
            break;
        }
        CacheRecord result = new CacheRecord();
        result.setAccount(accountRecord);
        result.setRefreshToken(rtToReturn);
        return result;
    }
}

