/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import com.microsoft.identity.common.adal.internal.ADALUserInfo;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccessToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAuthorizationRequest;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryRefreshToken;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenResponse;
import com.microsoft.identity.common.internal.util.DateUtilities;
import java.util.Date;

public class ADALTokenCacheItem {
    private ADALUserInfo mUserInfo;
    private String mResource;
    private String mAuthority;
    private String mClientId;
    private String mAccessToken;
    private String mRefreshtoken;
    private String mRawIdToken;
    private Date mExpiresOn;
    private boolean mIsMultiResourceRefreshToken;
    private String mTenantId;
    private String mFamilyClientId;
    private Date mExtendedExpiresOn;
    private String mSpeRing;

    ADALTokenCacheItem(ADALTokenCacheItem tokenCacheItem) {
        this.mAuthority = tokenCacheItem.getAuthority();
        this.mResource = tokenCacheItem.getResource();
        this.mClientId = tokenCacheItem.getClientId();
        this.mAccessToken = tokenCacheItem.getAccessToken();
        this.mRefreshtoken = tokenCacheItem.getRefreshToken();
        this.mRawIdToken = tokenCacheItem.getRawIdToken();
        this.mUserInfo = tokenCacheItem.getUserInfo();
        this.mExpiresOn = tokenCacheItem.getExpiresOn();
        this.mIsMultiResourceRefreshToken = tokenCacheItem.getIsMultiResourceRefreshToken();
        this.mTenantId = tokenCacheItem.getTenantId();
        this.mFamilyClientId = tokenCacheItem.getFamilyClientId();
        this.mExtendedExpiresOn = tokenCacheItem.getExtendedExpiresOn();
        this.mSpeRing = tokenCacheItem.getSpeRing();
    }

    ADALTokenCacheItem(AzureActiveDirectoryOAuth2Strategy strategy, AzureActiveDirectoryAuthorizationRequest request, AzureActiveDirectoryTokenResponse response) {
        String issuerCacheIdentifier = strategy.getIssuerCacheIdentifier(request);
        AzureActiveDirectoryAccount account = strategy.createAccount(response);
        account.setEnvironment(issuerCacheIdentifier);
        AzureActiveDirectoryAccessToken accessToken = strategy.getAccessTokenFromResponse(response);
        AzureActiveDirectoryRefreshToken refreshToken = strategy.getRefreshTokenFromResponse(response);
        this.mAuthority = issuerCacheIdentifier;
        this.mResource = request.getScope();
        this.mClientId = request.getClientId();
        this.mAccessToken = accessToken.getAccessToken();
        this.mRefreshtoken = refreshToken.getRefreshToken();
        this.mRawIdToken = response.getIdToken();
        this.mUserInfo = new ADALUserInfo(account);
        this.mTenantId = account.getRealm();
        this.mExpiresOn = accessToken.getExpiresOn();
        this.mExtendedExpiresOn = accessToken.getExtendedExpiresOn();
        this.mIsMultiResourceRefreshToken = true;
        this.mFamilyClientId = refreshToken.getFamilyId();
        this.mSpeRing = response.getSpeRing();
    }

    public static ADALTokenCacheItem getAsMRRTTokenCacheItem(ADALTokenCacheItem originalCacheItem) {
        ADALTokenCacheItem newItem = new ADALTokenCacheItem(originalCacheItem);
        newItem.setResource(null);
        newItem.setAccessToken(null);
        return newItem;
    }

    public static ADALTokenCacheItem getAsFRTTokenCacheItem(ADALTokenCacheItem originalCacheItem) {
        ADALTokenCacheItem newItem = new ADALTokenCacheItem(originalCacheItem);
        newItem.setResource(null);
        newItem.setAccessToken(null);
        newItem.setClientId(null);
        return newItem;
    }

    String getSpeRing() {
        return this.mSpeRing;
    }

    void setSpeRing(String speRing) {
        this.mSpeRing = speRing;
    }

    public ADALUserInfo getUserInfo() {
        return this.mUserInfo;
    }

    public void setUserInfo(ADALUserInfo info) {
        this.mUserInfo = info;
    }

    public String getResource() {
        return this.mResource;
    }

    public void setResource(String resource) {
        this.mResource = resource;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public void setAuthority(String authority) {
        this.mAuthority = authority;
    }

    public String getClientId() {
        return this.mClientId;
    }

    public void setClientId(String clientId) {
        this.mClientId = clientId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void setAccessToken(String accessToken) {
        this.mAccessToken = accessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshtoken;
    }

    public void setRefreshToken(String refreshToken) {
        this.mRefreshtoken = refreshToken;
    }

    public Date getExpiresOn() {
        return DateUtilities.createCopy(this.mExpiresOn);
    }

    public void setExpiresOn(Date expiresOn) {
        this.mExpiresOn = DateUtilities.createCopy(expiresOn);
    }

    public boolean getIsMultiResourceRefreshToken() {
        return this.mIsMultiResourceRefreshToken;
    }

    public void setIsMultiResourceRefreshToken(boolean isMultiResourceRefreshToken) {
        this.mIsMultiResourceRefreshToken = isMultiResourceRefreshToken;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public void setTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public String getRawIdToken() {
        return this.mRawIdToken;
    }

    public void setRawIdToken(String rawIdToken) {
        this.mRawIdToken = rawIdToken;
    }

    public final String getFamilyClientId() {
        return this.mFamilyClientId;
    }

    public final void setFamilyClientId(String familyClientId) {
        this.mFamilyClientId = familyClientId;
    }

    public final void setExtendedExpiresOn(Date extendedExpiresOn) {
        this.mExtendedExpiresOn = DateUtilities.createCopy(extendedExpiresOn);
    }

    public final Date getExtendedExpiresOn() {
        return DateUtilities.createCopy(this.mExtendedExpiresOn);
    }
}

