/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authorities;

import android.net.Uri;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Configuration;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsOAuth2Strategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import java.net.MalformedURLException;
import java.net.URL;

public class AzureActiveDirectoryB2CAuthority
extends Authority {
    private static final String TAG = AzureActiveDirectoryB2CAuthority.class.getName();

    AzureActiveDirectoryB2CAuthority(String authorityUrl) {
        this.mAuthorityTypeString = "B2C";
        this.mAuthorityUrl = authorityUrl;
    }

    @Override
    public Uri getAuthorityUri() {
        return Uri.parse((String)this.mAuthorityUrl);
    }

    @Override
    public URL getAuthorityURL() {
        try {
            return new URL(this.getAuthorityUri().toString());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Authority URL is not a URL.", e);
        }
    }

    @Override
    public OAuth2Strategy createOAuth2Strategy() {
        String methodName = ":createOAuth2Strategy";
        Logger.verbose(TAG + ":createOAuth2Strategy", "Creating OAuth2Strategy ");
        MicrosoftStsOAuth2Configuration config = new MicrosoftStsOAuth2Configuration();
        config.setMultipleCloudsSupported(false);
        config.setAuthorityUrl(this.getAuthorityURL());
        return new MicrosoftStsOAuth2Strategy(config);
    }
}

