/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.result;

import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.exception.IntuneAppProtectionPolicyRequiredException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.exception.UiRequiredException;
import com.microsoft.identity.common.exception.UserCancelException;
import com.microsoft.identity.common.internal.broker.BrokerResult;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.dto.AccessTokenRecord;
import com.microsoft.identity.common.internal.dto.AccountRecord;
import com.microsoft.identity.common.internal.dto.CredentialType;
import com.microsoft.identity.common.internal.dto.IAccountRecord;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.microsoft.microsoftsts.MicrosoftStsAccount;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.result.IBrokerResultAdapter;
import com.microsoft.identity.common.internal.result.ILocalAuthenticationResult;
import com.microsoft.identity.common.internal.result.LocalAuthenticationResult;
import com.microsoft.identity.common.internal.util.HeaderSerializationUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;

public class MsalBrokerResultAdapter
implements IBrokerResultAdapter {
    private static final String TAG = MsalBrokerResultAdapter.class.getName();

    @Override
    public Bundle bundleFromAuthenticationResult(@NonNull ILocalAuthenticationResult authenticationResult) {
        Logger.verbose(TAG, "Constructing result bundle from ILocalAuthenticationResult");
        IAccountRecord accountRecord = authenticationResult.getAccountRecord();
        AccessTokenRecord accessTokenRecord = authenticationResult.getAccessTokenRecord();
        BrokerResult brokerResult = new BrokerResult.Builder().accessToken(authenticationResult.getAccessToken()).idToken(authenticationResult.getIdToken()).refreshToken(authenticationResult.getRefreshToken()).homeAccountId(accountRecord.getHomeAccountId()).localAccountId(accountRecord.getLocalAccountId()).userName(accountRecord.getUsername()).tokenType(accessTokenRecord.getAccessTokenType()).clientId(accessTokenRecord.getClientId()).familyId(authenticationResult.getFamilyId()).scope(accessTokenRecord.getTarget()).clientInfo(accountRecord.getClientInfo()).authority(accessTokenRecord.getAuthority()).environment(accessTokenRecord.getEnvironment()).tenantId(authenticationResult.getTenantId()).expiresOn(Long.parseLong(accessTokenRecord.getExpiresOn())).extendedExpiresOn(Long.parseLong(accessTokenRecord.getExtendedExpiresOn())).cachedAt(Long.parseLong(accessTokenRecord.getCachedAt())).speRing(authenticationResult.getSpeRing()).refreshTokenAge(authenticationResult.getRefreshTokenAge()).success(true).build();
        Bundle resultBundle = new Bundle();
        resultBundle.putString("broker_result_v2", new Gson().toJson((Object)brokerResult, BrokerResult.class));
        resultBundle.putBoolean("broker_request_v2_success", true);
        return resultBundle;
    }

    @Override
    public Bundle bundleFromBaseException(@NonNull BaseException exception) {
        Logger.verbose(TAG, "Constructing result bundle from BaseException");
        BrokerResult.Builder builder = new BrokerResult.Builder().success(false).errorCode(exception.getErrorCode()).errorMessage(exception.getMessage()).correlationId(exception.getCorrelationId()).cliTelemErrorCode(exception.getCliTelemErrorCode()).cliTelemSubErrorCode(exception.getCliTelemSubErrorCode()).speRing(exception.getSpeRing()).refreshTokenAge(exception.getRefreshTokenAge());
        if (exception instanceof ServiceException) {
            builder.oauthSubErrorCode(((ServiceException)exception).getOAuthSubErrorCode()).httpStatusCode(((ServiceException)exception).getHttpStatusCode()).httpResponseHeaders(HeaderSerializationUtil.toJson(((ServiceException)exception).getHttpResponseHeaders())).httpResponseBody(new Gson().toJson(((ServiceException)exception).getHttpResponseBody()));
        }
        if (exception instanceof IntuneAppProtectionPolicyRequiredException) {
            builder.userName(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUpn()).localAccountId(((IntuneAppProtectionPolicyRequiredException)exception).getAccountUserId()).authority(((IntuneAppProtectionPolicyRequiredException)exception).getAuthorityUrl()).tenantId(((IntuneAppProtectionPolicyRequiredException)exception).getTenantId());
        }
        Bundle resultBundle = new Bundle();
        resultBundle.putString("broker_result_v2", new Gson().toJson((Object)builder.build(), BrokerResult.class));
        resultBundle.putBoolean("broker_request_v2_success", false);
        return resultBundle;
    }

    @Override
    public ILocalAuthenticationResult authenticationResultFromBundle(@NonNull Bundle resultBundle) {
        BrokerResult brokerResult = (BrokerResult)new Gson().fromJson(resultBundle.getString("broker_result_v2"), BrokerResult.class);
        if (brokerResult == null) {
            Logger.error(TAG, "Broker Result not returned from Broker, ", null);
            return null;
        }
        try {
            Logger.verbose(TAG, "Broker Result returned from Bundle, constructing authentication result");
            AccessTokenRecord accessTokenRecord = this.getAccessTokenRecord(brokerResult);
            IAccountRecord accountRecord = this.getAccountRecord(brokerResult);
            LocalAuthenticationResult authenticationResult = new LocalAuthenticationResult(accessTokenRecord, brokerResult.getRefreshToken(), brokerResult.getIdToken(), brokerResult.getFamilyId(), accountRecord);
            return authenticationResult;
        }
        catch (ServiceException e) {
            Logger.error(TAG, "Failed to parse Client Info ", e);
            return null;
        }
    }

    @Override
    public BaseException baseExceptionFromBundle(@NonNull Bundle resultBundle) {
        BaseException baseException;
        Logger.verbose(TAG, "Constructing exception from result bundle");
        BrokerResult brokerResult = (BrokerResult)new Gson().fromJson(resultBundle.getString("broker_result_v2"), BrokerResult.class);
        if (brokerResult == null) {
            Logger.error(TAG, "Broker Result not returned from Broker, ", null);
            return new BaseException("unknown_error", "Broker Result not returned from Broker");
        }
        String errorCode = brokerResult.getErrorCode();
        if ("interaction_required".equalsIgnoreCase(errorCode) || "invalid_grant".equalsIgnoreCase(errorCode)) {
            Logger.warn(TAG, "Received a UIRequired exception from Broker : " + errorCode);
            baseException = new UiRequiredException(errorCode, brokerResult.getErrorMessage());
        } else if ("unauthorized_client".equalsIgnoreCase(errorCode) && "protection_policy_required".equalsIgnoreCase(brokerResult.getSubErrorCode())) {
            Logger.warn(TAG, "Received a IntuneAppProtectionPolicyRequiredException exception from Broker : " + errorCode);
            baseException = this.getIntuneProtectionRequiredException(brokerResult);
        } else if ("User cancelled".equalsIgnoreCase(errorCode)) {
            Logger.warn(TAG, "Received a User cancelled exception from Broker : " + errorCode);
            baseException = new UserCancelException();
        } else if ("illegal_argument_exception".equalsIgnoreCase(errorCode)) {
            Logger.warn(TAG, "Received a Argument exception from Broker : " + errorCode);
            baseException = new ArgumentException("acquireToken", errorCode, brokerResult.getErrorMessage());
        } else if (!TextUtils.isEmpty((CharSequence)brokerResult.getHttpResponseHeaders()) || !TextUtils.isEmpty((CharSequence)brokerResult.getHttpResponseBody())) {
            Logger.warn(TAG, "Received a Service exception from Broker : " + errorCode);
            baseException = this.getServiceException(brokerResult);
        } else {
            Logger.warn(TAG, "Received a Client exception from Broker : " + errorCode);
            baseException = new ClientException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        }
        baseException.setCliTelemErrorCode(brokerResult.getCliTelemErrorCode());
        baseException.setCliTelemSubErrorCode(brokerResult.getCliTelemSubErrorCode());
        baseException.setCorrelationId(brokerResult.getCorrelationId());
        baseException.setSpeRing(brokerResult.getSpeRing());
        baseException.setRefreshTokenAge(brokerResult.getRefreshTokenAge());
        return baseException;
    }

    private AccessTokenRecord getAccessTokenRecord(@NonNull BrokerResult brokerResult) throws ServiceException {
        AccessTokenRecord accessTokenRecord = new AccessTokenRecord();
        try {
            ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
            accessTokenRecord.setHomeAccountId(SchemaUtil.getHomeAccountId(clientInfo));
            accessTokenRecord.setRealm(SchemaUtil.getTenantId(brokerResult.getClientInfo(), brokerResult.getIdToken()));
            URL authorityUrl = new URL(brokerResult.getAuthority());
            AzureActiveDirectoryCloud cloudEnv = AzureActiveDirectory.getAzureActiveDirectoryCloud(authorityUrl);
            if (cloudEnv != null) {
                Logger.info(TAG, "Using preferred cache host name...");
                accessTokenRecord.setEnvironment(cloudEnv.getPreferredCacheHostName());
            } else {
                accessTokenRecord.setEnvironment(authorityUrl.getHost());
            }
        }
        catch (MalformedURLException e) {
            Logger.error(TAG, "Malformed authority url ", e);
        }
        accessTokenRecord.setClientId(brokerResult.getClientId());
        accessTokenRecord.setSecret(brokerResult.getAccessToken());
        accessTokenRecord.setAccessTokenType(brokerResult.getTokenType());
        accessTokenRecord.setAuthority(brokerResult.getAuthority());
        accessTokenRecord.setTarget(brokerResult.getScope());
        accessTokenRecord.setCredentialType(CredentialType.AccessToken.name());
        accessTokenRecord.setExpiresOn(String.valueOf(brokerResult.getExpiresOn()));
        accessTokenRecord.setExtendedExpiresOn(String.valueOf(brokerResult.getExtendedExpiresOn()));
        accessTokenRecord.setCachedAt(String.valueOf(brokerResult.getCachedAt()));
        return accessTokenRecord;
    }

    private IAccountRecord getAccountRecord(@NonNull BrokerResult brokerResult) throws ServiceException {
        ClientInfo clientInfo = new ClientInfo(brokerResult.getClientInfo());
        MicrosoftStsAccount microsoftStsAccount = new MicrosoftStsAccount(new IDToken(brokerResult.getIdToken()), clientInfo);
        microsoftStsAccount.setEnvironment(brokerResult.getEnvironment());
        return new AccountRecord(microsoftStsAccount);
    }

    private IntuneAppProtectionPolicyRequiredException getIntuneProtectionRequiredException(@NonNull BrokerResult brokerResult) {
        IntuneAppProtectionPolicyRequiredException exception = new IntuneAppProtectionPolicyRequiredException(brokerResult.getErrorCode(), brokerResult.getErrorMessage());
        exception.setTenantId(brokerResult.getTenantId());
        exception.setAuthorityUrl(brokerResult.getAuthority());
        exception.setAccountUserId(brokerResult.getLocalAccountId());
        exception.setAccountUpn(brokerResult.getUserName());
        exception.setOauthSubErrorCode(brokerResult.getSubErrorCode());
        try {
            exception.setHttpResponseBody(HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()));
            if (brokerResult.getHttpResponseHeaders() != null) {
                exception.setHttpResponseHeaders(HeaderSerializationUtil.fromJson(brokerResult.getHttpResponseHeaders()));
            }
        }
        catch (JSONException e) {
            Logger.warn(TAG, "Unable to parse json");
        }
        return exception;
    }

    private ServiceException getServiceException(@NonNull BrokerResult brokerResult) {
        ServiceException serviceException = new ServiceException(brokerResult.getErrorCode(), brokerResult.getErrorMessage(), null);
        serviceException.setOauthSubErrorCode(brokerResult.getSubErrorCode());
        try {
            serviceException.setHttpResponseBody(brokerResult.getHttpResponseBody() != null ? HashMapExtensions.jsonStringAsMap(brokerResult.getHttpResponseBody()) : null);
            serviceException.setHttpResponseHeaders(brokerResult.getHttpResponseHeaders() != null ? HeaderSerializationUtil.fromJson(brokerResult.getHttpResponseHeaders()) : null);
        }
        catch (JSONException e) {
            Logger.warn(TAG, "Unable to parse json");
        }
        return serviceException;
    }

    public Bundle bundleFromAccountRecordList(@NonNull List<AccountRecord> records) {
        Bundle resultBundle = new Bundle();
        ArrayList<String> accountRecordString = new ArrayList<String>();
        for (AccountRecord record : records) {
            String recordInGson = new Gson().toJson((Object)record, AccountRecord.class);
            accountRecordString.add(recordInGson);
        }
        resultBundle.putStringArrayList("broker_accounts", accountRecordString);
        return resultBundle;
    }

    public static List<AccountRecord> getAccountRecordListFromBundle(@NonNull Bundle bundle) {
        ArrayList accountsList = bundle.getStringArrayList("broker_accounts");
        ArrayList<AccountRecord> result = new ArrayList<AccountRecord>();
        if (accountsList == null) {
            return null;
        }
        for (String accountJson : accountsList) {
            AccountRecord accountRecord = (AccountRecord)new Gson().fromJson(accountJson, AccountRecord.class);
            result.add(accountRecord);
        }
        return result;
    }
}

