/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ServiceException;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.JWTParser;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class IDToken {
    public static final String SUBJECT = "sub";
    public static final String NAME = "name";
    public static final String GIVEN_NAME = "given_name";
    public static final String FAMILY_NAME = "family_name";
    public static final String MIDDLE_NAME = "middle_name";
    public static final String NICKNAME = "nickname";
    public static final String PREFERRED_USERNAME = "preferred_username";
    public static final String PROFILE = "profile";
    public static final String PICTURE = "picture";
    public static final String WEBSITE = "website";
    public static final String EMAIL = "email";
    public static final String EMAIL_VERIFIED = "email_verified";
    public static final String GENDER = "gender";
    public static final String BIRTHDATE = "birthdate";
    public static final String ZONEINFO = "zoneinfo";
    public static final String LOCALE = "locale";
    public static final String PHONE_NUMBER = "phone_number";
    public static final String PHONE_NUMBER_VERIFIED = "phone_number_verified";
    public static final String ADDRESS = "address";
    public static final String UPDATED_AT = "updated_at";
    private Map<String, String> mTokenClaims = null;
    private final String mRawIdToken;

    public IDToken(String rawIdToken) throws ServiceException {
        if (StringExtensions.isNullOrBlank(rawIdToken)) {
            throw new IllegalArgumentException("null or empty raw idtoken");
        }
        this.mRawIdToken = rawIdToken;
        this.mTokenClaims = IDToken.parseJWT(rawIdToken);
    }

    public String getRawIDToken() {
        return this.mRawIdToken;
    }

    public Map<String, String> getTokenClaims() {
        return Collections.unmodifiableMap(this.mTokenClaims);
    }

    public static Map<String, String> parseJWT(String idToken) throws ServiceException {
        JWTClaimsSet claimsSet;
        try {
            JWT jwt = JWTParser.parse((String)idToken);
            claimsSet = jwt.getJWTClaimsSet();
        }
        catch (ParseException e) {
            throw new ServiceException("Failed to parse JWT", "invalid_jwt", e);
        }
        Map claimsMap = claimsSet.getClaims();
        HashMap<String, String> claimsMapStr = new HashMap<String, String>();
        for (Map.Entry entry : claimsMap.entrySet()) {
            claimsMapStr.put((String)entry.getKey(), entry.getValue().toString());
        }
        return claimsMapStr;
    }
}

