/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.oauth2;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.microsoft.identity.common.R;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.controllers.ApiDispatcher;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.webview.AzureActiveDirectoryWebViewClient;
import com.microsoft.identity.common.internal.ui.webview.challengehandlers.IAuthorizationCompletionCallback;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class AuthorizationActivity
extends Activity {
    @VisibleForTesting
    static final String KEY_AUTH_INTENT = "authIntent";
    @VisibleForTesting
    static final String KEY_BROWSER_FLOW_STARTED = "browserFlowStarted";
    @VisibleForTesting
    static final String KEY_PKEYAUTH_STATUS = "pkeyAuthStatus";
    @VisibleForTesting
    static final String KEY_AUTH_REQUEST_URL = "authRequestUrl";
    @VisibleForTesting
    static final String KEY_AUTH_REDIRECT_URI = "authRedirectUri";
    @VisibleForTesting
    static final String KEY_AUTH_AUTHORIZATION_AGENT = "authorizationAgent";
    @VisibleForTesting
    static final String KEY_REQUEST_HEADERS = "requestHeaders";
    public static final String CANCEL_INTERACTIVE_REQUEST_ACTION = "cancel_interactive_request_action";
    private static final String TAG = AuthorizationActivity.class.getSimpleName();
    private boolean mBrowserFlowStarted = false;
    private WebView mWebView;
    private Intent mAuthIntent;
    private boolean mPkeyAuthStatus = false;
    private String mAuthorizationRequestUrl;
    private String mRedirectUri;
    private HashMap<String, String> mRequestHeaders;
    private AuthorizationAgent mAuthorizationAgent;
    private BroadcastReceiver mCancelRequestReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            Logger.info(TAG, "Received Authorization flow cancel request from SDK");
            AuthorizationActivity.this.sendResult(2008, new Intent());
            AuthorizationActivity.this.finish();
        }
    };

    public static Intent createStartIntent(Context context, Intent authIntent, String requestUrl, String redirectUri, HashMap<String, String> requestHeaders, AuthorizationAgent authorizationAgent) {
        Intent intent = new Intent(context, AuthorizationActivity.class);
        intent.putExtra(KEY_AUTH_INTENT, (Parcelable)authIntent);
        intent.putExtra(KEY_AUTH_REQUEST_URL, requestUrl);
        intent.putExtra(KEY_AUTH_REDIRECT_URI, redirectUri);
        intent.putExtra(KEY_REQUEST_HEADERS, requestHeaders);
        intent.putExtra(KEY_AUTH_AUTHORIZATION_AGENT, (Serializable)((Object)authorizationAgent));
        intent.putExtra("correlation_id", (String)DiagnosticContext.getRequestContext().get("correlation_id"));
        return intent;
    }

    public static Intent createResultIntent(@NonNull String url) {
        Intent resultIntent = new Intent();
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(url);
        if (!StringExtensions.isNullOrBlank((String)parameters.get("error"))) {
            Logger.info(TAG, "Sending intent to cancel authentication activity");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", (String)parameters.get("error"));
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorSubCode", (String)parameters.get("error_subcode"));
            if (!StringUtil.isEmpty((String)parameters.get("error_description"))) {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get("error_description"));
            } else {
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", (String)parameters.get("error_subcode"));
            }
        } else {
            Logger.verbose(TAG, "It is pointing to redirect. Final url can be processed to get the code or error.");
            resultIntent.putExtra("com.microsoft.identity.client.final.url", url);
        }
        return resultIntent;
    }

    public static Intent createCustomTabResponseIntent(Context context, String responseUri) {
        Intent intent = new Intent(context, AuthorizationActivity.class);
        intent.putExtra("com.microsoft.identity.customtab.redirect", responseUri);
        intent.addFlags(0x24000000);
        return intent;
    }

    private void extractState(Bundle state) {
        if (state == null) {
            Logger.warn(TAG, "No stored state. Unable to handle response");
            this.finish();
            return;
        }
        AuthorizationActivity.setDiagnosticContextForNewThread(state.getString("correlation_id"));
        this.mAuthIntent = (Intent)state.getParcelable(KEY_AUTH_INTENT);
        this.mBrowserFlowStarted = state.getBoolean(KEY_BROWSER_FLOW_STARTED, false);
        this.mPkeyAuthStatus = state.getBoolean(KEY_PKEYAUTH_STATUS, false);
        this.mAuthorizationRequestUrl = state.getString(KEY_AUTH_REQUEST_URL);
        this.mRedirectUri = state.getString(KEY_AUTH_REDIRECT_URI);
        this.mRequestHeaders = this.getRequestHeaders(state);
        this.mAuthorizationAgent = (AuthorizationAgent)((Object)state.getSerializable(KEY_AUTH_AUTHORIZATION_AGENT));
    }

    private HashMap<String, String> getRequestHeaders(Bundle state) {
        try {
            return (HashMap)state.getSerializable(KEY_REQUEST_HEADERS);
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        String methodName = "#onCreate";
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.common_activity_authentication);
        this.registerReceiver(this.mCancelRequestReceiver, new IntentFilter(CANCEL_INTERACTIVE_REQUEST_ACTION));
        if (savedInstanceState == null) {
            Logger.verbose(TAG + "#onCreate", "Extract state from the intent bundle.");
            this.extractState(this.getIntent().getExtras());
        } else {
            Logger.verbose(TAG + "#onCreate", "Extract state from the saved bundle.");
            this.extractState(savedInstanceState);
        }
        if (this.mAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            AzureActiveDirectoryWebViewClient webViewClient = new AzureActiveDirectoryWebViewClient(this, new AuthorizationCompletionCallback(), this.mRedirectUri);
            this.setUpWebView(webViewClient);
            this.mWebView.post(new Runnable(){

                @Override
                public void run() {
                    AuthorizationActivity.this.mWebView.loadUrl("about:blank");
                    Logger.verbose(TAG + "#onCreate", "Launching embedded WebView for acquiring auth code.");
                    Logger.verbosePII(TAG + "#onCreate", "The start url is " + AuthorizationActivity.this.mAuthorizationRequestUrl);
                    AuthorizationActivity.this.mWebView.loadUrl(AuthorizationActivity.this.mAuthorizationRequestUrl, (Map)AuthorizationActivity.this.mRequestHeaders);
                }
            });
        }
    }

    public static String setDiagnosticContextForNewThread(String correlationId) {
        String methodName = ":setDiagnosticContextForAuthorizationActivity";
        RequestContext rc = new RequestContext();
        rc.put("correlation_id", correlationId);
        DiagnosticContext.setRequestContext(rc);
        Logger.verbose(TAG + ":setDiagnosticContextForAuthorizationActivity", "Initializing diagnostic context for AuthorizationActivity");
        return correlationId;
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
    }

    protected void onResume() {
        super.onResume();
        if (this.mAuthorizationAgent == AuthorizationAgent.DEFAULT || this.mAuthorizationAgent == AuthorizationAgent.BROWSER) {
            if (!this.mBrowserFlowStarted) {
                this.mBrowserFlowStarted = true;
                if (this.mAuthIntent != null) {
                    this.startActivity(this.mAuthIntent);
                } else {
                    Intent resultIntent = new Intent();
                    resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)new ClientException("Authorization intent is null."));
                    this.sendResult(2005, resultIntent);
                    this.finish();
                }
            } else if (!StringUtil.isEmpty(this.getIntent().getStringExtra("com.microsoft.identity.customtab.redirect"))) {
                this.completeAuthorization();
            } else {
                this.cancelAuthorization();
            }
        }
    }

    protected void onDestroy() {
        String methodName = "#onDestroy";
        Logger.verbose(TAG + "#onDestroy", "");
        this.unregisterReceiver(this.mCancelRequestReceiver);
        super.onDestroy();
    }

    private void sendResult(int resultCode, Intent resultIntent) {
        ApiDispatcher.completeInteractive(1001, resultCode, resultIntent);
    }

    private void completeAuthorization() {
        Logger.info(TAG, null, "Received redirect from customTab/browser.");
        String url = this.getIntent().getExtras().getString("com.microsoft.identity.customtab.redirect");
        Intent resultIntent = AuthorizationActivity.createResultIntent(url);
        if (!StringUtil.isEmpty(resultIntent.getStringExtra("com.microsoft.identity.client.final.url"))) {
            this.sendResult(2003, resultIntent);
        } else if (!StringUtil.isEmpty(resultIntent.getStringExtra("com.microsoft.aad.adal:BrowserErrorSubCode")) && resultIntent.getStringExtra("com.microsoft.aad.adal:BrowserErrorSubCode").equalsIgnoreCase("cancel")) {
            this.sendResult(2008, resultIntent);
        } else {
            this.sendResult(2002, resultIntent);
        }
        this.finish();
    }

    private void cancelAuthorization() {
        Logger.info(TAG, "Authorization flow is canceled by user");
        Intent resultIntent = new Intent();
        resultIntent.setFlags(0x4000000);
        this.sendResult(2001, resultIntent);
        this.finish();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putParcelable(KEY_AUTH_INTENT, (Parcelable)this.mAuthIntent);
        outState.putBoolean(KEY_BROWSER_FLOW_STARTED, this.mBrowserFlowStarted);
        outState.putBoolean(KEY_PKEYAUTH_STATUS, this.mPkeyAuthStatus);
        outState.putSerializable(KEY_AUTH_AUTHORIZATION_AGENT, (Serializable)((Object)this.mAuthorizationAgent));
        outState.putString(KEY_AUTH_REDIRECT_URI, this.mRedirectUri);
        outState.putString(KEY_AUTH_REQUEST_URL, this.mAuthorizationRequestUrl);
    }

    public void onBackPressed() {
        Logger.verbose(TAG, "Back button is pressed");
        if (null != this.mWebView && this.mWebView.canGoBack()) {
            int BACK_PRESSED_STEPS = -2;
            if (!this.mWebView.canGoBackOrForward(-2)) {
                this.cancelAuthorization();
            } else {
                this.mWebView.goBack();
            }
            return;
        }
        super.onBackPressed();
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
    private void setUpWebView(AzureActiveDirectoryWebViewClient webViewClient) {
        this.mWebView = (WebView)this.findViewById(R.id.common_auth_webview);
        WebSettings userAgentSetting = this.mWebView.getSettings();
        String userAgent = userAgentSetting.getUserAgentString();
        this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.setVisibility(4);
        this.mWebView.setWebViewClient((WebViewClient)webViewClient);
    }

    class AuthorizationCompletionCallback
    implements IAuthorizationCompletionCallback {
        AuthorizationCompletionCallback() {
        }

        @Override
        public void onChallengeResponseReceived(int returnCode, Intent responseIntent) {
            Logger.verbose(TAG, null, "onChallengeResponseReceived:" + returnCode);
            AuthorizationActivity.this.sendResult(returnCode, responseIntent);
            AuthorizationActivity.this.finish();
        }

        @Override
        public void setPKeyAuthStatus(boolean status) {
            AuthorizationActivity.this.mPkeyAuthStatus = status;
            Logger.verbose(TAG, null, "setPKeyAuthStatus:" + status);
        }
    }
}

