/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.net.cache;

import android.net.http.HttpResponseCache;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.microsoft.identity.common.internal.logging.Logger;
import java.io.File;
import java.io.IOException;

public class HttpCache {
    private static final String TAG = HttpCache.class.getSimpleName();
    public static final String DEFAULT_HTTP_CACHE_NAME = "com.microsoft.identity.http-cache";
    public static final long DEFAULT_HTTP_CACHE_CAPACITY_BYTES = 0xA00000L;

    public static boolean initialize(@NonNull File cacheDirectory, @NonNull String cacheFileName, long maxSizeBytes) {
        String methodName = ":initialize (File, Filename, Capacity)";
        boolean success = false;
        try {
            File httpCacheDir = new File(cacheDirectory, cacheFileName);
            HttpResponseCache.install((File)httpCacheDir, (long)maxSizeBytes);
            success = true;
        }
        catch (IOException e) {
            Logger.error(TAG + ":initialize (File, Filename, Capacity)", "HTTP Response cache installation failed.", e);
        }
        return success;
    }

    public static boolean initialize(@NonNull File cacheDirectory) {
        return HttpCache.initialize(cacheDirectory, DEFAULT_HTTP_CACHE_NAME, 0xA00000L);
    }

    @Nullable
    public static HttpResponseCache getInstalled() {
        return HttpResponseCache.getInstalled();
    }

    public static void flush() {
        String methodName = ":flush";
        HttpResponseCache responseCache = HttpCache.getInstalled();
        if (null != responseCache) {
            responseCache.flush();
        } else {
            Logger.warn(TAG + ":flush", "Unable to flush cache because none is installed.");
        }
    }
}

