/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.cache;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.microsoft.identity.common.internal.cache.BrokerApplicationMetadata;
import com.microsoft.identity.common.internal.cache.IBrokerApplicationMetadataCache;
import com.microsoft.identity.common.internal.logging.Logger;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SharedPreferencesBrokerApplicationMetadataCache
implements IBrokerApplicationMetadataCache {
    private static final String TAG = SharedPreferencesBrokerApplicationMetadataCache.class.getSimpleName();
    private static final String DEFAULT_APP_METADATA_CACHE_NAME = "com.microsoft.identity.app-meta-cache";
    private static final String KEY_CACHE_LIST = "app-meta-cache";
    private static final String EMPTY_ARRAY = "[]";
    private final SharedPreferences mSharedPrefs;
    private final Gson mGson = new Gson();

    public SharedPreferencesBrokerApplicationMetadataCache(@NonNull Context context) {
        Logger.verbose(TAG + "::ctor", "Init");
        this.mSharedPrefs = context.getSharedPreferences(DEFAULT_APP_METADATA_CACHE_NAME, 0);
    }

    @Override
    public Set<String> getAllClientIds() {
        String methodName = ":getAllClientIds";
        HashSet<String> allClientIds = new HashSet<String>();
        for (BrokerApplicationMetadata metadata : this.getAll()) {
            allClientIds.add(metadata.getClientId());
        }
        Logger.verbose(TAG + ":getAllClientIds", "Found [" + allClientIds.size() + "] client ids.");
        return allClientIds;
    }

    @Override
    public Set<String> getAllFociClientIds() {
        return this.getAllFociClientIds(false);
    }

    @Override
    public Set<String> getAllNonFociClientIds() {
        return this.getAllFociClientIds(true);
    }

    @Override
    public List<BrokerApplicationMetadata> getAllFociApplicationMetadata() {
        Set<String> fociClientIds = this.getAllFociClientIds();
        ArrayList<BrokerApplicationMetadata> result = new ArrayList<BrokerApplicationMetadata>();
        List<BrokerApplicationMetadata> allMetadata = this.getAll();
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!fociClientIds.contains(metadata.getClientId())) continue;
            result.add(metadata);
        }
        return result;
    }

    private Set<String> getAllFociClientIds(boolean inverseMatch) {
        String methodName = ":getAllFociClientIds";
        HashSet<String> allFociClientIds = new HashSet<String>();
        for (BrokerApplicationMetadata metadata : this.getAll()) {
            if (!inverseMatch) {
                if (TextUtils.isEmpty((CharSequence)metadata.getFoci())) continue;
                allFociClientIds.add(metadata.getClientId());
                continue;
            }
            if (!TextUtils.isEmpty((CharSequence)metadata.getFoci())) continue;
            allFociClientIds.add(metadata.getClientId());
        }
        Logger.verbose(TAG + ":getAllFociClientIds", "Found [" + allFociClientIds.size() + "] client ids.");
        return allFociClientIds;
    }

    @Override
    @Nullable
    public BrokerApplicationMetadata getMetadata(@NonNull String clientId, @NonNull String environment, int processUid) {
        String methodName = ":getMetadata";
        List<BrokerApplicationMetadata> allMetadata = this.getAll();
        BrokerApplicationMetadata result = null;
        for (BrokerApplicationMetadata metadata : allMetadata) {
            if (!clientId.equals(metadata.getClientId()) || !environment.equals(metadata.getEnvironment()) || processUid != metadata.getUid()) continue;
            Logger.verbose(TAG + metadata, "Metadata located.");
            result = metadata;
            break;
        }
        if (null == result) {
            Logger.warn(TAG + ":getMetadata", "Metadata could not be found for clientId, environment: [" + clientId + ", " + environment + "]");
        }
        return result;
    }

    @Override
    public synchronized boolean insert(@NonNull BrokerApplicationMetadata metadata) {
        String methodName = ":insert";
        HashSet<BrokerApplicationMetadata> allMetadata = new HashSet<BrokerApplicationMetadata>(this.getAll());
        Logger.verbose(TAG + ":insert", "Existing metadata contained [" + allMetadata.size() + "] elements.");
        allMetadata.add(metadata);
        Logger.verbose(TAG + ":insert", "New metadata set size: [" + allMetadata.size() + "]");
        String json = this.mGson.toJson(allMetadata);
        Logger.verbose(TAG + ":insert", "Writing cache entry.");
        boolean success = this.mSharedPrefs.edit().putString(KEY_CACHE_LIST, json).commit();
        if (success) {
            Logger.verbose(TAG + ":insert", "Cache successfully updated.");
        } else {
            Logger.warn(TAG + ":insert", "Error writing to cache.");
        }
        return success;
    }

    @Override
    public synchronized boolean remove(@NonNull BrokerApplicationMetadata metadata) {
        String methodName = ":remove";
        HashSet<BrokerApplicationMetadata> allMetadata = new HashSet<BrokerApplicationMetadata>(this.getAll());
        Logger.verbose(TAG + ":remove", "Existing metadata contained [" + allMetadata.size() + "] elements.");
        boolean removed = allMetadata.remove(metadata);
        Logger.verbose(TAG + ":remove", "New metadata set size: [" + allMetadata.size() + "]");
        if (!removed) {
            Logger.warn(TAG + ":remove", "Nothing to delete -- cache entry is missing!");
            return true;
        }
        String json = this.mGson.toJson(allMetadata);
        Logger.verbose(TAG + ":remove", "Writing new cache values...");
        boolean written = this.mSharedPrefs.edit().putString(KEY_CACHE_LIST, json).commit();
        Logger.verbose(TAG + ":remove", "Updated cache contents written? [" + written + "]");
        return written;
    }

    @Override
    public synchronized List<BrokerApplicationMetadata> getAll() {
        String methodName = ":getAll";
        String jsonList = this.mSharedPrefs.getString(KEY_CACHE_LIST, EMPTY_ARRAY);
        Type listType = new TypeToken<List<BrokerApplicationMetadata>>(){}.getType();
        List result = (List)this.mGson.fromJson(jsonList, listType);
        Logger.verbose(TAG + ":getAll", "Found [" + result.size() + "] cache entries.");
        return result;
    }

    @Override
    public synchronized boolean clear() {
        String methodName = ":clear";
        boolean cleared = this.mSharedPrefs.edit().clear().commit();
        if (!cleared) {
            Logger.warn(TAG + ":clear", "Failed to clear cache.");
        } else {
            Logger.verbose(TAG + ":clear", "Cache successfully cleared.");
        }
        return cleared;
    }
}

