/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.authorities;

import com.google.gson.annotations.SerializedName;
import com.microsoft.identity.common.internal.authorities.AccountsInOneOrganization;
import com.microsoft.identity.common.internal.authorities.AllAccounts;
import com.microsoft.identity.common.internal.authorities.AnyOrganizationalAccount;
import com.microsoft.identity.common.internal.authorities.AnyPersonalAccount;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;

public abstract class AzureActiveDirectoryAudience {
    private static final String TAG = AzureActiveDirectoryAudience.class.getSimpleName();
    private String mCloudUrl;
    @SerializedName(value="tenant_id")
    private String mTenantId;
    public static final String ORGANIZATIONS = "organizations";
    public static final String CONSUMERS = "consumers";
    public static final String ALL = "common";
    public static final String MSA_MEGA_TENANT_ID = "9188040d-6c67-4c5b-b112-36a304b66dad";

    public String getCloudUrl() {
        if (this.mCloudUrl == null) {
            return AzureActiveDirectory.getDefaultCloudUrl();
        }
        return this.mCloudUrl;
    }

    public void setCloudUrl(String cloudUrl) {
        this.mCloudUrl = cloudUrl;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public void setTenantId(String tenantId) {
        this.mTenantId = tenantId;
    }

    public static AzureActiveDirectoryAudience getAzureActiveDirectoryAudience(String cloudUrl, String tenantId) {
        String methodName = ":getAzureActiveDirectoryAudience";
        AzureActiveDirectoryAudience audience = null;
        switch (tenantId.toLowerCase()) {
            case "organizations": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AnyOrganizationalAccount");
                audience = new AnyOrganizationalAccount(cloudUrl);
                break;
            }
            case "consumers": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AnyPersonalAccount");
                audience = new AnyPersonalAccount();
                break;
            }
            case "common": {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AllAccounts");
                audience = new AllAccounts();
                break;
            }
            default: {
                Logger.verbose(TAG + ":getAzureActiveDirectoryAudience", "Audience: AccountsInOneOrganization");
                audience = new AccountsInOneOrganization(cloudUrl, tenantId);
            }
        }
        return audience;
    }
}

