/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.platform;

import android.os.Build;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class Device {
    private Device() {
    }

    public static Map<String, String> getPlatformIdParameters() {
        HashMap<String, String> platformParameters = new HashMap<String, String>();
        platformParameters.put("x-client-SKU", "MSAL.Android");
        platformParameters.put("x-client-Ver", "0.3.1");
        if (Build.VERSION.SDK_INT < 21) {
            platformParameters.put("x-client-CPU", Build.CPU_ABI);
        } else {
            String[] supportedABIs = Build.SUPPORTED_ABIS;
            if (supportedABIs != null && supportedABIs.length > 0) {
                platformParameters.put("x-client-CPU", supportedABIs[0]);
            }
        }
        platformParameters.put("x-client-OS", String.valueOf(Build.VERSION.SDK_INT));
        platformParameters.put("x-client-DM", Build.MODEL);
        return Collections.unmodifiableMap(platformParameters);
    }

    public static final class PlatformIdParameters {
        public static final String PRODUCT = "x-client-SKU";
        public static final String PRODUCT_NAME = "MSAL.Android";
        public static final String PRODUCT_VERSION = "0.3.1";
        public static final String VERSION = "x-client-Ver";
        public static final String CPU_PLATFORM = "x-client-CPU";
        public static final String OS = "x-client-OS";
        public static final String DEVICE_MODEL = "x-client-DM";
        public static final String BROKER_VERSION = "x-client-brkrver";
    }
}

