/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui.browser;

import android.app.Activity;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.NonNull;
import com.microsoft.identity.common.exception.ClientException;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationActivity;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationRequest;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResult;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationResultFuture;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.providers.oauth2.OAuth2Strategy;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.Browser;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.ui.browser.CustomTabsManager;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.util.concurrent.Future;

public class BrowserAuthorizationStrategy<GenericOAuth2Strategy extends OAuth2Strategy, GenericAuthorizationRequest extends AuthorizationRequest>
extends AuthorizationStrategy<GenericOAuth2Strategy, GenericAuthorizationRequest> {
    private static final String TAG = BrowserAuthorizationStrategy.class.getSimpleName();
    private CustomTabsManager mCustomTabManager;
    private WeakReference<Activity> mReferencedActivity;
    private PendingIntent mResultIntent;
    private AuthorizationResultFuture mAuthorizationResultFuture;
    private boolean mDisposed;
    private GenericOAuth2Strategy mOAuth2Strategy;
    private GenericAuthorizationRequest mAuthorizationRequest;

    public BrowserAuthorizationStrategy(@NonNull Activity activity, @NonNull Intent resultIntent) {
        this.mReferencedActivity = new WeakReference<Activity>(activity);
        this.mResultIntent = PendingIntent.getActivity((Context)activity.getApplicationContext(), (int)0, (Intent)resultIntent, (int)0x8000000);
    }

    @Override
    public Future<AuthorizationResult> requestAuthorization(GenericAuthorizationRequest authorizationRequest, GenericOAuth2Strategy oAuth2Strategy) throws ClientException, UnsupportedEncodingException {
        Intent authIntent;
        String methodName = ":requestAuthorization";
        this.checkNotDisposed();
        this.mOAuth2Strategy = oAuth2Strategy;
        this.mAuthorizationRequest = authorizationRequest;
        this.mAuthorizationResultFuture = new AuthorizationResultFuture();
        Browser browser = BrowserSelector.select(((Activity)this.mReferencedActivity.get()).getApplicationContext());
        if (browser.isCustomTabsServiceSupported()) {
            Logger.info(TAG + ":requestAuthorization", "CustomTabsService is supported.");
            this.mCustomTabManager = new CustomTabsManager(((Activity)this.mReferencedActivity.get()).getApplicationContext());
            this.mCustomTabManager.bind(browser.getPackageName());
            authIntent = this.mCustomTabManager.getCustomTabsIntent().intent;
        } else {
            Logger.warn(TAG + ":requestAuthorization", "CustomTabsService is NOT supported");
            authIntent = new Intent("android.intent.action.VIEW");
        }
        authIntent.setPackage(browser.getPackageName());
        Uri requestUrl = ((AuthorizationRequest)authorizationRequest).getAuthorizationRequestAsHttpRequest();
        authIntent.setData(requestUrl);
        Intent intent = AuthorizationActivity.createStartIntent(((Activity)this.mReferencedActivity.get()).getApplicationContext(), authIntent, this.mResultIntent, requestUrl.toString(), ((AuthorizationRequest)this.mAuthorizationRequest).getRedirectUri(), ((AuthorizationRequest)this.mAuthorizationRequest).getRequestHeaders(), AuthorizationAgent.BROWSER);
        intent.setFlags(0x10000000);
        ((Activity)this.mReferencedActivity.get()).startActivity(intent);
        return this.mAuthorizationResultFuture;
    }

    private void checkNotDisposed() {
        if (this.mDisposed) {
            throw new IllegalStateException("Service has been disposed and rendered inoperable");
        }
    }

    @Override
    public void completeAuthorization(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            this.dispose();
            Object result = ((OAuth2Strategy)this.mOAuth2Strategy).getAuthorizationResultFactory().createAuthorizationResult(resultCode, data, this.mAuthorizationRequest);
            this.mAuthorizationResultFuture.setAuthorizationResult((AuthorizationResult)result);
        } else {
            Logger.warnPII(TAG, "Unknown request code " + requestCode);
        }
    }

    public void dispose() {
        if (this.mDisposed) {
            return;
        }
        if (this.mCustomTabManager != null) {
            this.mCustomTabManager.unbind();
        }
        this.mDisposed = true;
    }
}

