/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.ui;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.annotation.NonNull;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.oauth2.AuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.ui.browser.BrowserAuthorizationStrategy;
import com.microsoft.identity.common.internal.ui.browser.BrowserSelector;
import com.microsoft.identity.common.internal.ui.webview.EmbeddedWebViewAuthorizationStrategy;

public class AuthorizationStrategyFactory<GenericAuthorizationStrategy extends AuthorizationStrategy> {
    private static final String TAG = AuthorizationStrategyFactory.class.getSimpleName();
    private static AuthorizationStrategyFactory sInstance = null;

    public static AuthorizationStrategyFactory getInstance() {
        if (sInstance == null) {
            sInstance = new AuthorizationStrategyFactory();
        }
        return sInstance;
    }

    public GenericAuthorizationStrategy getAuthorizationStrategy(Activity activity, @NonNull AuthorizationAgent authorizationAgent, @NonNull Intent resultIntent) {
        AuthorizationAgent validatedAuthorizationAgent = this.validAuthorizationAgent(authorizationAgent, activity.getApplicationContext());
        if (validatedAuthorizationAgent == AuthorizationAgent.WEBVIEW) {
            Logger.info(TAG, "Use webView for authorization.");
            return (GenericAuthorizationStrategy)new EmbeddedWebViewAuthorizationStrategy(activity, resultIntent);
        }
        Logger.info(TAG, "Use browser for authorization.");
        return (GenericAuthorizationStrategy)new BrowserAuthorizationStrategy(activity, resultIntent);
    }

    private AuthorizationAgent validAuthorizationAgent(AuthorizationAgent agent, Context context) {
        if (agent != AuthorizationAgent.WEBVIEW && BrowserSelector.getAllBrowsers(context).isEmpty()) {
            Logger.verbose(TAG, "Unable to use browser to do the authorization because No available browser installed on the device. Use embedded webView instead.");
            return AuthorizationAgent.WEBVIEW;
        }
        return agent;
    }
}

