/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.accounts.Account;
import android.text.TextUtils;
import android.util.Pair;
import com.microsoft.identity.common.exception.ArgumentException;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.cache.BrokerOAuth2TokenCache;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenOperationParameters;
import java.util.List;

public class BrokerAcquireTokenSilentOperationParameters
extends AcquireTokenSilentOperationParameters {
    private Account mAccountManagerAccount;
    private String mCallerPackageName;
    private int mCallerUId;
    private String mCallerAppVersion;
    private String mHomeAccountId;
    private String mLocalAccountId;
    private String mLoginHint;
    private String mCorrelationId;
    private List<Pair<String, String>> mExtraQueryStringParameters;
    private int mSleepTimeBeforePrtAcquisition;

    public Account getAccountManagerAccount() {
        return this.mAccountManagerAccount;
    }

    public void setAccountManagerAccount(Account accountManagerAccount) {
        this.mAccountManagerAccount = accountManagerAccount;
    }

    public String getCallerPackageName() {
        return this.mCallerPackageName;
    }

    public void setCallerPackageName(String callerPackageName) {
        this.mCallerPackageName = callerPackageName;
    }

    public int getCallerUId() {
        return this.mCallerUId;
    }

    public String getCallerAppVersion() {
        return this.mCallerAppVersion;
    }

    public void setCallerAppVersion(String callerAppVersion) {
        this.mCallerAppVersion = callerAppVersion;
    }

    public void setCallerUId(int callerUId) {
        this.mCallerUId = callerUId;
    }

    public String getHomeAccountId() {
        return this.mHomeAccountId;
    }

    public void setHomeAccountId(String homeAccountId) {
        this.mHomeAccountId = homeAccountId;
    }

    public String getLocalAccountId() {
        return this.mLocalAccountId;
    }

    public void setLocalAccountId(String localAccountId) {
        this.mLocalAccountId = localAccountId;
    }

    public String getLoginHint() {
        return this.mLoginHint;
    }

    public void setLoginHint(String loginHint) {
        this.mLoginHint = loginHint;
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    public void setCorrelationId(String correlationId) {
        this.mCorrelationId = correlationId;
    }

    public List<Pair<String, String>> getExtraQueryStringParameters() {
        return this.mExtraQueryStringParameters;
    }

    public void setExtraQueryStringParameters(List<Pair<String, String>> mExtraQueryStringParameters) {
        this.mExtraQueryStringParameters = mExtraQueryStringParameters;
    }

    public int getSleepTimeBeforePrtAcquisition() {
        return this.mSleepTimeBeforePrtAcquisition;
    }

    public void setSleepTimeBeforePrtAcquisition(int sleepTimeBeforePrtAcquisition) {
        this.mSleepTimeBeforePrtAcquisition = sleepTimeBeforePrtAcquisition;
    }

    public BrokerAcquireTokenSilentOperationParameters() {
    }

    public BrokerAcquireTokenSilentOperationParameters(BrokerAcquireTokenOperationParameters acquireTokenOperationParameters) {
        this.setAppContext(acquireTokenOperationParameters.getAppContext());
        this.setTokenCache(acquireTokenOperationParameters.getTokenCache());
        this.setScopes(acquireTokenOperationParameters.getScopes());
        this.setClientId(acquireTokenOperationParameters.getClientId());
        this.setRedirectUri(acquireTokenOperationParameters.getRedirectUri());
        this.setAuthority(acquireTokenOperationParameters.getAuthority());
        this.setClaimsRequest(acquireTokenOperationParameters.getClaimsRequestJson());
        this.setCallerAppVersion(acquireTokenOperationParameters.getCallerAppVersion());
        this.setCallerPackageName(acquireTokenOperationParameters.getCallerPackageName());
        this.setCallerUId(acquireTokenOperationParameters.getCallerUId());
        this.setCorrelationId(acquireTokenOperationParameters.getCorrelationId());
        this.setLoginHint(acquireTokenOperationParameters.getLoginHint());
        this.setSdkType(acquireTokenOperationParameters.getSdkType());
        this.setExtraQueryStringParameters(acquireTokenOperationParameters.getExtraQueryStringParameters());
    }

    @Override
    public void validate() throws ArgumentException {
        if (this.mCallerUId == 0) {
            throw new ArgumentException("acquireTokenSilent", "mCallerUId", "Caller Uid is not set");
        }
        if (TextUtils.isEmpty((CharSequence)this.mCallerPackageName)) {
            throw new ArgumentException("acquireTokenSilent", "mCallerPackageName", "Caller package name is not set");
        }
        if (this.getAuthority() == null) {
            throw new ArgumentException("acquireTokenSilent", "mAuthority", "Authority Url is not set");
        }
        if (this.getScopes() == null || this.getScopes().isEmpty()) {
            throw new ArgumentException("acquireTokenSilent", "mScopes", "Scope or resource is not set");
        }
        if (TextUtils.isEmpty((CharSequence)this.getClientId())) {
            throw new ArgumentException("acquireTokenSilent", "mClientId", "Client Id is not set");
        }
        if (TextUtils.isEmpty((CharSequence)this.mCallerPackageName)) {
            throw new ArgumentException("acquireTokenSilent", "mCallerPackageName", "Caller package name is not set");
        }
        if (!BrokerValidator.isValidBrokerRedirect(this.getRedirectUri(), this.getAppContext(), this.getCallerPackageName())) {
            throw new ArgumentException("acquireTokenSilent", "mRedirectUri", "The redirect URI doesn't match the uri generated with caller package name and signature");
        }
        if (!(this.getTokenCache() instanceof BrokerOAuth2TokenCache)) {
            throw new ArgumentException("acquireTokenSilent", "AcquireTokenSilentOperationParameters", "OAuth2Cache not an instance of BrokerOAuth2TokenCache");
        }
        if (null == this.mAccountManagerAccount) {
            throw new ArgumentException("acquireTokenSilent", "mCallerPackageName", "Android Account manager Account is null");
        }
    }
}

