/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.request;

import android.accounts.Account;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Pair;
import com.microsoft.identity.common.internal.authorities.Authority;
import com.microsoft.identity.common.internal.authorities.AzureActiveDirectoryAuthority;
import com.microsoft.identity.common.internal.broker.BrokerRequest;
import com.microsoft.identity.common.internal.broker.BrokerValidator;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.migration.TokenCacheItemMigrationAdapter;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectorySlice;
import com.microsoft.identity.common.internal.providers.oauth2.OpenIdConnectPromptParameter;
import com.microsoft.identity.common.internal.request.AcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.AcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenOperationParameters;
import com.microsoft.identity.common.internal.request.BrokerAcquireTokenSilentOperationParameters;
import com.microsoft.identity.common.internal.request.IBrokerRequestAdapter;
import com.microsoft.identity.common.internal.request.SdkType;
import com.microsoft.identity.common.internal.result.AdalBrokerResultAdapter;
import com.microsoft.identity.common.internal.ui.AuthorizationAgent;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;

public class AdalBrokerRequestAdapter
implements IBrokerRequestAdapter {
    private static final String TAG = AdalBrokerResultAdapter.class.getName();

    @Override
    public BrokerRequest brokerRequestFromAcquireTokenParameters(AcquireTokenOperationParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrokerRequest brokerRequestFromSilentOperationParameters(AcquireTokenSilentOperationParameters parameters) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BrokerAcquireTokenOperationParameters brokerInteractiveParametersFromActivity(@NonNull Activity callingActivity) {
        BrokerAcquireTokenOperationParameters parameters = new BrokerAcquireTokenOperationParameters();
        Intent intent = callingActivity.getIntent();
        parameters.setActivity(callingActivity);
        parameters.setAppContext(callingActivity.getApplicationContext());
        parameters.setSdkType(SdkType.ADAL);
        int callingAppUid = intent.getIntExtra("caller.info.uid", 0);
        parameters.setCallerUId(callingAppUid);
        parameters.setCallerPackageName(this.getPackageNameFromBundle(intent.getExtras(), callingActivity.getApplicationContext()));
        parameters.setCallerAppVersion(intent.getStringExtra("x-app-ver"));
        List<Pair<String, String>> extraQP = this.getExtraQueryParamAsList(intent.getStringExtra("account.extra.query.param"));
        parameters.setAuthority(AdalBrokerRequestAdapter.getRequestAuthorityWithExtraQP(intent.getStringExtra("account.authority"), extraQP));
        parameters.setExtraQueryStringParameters(extraQP);
        String resource = intent.getStringExtra("account.resource");
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(TokenCacheItemMigrationAdapter.getScopeFromResource(resource));
        parameters.setScopes(scopes);
        parameters.setClientId(intent.getStringExtra("account.clientid.key"));
        parameters.setRedirectUri(intent.getStringExtra("account.redirect"));
        parameters.setLoginHint(intent.getStringExtra("account.name"));
        String correlationIdString = intent.getStringExtra("account.correlationid");
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        parameters.setCorrelationId(correlationIdString);
        parameters.setClaimsRequest(intent.getStringExtra("account.claims"));
        parameters.setOpenIdConnectPromptParameter(OpenIdConnectPromptParameter._fromPromptBehavior(intent.getStringExtra("account.prompt")));
        parameters.setAuthorizationAgent(AuthorizationAgent.WEBVIEW);
        return parameters;
    }

    @Override
    public BrokerAcquireTokenSilentOperationParameters brokerSilentParametersFromBundle(Bundle bundle, Context context, Account account) {
        BrokerAcquireTokenSilentOperationParameters parameters = new BrokerAcquireTokenSilentOperationParameters();
        parameters.setAppContext(context);
        parameters.setAccountManagerAccount(account);
        parameters.setSdkType(SdkType.ADAL);
        int callingAppUid = bundle.getInt("caller.info.uid");
        parameters.setCallerUId(callingAppUid);
        String packageName = this.getPackageNameFromBundle(bundle, context);
        parameters.setCallerPackageName(packageName);
        parameters.setCallerAppVersion(bundle.getString("x-app-ver"));
        Authority authority = Authority.getAuthorityFromAuthorityUrl(bundle.getString("account.authority"));
        parameters.setAuthority(authority);
        String correlationIdString = bundle.getString("account.correlationid");
        if (TextUtils.isEmpty((CharSequence)correlationIdString)) {
            UUID correlationId = UUID.randomUUID();
            correlationIdString = correlationId.toString();
        }
        parameters.setCorrelationId(correlationIdString);
        String resource = bundle.getString("account.resource");
        HashSet<String> scopes = new HashSet<String>();
        scopes.add(TokenCacheItemMigrationAdapter.getScopeFromResource(resource));
        parameters.setScopes(scopes);
        String clientId = bundle.getString("account.clientid.key");
        parameters.setClientId(clientId);
        String redirectUri = bundle.getString("account.redirect");
        if (TextUtils.isEmpty((CharSequence)redirectUri)) {
            redirectUri = BrokerValidator.getBrokerRedirectUri(context, packageName);
        }
        parameters.setRedirectUri(redirectUri);
        parameters.setForceRefresh(Boolean.parseBoolean(bundle.getString("force.refresh")));
        parameters.setClaimsRequest(bundle.getString("account.claims"));
        parameters.setLoginHint(bundle.getString("account.name"));
        List<Pair<String, String>> extraQP = this.getExtraQueryParamAsList(bundle.getString("account.extra.query.param"));
        parameters.setExtraQueryStringParameters(extraQP);
        return parameters;
    }

    private String getPackageNameFromBundle(Bundle bundle, Context context) {
        String packageName = bundle.getString("caller.info.package");
        if (TextUtils.isEmpty((CharSequence)packageName) && TextUtils.isEmpty((CharSequence)(packageName = bundle.getString("x-app-name")))) {
            packageName = context.getPackageName();
        }
        return packageName;
    }

    private List<Pair<String, String>> getExtraQueryParamAsList(@Nullable String extraQueryParamString) {
        ArrayList<Pair<String, String>> extraQPList = new ArrayList<Pair<String, String>>();
        if (!StringUtil.isEmpty(extraQueryParamString)) {
            String[] extraQueryParams;
            for (String param : extraQueryParams = extraQueryParamString.split("&")) {
                if (StringUtil.isEmpty(param)) continue;
                String[] split = param.split("=");
                String name = split[0];
                String value = split.length > 1 ? split[1] : null;
                Pair extraQPPair = new Pair((Object)name, (Object)value);
                extraQPList.add((Pair<String, String>)extraQPPair);
            }
        }
        return extraQPList;
    }

    public static AzureActiveDirectoryAuthority getRequestAuthorityWithExtraQP(String authority, List<Pair<String, String>> extraQP) {
        AzureActiveDirectoryAuthority requestAuthority = (AzureActiveDirectoryAuthority)Authority.getAuthorityFromAuthorityUrl(authority);
        if (extraQP != null) {
            AzureActiveDirectorySlice slice = new AzureActiveDirectorySlice();
            ArrayList<Pair<String, String>> extraQPListCopy = new ArrayList<Pair<String, String>>(extraQP);
            for (Pair pair : extraQPListCopy) {
                if (StringUtil.isEmpty((String)pair.first)) {
                    Logger.warn(TAG, "The extra query parameter.first is empty.");
                    continue;
                }
                if (((String)pair.first).equalsIgnoreCase("instance_aware")) {
                    Logger.verbose(TAG, "Set the extra query parameter mMultipleCloudAware for MicrosoftStsAuthorizationRequest.");
                    Logger.verbosePII(TAG, "Set the mMultipleCloudAware to " + (pair.second == null ? "null" : (String)pair.second));
                    requestAuthority.mMultipleCloudsSupported = null != pair.second && ((String)pair.second).equalsIgnoreCase(Boolean.TRUE.toString());
                    extraQP.remove(pair);
                    continue;
                }
                if (((String)pair.first).equalsIgnoreCase("slice")) {
                    slice.setSlice((String)pair.second);
                    extraQP.remove(pair);
                    continue;
                }
                if (!((String)pair.first).equalsIgnoreCase("dc")) continue;
                slice.setDataCenter((String)pair.second);
                extraQP.remove(pair);
            }
            Logger.verbose(TAG, "Set the extra query parameter mSlice for MicrosoftStsAuthorizationRequest.");
            Logger.verbosePII(TAG, "Set the mSlice to " + slice.toString());
            requestAuthority.mSlice = slice;
        }
        return requestAuthority;
    }
}

