/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.providers.microsoft.MicrosoftTokenResponse;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.RefreshToken;

public class MicrosoftRefreshToken
extends RefreshToken {
    private ClientInfo mClientInfo;
    private String mFamilyId;
    private String mScope;
    private String mClientId;
    private String mEnvironment;

    public MicrosoftRefreshToken(String rawRefreshToken, ClientInfo clientInfo, String scope, String clientId, String environment, @Nullable String familyId) {
        super(rawRefreshToken);
        this.mClientInfo = clientInfo;
        this.mScope = scope;
        this.mClientId = clientId;
        this.mEnvironment = environment;
        this.mFamilyId = familyId;
    }

    public MicrosoftRefreshToken(@NonNull MicrosoftTokenResponse tokenResponse) {
        super(tokenResponse);
        try {
            this.mClientInfo = new ClientInfo(tokenResponse.getClientInfo());
            this.mFamilyId = tokenResponse.getFamilyId();
            this.mScope = tokenResponse.getScope();
            this.mClientId = tokenResponse.getClientId();
        }
        catch (ServiceException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getHomeAccountId() {
        return SchemaUtil.getHomeAccountId(this.mClientInfo);
    }

    public void setEnvironment(String environment) {
        this.mEnvironment = environment;
    }

    @Override
    public String getEnvironment() {
        return this.mEnvironment;
    }

    @Override
    public String getClientId() {
        return this.mClientId;
    }

    @Override
    public String getSecret() {
        return this.getRefreshToken();
    }

    @Override
    public String getTarget() {
        return this.mScope;
    }

    @Override
    public String getFamilyId() {
        return this.mFamilyId;
    }

    public boolean getIsFamilyRefreshToken() {
        return !TextUtils.isEmpty((CharSequence)this.mFamilyId);
    }

    public ClientInfo getClientInfo() {
        return this.mClientInfo;
    }
}

