/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.identity.common.internal.providers.microsoft;

import android.net.Uri;
import android.support.annotation.NonNull;
import com.microsoft.identity.common.BaseAccount;
import com.microsoft.identity.common.adal.internal.util.DateExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.cache.SchemaUtil;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.ClientInfo;
import com.microsoft.identity.common.internal.providers.oauth2.IDToken;
import com.microsoft.identity.common.internal.util.StringUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;

public abstract class MicrosoftAccount
extends BaseAccount {
    public static final String AUTHORITY_TYPE_V1_V2 = "MSSTS";
    private static final String TAG = MicrosoftAccount.class.getSimpleName();
    private String mDisplayableId;
    private String mUniqueId;
    private String mName;
    private String mUid;
    private String mUtid;
    private IDToken mIDToken;
    private Uri mPasswordChangeUrl;
    private Date mPasswordExpiresOn;
    private String mTenantId;
    private String mGivenName;
    private String mFamilyName;
    private String mMiddleName;
    private String mEnvironment;
    private String mRawClientInfo;

    public MicrosoftAccount() {
        Logger.verbose(TAG, "Init: " + TAG);
    }

    public MicrosoftAccount(@NonNull IDToken idToken, @NonNull ClientInfo clientInfo) {
        Logger.verbose(TAG, "Init: " + TAG);
        this.mIDToken = idToken;
        this.mRawClientInfo = clientInfo.getRawClientInfo();
        Map<String, String> claims = idToken.getTokenClaims();
        this.mUniqueId = this.getUniqueId(claims);
        this.mDisplayableId = this.getDisplayableId(claims);
        this.mName = claims.get("name");
        this.mGivenName = claims.get("given_name");
        this.mFamilyName = claims.get("family_name");
        this.mMiddleName = claims.get("middle_name");
        if (!StringUtil.isEmpty(claims.get("tid"))) {
            this.mTenantId = claims.get("tid");
        } else if (!StringUtil.isEmpty(clientInfo.getUtid())) {
            Logger.warnPII(TAG, "realm is not returned from server. Use utid as realm.");
            this.mTenantId = clientInfo.getUtid();
        } else {
            Logger.warnPII(TAG, "realm and utid is not returned from server. Use empty string as default tid.");
            this.mTenantId = "";
        }
        this.mUid = clientInfo.getUid();
        this.mUtid = clientInfo.getUtid();
        long mPasswordExpiration = 0L;
        if (!StringExtensions.isNullOrBlank(claims.get("pwd_exp"))) {
            mPasswordExpiration = Long.parseLong(claims.get("pwd_exp"));
        }
        if (mPasswordExpiration > 0L) {
            GregorianCalendar expires = new GregorianCalendar();
            ((Calendar)expires).add(13, (int)mPasswordExpiration);
            this.mPasswordExpiresOn = expires.getTime();
        }
        this.mPasswordChangeUrl = null;
        if (!StringExtensions.isNullOrBlank(claims.get("pwd_url"))) {
            this.mPasswordChangeUrl = Uri.parse((String)claims.get("pwd_url"));
        }
    }

    protected abstract String getDisplayableId(Map<String, String> var1);

    private String getUniqueId(Map<String, String> claims) {
        String methodName = "getUniqueId";
        String uniqueId = null;
        if (!StringExtensions.isNullOrBlank(claims.get("oid"))) {
            Logger.info(TAG + ":" + "getUniqueId", "Using ObjectId as uniqueId");
            uniqueId = claims.get("oid");
        } else if (!StringExtensions.isNullOrBlank(claims.get("sub"))) {
            Logger.info(TAG + ":" + "getUniqueId", "Using Subject as uniqueId");
            uniqueId = claims.get("sub");
        }
        return uniqueId;
    }

    public void setFirstName(String givenName) {
        this.mGivenName = givenName;
    }

    public void setFamilyName(String familyName) {
        this.mFamilyName = familyName;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    public void setDisplayableId(String displayableId) {
        this.mDisplayableId = displayableId;
    }

    public String getUserId() {
        return this.mUniqueId;
    }

    public String getUid() {
        return this.mUid;
    }

    public void setUid(String uid) {
        this.mUid = uid;
    }

    public void setUtid(String uTid) {
        this.mUtid = uTid;
    }

    public void setName(String name) {
        this.mName = name;
    }

    public String getUtid() {
        return this.mUtid;
    }

    void setUserId(String userid) {
        this.mUniqueId = userid;
    }

    @Override
    public String getUniqueIdentifier() {
        return StringExtensions.base64UrlEncodeToString(this.mUid) + "." + StringExtensions.base64UrlEncodeToString(this.mUtid);
    }

    @Override
    public List<String> getCacheIdentifiers() {
        ArrayList<String> cacheIdentifiers = new ArrayList<String>();
        if (this.mDisplayableId != null) {
            cacheIdentifiers.add(this.mDisplayableId);
        }
        if (this.mUniqueId != null) {
            cacheIdentifiers.add(this.mUniqueId);
        }
        if (this.getUniqueIdentifier() != null) {
            cacheIdentifiers.add(this.getUniqueIdentifier());
        }
        return cacheIdentifiers;
    }

    public Uri getPasswordChangeUrl() {
        return this.mPasswordChangeUrl;
    }

    public Date getPasswordExpiresOn() {
        return DateExtensions.createCopy(this.mPasswordExpiresOn);
    }

    public IDToken getIDToken() {
        return this.mIDToken;
    }

    @Override
    public String getHomeAccountId() {
        return this.getUid() + "." + this.getUtid();
    }

    public void setEnvironment(String environment) {
        this.mEnvironment = environment;
    }

    @Override
    public String getEnvironment() {
        return this.mEnvironment;
    }

    @Override
    public String getRealm() {
        return this.mTenantId;
    }

    @Override
    public String getLocalAccountId() {
        return this.getUserId();
    }

    @Override
    public String getUsername() {
        return this.getDisplayableId();
    }

    @Override
    public String getAlternativeAccountId() {
        return SchemaUtil.getAlternativeAccountId(this.mIDToken);
    }

    @Override
    public String getFirstName() {
        return this.mGivenName;
    }

    @Override
    public String getFamilyName() {
        return this.mFamilyName;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getMiddleName() {
        return this.mMiddleName;
    }

    @Override
    public String getAvatarUrl() {
        return SchemaUtil.getAvatarUrl(this.mIDToken);
    }

    @Override
    public String getClientInfo() {
        return this.mRawClientInfo;
    }

    public String toString() {
        return "MicrosoftAccount{mDisplayableId='" + this.mDisplayableId + '\'' + ", mUniqueId='" + this.mUniqueId + '\'' + ", mName='" + this.mName + '\'' + ", mUid='" + this.mUid + '\'' + ", mUtid='" + this.mUtid + '\'' + ", mIDToken=" + this.mIDToken + ", mPasswordChangeUrl=" + this.mPasswordChangeUrl + ", mPasswordExpiresOn=" + this.mPasswordExpiresOn + ", mTenantId='" + this.mTenantId + '\'' + ", mGivenName='" + this.mGivenName + '\'' + ", mFamilyName='" + this.mFamilyName + '\'' + "} " + super.toString();
    }
}

